/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.client.renderer.shulker;

import com.google.common.primitives.SignedBytes;
import cpw.mods.ironchest.common.blocks.shulker.BlockIronShulkerBox;
import cpw.mods.ironchest.common.blocks.shulker.IronShulkerBoxType;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityIronShulkerBox;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelShulker;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class TileEntityIronShulkerBoxRenderer
extends TileEntitySpecialRenderer<TileEntityIronShulkerBox> {
    private Random random;
    private RenderEntityItem itemRenderer;
    private final ModelShulker model = new ModelShulker();
    private static float[][] shifts = new float[][]{{0.3f, 0.45f, 0.3f}, {0.7f, 0.45f, 0.3f}, {0.3f, 0.45f, 0.7f}, {0.7f, 0.45f, 0.7f}, {0.3f, 0.1f, 0.3f}, {0.7f, 0.1f, 0.3f}, {0.3f, 0.1f, 0.7f}, {0.7f, 0.1f, 0.7f}, {0.5f, 0.32f, 0.5f}};
    private static EntityItem customitem = new EntityItem(null);

    public TileEntityIronShulkerBoxRenderer() {
        this.random = new Random();
    }

    public void render(TileEntityIronShulkerBox te, double x, double y, double z, float partialTicks, int destroyStage, float partial) {
        IBlockState iblockstate;
        if (te == null || te.func_145837_r()) {
            return;
        }
        EnumFacing facing = EnumFacing.UP;
        IronShulkerBoxType type = te.getType();
        if (te.func_145830_o() && (iblockstate = this.func_178459_a().func_180495_p(te.func_174877_v())).func_177230_c() instanceof BlockIronShulkerBox) {
            facing = te.getFacing();
            type = (IronShulkerBoxType)((Object)iblockstate.func_177229_b(BlockIronShulkerBox.VARIANT_PROP));
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179129_p();
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            ResourceLocation rs = new ResourceLocation("ironchest", "textures/model/shulker/" + te.getColor().func_176610_l() + "/shulker_" + te.getColor().func_176610_l() + type.modelTexture);
            this.func_147499_a(rs);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        if (destroyStage < 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.9995f, (float)0.9995f, (float)0.9995f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        switch (facing) {
            case DOWN: {
                GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            default: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179109_b((float)-1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        this.model.field_187067_b.func_78785_a(0.0625f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-te.getProgress(partialTicks) * 0.5f), (float)0.0f);
        GlStateManager.func_179114_b((float)(270.0f * te.getProgress(partialTicks)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.model.field_187068_c.func_78785_a(0.0625f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        if (type == IronShulkerBoxType.CRYSTAL) {
            GlStateManager.func_179089_o();
        }
        if (type.isTransparent() && te.func_145835_a(this.field_147501_a.field_147560_j, this.field_147501_a.field_147561_k, this.field_147501_a.field_147558_l) < 128.0) {
            this.random.setSeed(254L);
            int shift = 0;
            float blockScale = 0.7f;
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTicks;
            if (((ItemStack)te.getTopItems().get(1)).func_190926_b()) {
                shift = 8;
                blockScale = 0.85f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            customitem.func_70029_a(this.func_178459_a());
            TileEntityIronShulkerBoxRenderer.customitem.field_70290_d = 0.0f;
            for (ItemStack item : te.getTopItems()) {
                if (shift > shifts.length || shift > 8) break;
                if (item.func_190926_b()) {
                    ++shift;
                    continue;
                }
                float shiftX = shifts[shift][0];
                float shiftY = shifts[shift][1];
                float shiftZ = shifts[shift][2];
                ++shift;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)shiftX, (float)shiftY, (float)shiftZ);
                GlStateManager.func_179114_b((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)blockScale, (float)blockScale, (float)blockScale);
                customitem.func_92058_a(item);
                if (this.itemRenderer == null) {
                    this.itemRenderer = new RenderEntityItem(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()){

                        public int func_177078_a(ItemStack stack) {
                            return SignedBytes.saturatedCast((long)(Math.min(stack.func_190916_E() / 32, 15) + 1));
                        }

                        public boolean shouldBob() {
                            return false;
                        }

                        public boolean shouldSpreadItems() {
                            return true;
                        }
                    };
                }
                this.itemRenderer.func_76986_a(customitem, 0.0, 0.0, 0.0, 0.0f, partialTicks);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }
}

