/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.util.AEPartLocation;
import appeng.block.AEBaseTileBlock;
import appeng.core.sync.GuiBridge;
import appeng.helpers.ICustomCollision;
import appeng.tile.storage.TileSkyChest;
import appeng.util.Platform;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSkyChest
extends AEBaseTileBlock
implements ICustomCollision {
    private static final double AABB_OFFSET_BOTTOM = 0.0;
    private static final double AABB_OFFSET_SIDES = 0.06;
    private static final double AABB_OFFSET_TOP = 0.125;
    public final SkyChestType type;

    public BlockSkyChest(SkyChestType type) {
        super(Material.field_151576_e);
        this.setOpaque(this.setFullSize(false));
        this.field_149786_r = 0;
        this.func_149711_c(50.0f);
        this.field_149781_w = 150.0f;
        this.type = type;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public boolean onActivated(World w, BlockPos pos, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (Platform.isServer()) {
            Platform.openGUI(player, this.getTileEntity((IBlockAccess)w, pos), AEPartLocation.fromFacing(side), GuiBridge.GUI_SKYCHEST);
        }
        return true;
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, BlockPos pos, Entity thePlayer, boolean b) {
        AxisAlignedBB aabb = this.computeAABB(w, pos);
        return Collections.singletonList(aabb);
    }

    @Override
    public void addCollidingBlockToList(World w, BlockPos pos, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        AxisAlignedBB aabb = this.computeAABB(w, pos);
        out.add(aabb);
    }

    private AxisAlignedBB computeAABB(World w, BlockPos pos) {
        TileSkyChest sk = (TileSkyChest)this.getTileEntity((IBlockAccess)w, pos);
        EnumFacing o = EnumFacing.UP;
        if (sk != null) {
            o = sk.getUp();
        }
        double offsetX = o.func_82601_c() == 0 ? 0.06 : 0.0;
        double offsetY = o.func_96559_d() == 0 ? 0.06 : 0.0;
        double offsetZ = o.func_82599_e() == 0 ? 0.06 : 0.0;
        double minX = Math.max(0.0, offsetX + (o.func_82601_c() < 0 ? 0.0 : (double)o.func_82601_c() * 0.125));
        double minY = Math.max(0.0, offsetY + (o.func_96559_d() < 0 ? 0.125 : (double)o.func_96559_d() * 0.0));
        double minZ = Math.max(0.0, offsetZ + (o.func_82599_e() < 0 ? 0.0 : (double)o.func_82599_e() * 0.125));
        double maxX = Math.min(1.0, 1.0 - offsetX - (o.func_82601_c() < 0 ? 0.125 : (double)o.func_82601_c() * 0.0));
        double maxY = Math.min(1.0, 1.0 - offsetY - (o.func_96559_d() < 0 ? 0.0 : (double)o.func_96559_d() * 0.125));
        double maxZ = Math.min(1.0, 1.0 - offsetZ - (o.func_82599_e() < 0 ? 0.125 : (double)o.func_82599_e() * 0.0));
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static enum SkyChestType {
        STONE,
        BLOCK;

    }
}

