/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.gui.GuiBetterAdvancementTab;
import betteradvancements.reference.Resources;
import betteradvancements.util.RenderUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.advancements.AdvancementState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBetterAdvancement
extends Gui {
    private static final int ADVANCEMENT_SIZE = 26;
    private static final int CORNER_SIZE = 10;
    private static final int WIDGET_WIDTH = 200;
    private static final int WIDGET_HEIGHT = 20;
    private static final int TITLE_SIZE = 32;
    private static final Pattern PATTERN = Pattern.compile("(.+) \\S+");
    private final GuiBetterAdvancementTab guiBetterAdvancementTab;
    private final Advancement advancement;
    private final BetterDisplayInfo betterDisplayInfo;
    private final DisplayInfo displayInfo;
    private final String title;
    private final int width;
    private final List<String> description;
    private final Minecraft minecraft;
    private GuiBetterAdvancement parent;
    private final List<GuiBetterAdvancement> children = Lists.newArrayList();
    private AdvancementProgress advancementProgress;
    private final int x;
    private final int y;

    public GuiBetterAdvancement(GuiBetterAdvancementTab guiBetterAdvancementTab, Minecraft mc, Advancement advancement, DisplayInfo displayInfo) {
        this.guiBetterAdvancementTab = guiBetterAdvancementTab;
        this.advancement = advancement;
        this.betterDisplayInfo = guiBetterAdvancementTab.getBetterDisplayInfo(advancement);
        this.displayInfo = displayInfo;
        this.minecraft = mc;
        this.title = mc.field_71466_p.func_78269_a(displayInfo.func_192297_a().func_150254_d(), 163);
        this.x = MathHelper.func_76141_d((float)(displayInfo.func_192299_e() * 32.0f));
        this.y = MathHelper.func_76141_d((float)(displayInfo.func_192296_f() * 27.0f));
        int i = advancement.func_193124_g();
        int j = String.valueOf(i).length();
        int k = i > 1 ? mc.field_71466_p.func_78256_a("  ") + mc.field_71466_p.func_78256_a("0") * j * 2 + mc.field_71466_p.func_78256_a("/") : 0;
        int l = 29 + mc.field_71466_p.func_78256_a(this.title) + k;
        String s = displayInfo.func_193222_b().func_150254_d();
        this.description = this.findOptimalLines(s, l);
        for (String s1 : this.description) {
            l = Math.max(l, mc.field_71466_p.func_78256_a(s1));
        }
        this.width = l + 3 + 5;
    }

    private List<String> findOptimalLines(String line, int width) {
        int j;
        if (line.isEmpty()) {
            return Collections.emptyList();
        }
        List list = this.minecraft.field_71466_p.func_78271_c(line, width);
        if (list.size() < 2) {
            return list;
        }
        String s = (String)list.get(0);
        String s1 = (String)list.get(1);
        int i = this.minecraft.field_71466_p.func_78256_a(s + ' ' + s1.split(" ")[0]);
        if (i - width <= 10) {
            return this.minecraft.field_71466_p.func_78271_c(line, i);
        }
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches() && width - (j = this.minecraft.field_71466_p.func_78256_a(matcher.group(1))) <= 10) {
            return this.minecraft.field_71466_p.func_78271_c(line, j);
        }
        return list;
    }

    @Nullable
    private GuiBetterAdvancement getFirstVisibleParent(Advancement advancementIn) {
        while ((advancementIn = advancementIn.func_192070_b()) != null && advancementIn.func_192068_c() == null) {
        }
        if (advancementIn != null && advancementIn.func_192068_c() != null) {
            return this.guiBetterAdvancementTab.getAdvancementGui(advancementIn);
        }
        return null;
    }

    public void drawConnectivity(int scrollX, int scrollY, boolean drawInside) {
        if (this.parent != null) {
            int color;
            int startX = scrollX + this.parent.x + 13;
            int endXHalf = scrollX + this.parent.x + 26 + 6;
            int startY = scrollY + this.parent.y + 13;
            int endX = scrollX + this.x + 13;
            int endY = scrollY + this.y + 13;
            int n = color = drawInside ? -16777216 : -1;
            if (drawInside) {
                this.func_73730_a(endXHalf, startX, startY - 1, color);
                this.func_73730_a(endXHalf + 1, startX, startY, color);
                this.func_73730_a(endXHalf, startX, startY + 1, color);
                this.func_73730_a(endX, endXHalf - 1, endY - 1, color);
                this.func_73730_a(endX, endXHalf - 1, endY, color);
                this.func_73730_a(endX, endXHalf - 1, endY + 1, color);
                this.func_73728_b(endXHalf - 1, endY, startY, color);
                this.func_73728_b(endXHalf + 1, endY, startY, color);
            } else {
                this.func_73730_a(endXHalf, startX, startY, color);
                this.func_73730_a(endX, endXHalf, endY, color);
                this.func_73728_b(endXHalf, endY, startY, color);
            }
        }
        for (GuiBetterAdvancement guiBetterAdvancement : this.children) {
            guiBetterAdvancement.drawConnectivity(scrollX, scrollY, drawInside);
        }
    }

    public void draw(int scrollX, int scrollY) {
        if (!this.displayInfo.func_193224_j() || this.advancementProgress != null && this.advancementProgress.func_192105_a()) {
            float f = this.advancementProgress == null ? 0.0f : this.advancementProgress.func_192103_c();
            AdvancementState advancementstate = f >= 1.0f ? AdvancementState.OBTAINED : AdvancementState.UNOBTAINED;
            this.minecraft.func_110434_K().func_110577_a(Resources.Gui.WIDGETS);
            RenderUtil.setColor(advancementstate == AdvancementState.OBTAINED ? this.betterDisplayInfo.getCompletedIconColor() : this.betterDisplayInfo.getUnCompletedIconColor());
            GlStateManager.func_179147_l();
            this.func_73729_b(scrollX + this.x + 3, scrollY + this.y, this.displayInfo.func_192291_d().func_192309_b(), 154, 26, 26);
            RenderHelper.func_74520_c();
            this.minecraft.func_175599_af().func_184391_a(null, this.displayInfo.func_192298_b(), scrollX + this.x + 8, scrollY + this.y + 5);
        }
        for (GuiBetterAdvancement guiBetterAdvancement : this.children) {
            guiBetterAdvancement.draw(scrollX, scrollY);
        }
    }

    public void getAdvancementProgress(AdvancementProgress advancementProgressIn) {
        this.advancementProgress = advancementProgressIn;
    }

    public void addGuiAdvancement(GuiBetterAdvancement guiBetterAdvancement) {
        this.children.add(guiBetterAdvancement);
    }

    public void drawHover(int scrollX, int scrollY, float fade, int left, int top) {
        AdvancementState advancementstate2;
        AdvancementState advancementstate1;
        AdvancementState advancementstate;
        boolean drawLeft = left + scrollX + this.x + this.width + 26 >= this.guiBetterAdvancementTab.getScreen().field_146294_l;
        String s = this.advancementProgress == null ? null : this.advancementProgress.func_193126_d();
        int i = s == null ? 0 : this.minecraft.field_71466_p.func_78256_a(s);
        boolean drawTop = top + scrollY + this.y + this.description.size() * this.minecraft.field_71466_p.field_78288_b + 50 >= this.guiBetterAdvancementTab.getScreen().field_146295_m;
        float percentageObtained = this.advancementProgress == null ? 0.0f : this.advancementProgress.func_192103_c();
        int j = MathHelper.func_76141_d((float)(percentageObtained * (float)this.width));
        if (percentageObtained >= 1.0f) {
            j = this.width / 2;
            advancementstate = AdvancementState.OBTAINED;
            advancementstate1 = AdvancementState.OBTAINED;
            advancementstate2 = AdvancementState.OBTAINED;
        } else if (j < 2) {
            j = this.width / 2;
            advancementstate = AdvancementState.UNOBTAINED;
            advancementstate1 = AdvancementState.UNOBTAINED;
            advancementstate2 = AdvancementState.UNOBTAINED;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            advancementstate = AdvancementState.OBTAINED;
            advancementstate1 = AdvancementState.OBTAINED;
            advancementstate2 = AdvancementState.UNOBTAINED;
        } else {
            advancementstate = AdvancementState.OBTAINED;
            advancementstate1 = AdvancementState.UNOBTAINED;
            advancementstate2 = AdvancementState.UNOBTAINED;
        }
        int k = this.width - j;
        this.minecraft.func_110434_K().func_110577_a(Resources.Gui.WIDGETS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        int drawY = scrollY + this.y;
        int drawX = drawLeft ? scrollX + this.x - this.width + 26 + 6 : scrollX + this.x;
        int boxHeight = 32 + this.description.size() * this.minecraft.field_71466_p.field_78288_b;
        if (!this.description.isEmpty()) {
            if (drawTop) {
                this.render9Sprite(drawX, drawY + 26 - boxHeight, this.width, boxHeight, 10, 200, 26, 0, 52);
            } else {
                this.render9Sprite(drawX, drawY, this.width, boxHeight, 10, 200, 26, 0, 52);
            }
        }
        RenderUtil.setColor(advancementstate == AdvancementState.OBTAINED ? this.betterDisplayInfo.getCompletedTitleColor() : this.betterDisplayInfo.getUnCompletedTitleColor());
        this.func_73729_b(drawX, drawY, 0, 78, j, 26);
        RenderUtil.setColor(advancementstate1 == AdvancementState.OBTAINED ? this.betterDisplayInfo.getCompletedTitleColor() : this.betterDisplayInfo.getUnCompletedTitleColor());
        this.func_73729_b(drawX + j, drawY, 200 - k, 78, k, 26);
        RenderUtil.setColor(advancementstate2 == AdvancementState.OBTAINED ? this.betterDisplayInfo.getCompletedIconColor() : this.betterDisplayInfo.getUnCompletedIconColor());
        this.func_73729_b(scrollX + this.x + 3, scrollY + this.y, this.displayInfo.func_192291_d().func_192309_b(), 154, 26, 26);
        if (drawLeft) {
            this.minecraft.field_71466_p.func_175065_a(this.title, (float)(drawX + 5), (float)(scrollY + this.y + 9), -1, true);
            if (s != null) {
                this.minecraft.field_71466_p.func_175065_a(s, (float)(scrollX + this.x - i), (float)(scrollY + this.y + 9), -1, true);
            }
        } else {
            this.minecraft.field_71466_p.func_175065_a(this.title, (float)(scrollX + this.x + 32), (float)(scrollY + this.y + 9), -1, true);
            if (s != null) {
                this.minecraft.field_71466_p.func_175065_a(s, (float)(scrollX + this.x + this.width - i - 5), (float)(scrollY + this.y + 9), -1, true);
            }
        }
        if (drawTop) {
            for (int k1 = 0; k1 < this.description.size(); ++k1) {
                this.minecraft.field_71466_p.func_175065_a(this.description.get(k1), (float)(drawX + 5), (float)(drawY + 26 - boxHeight + 7 + k1 * this.minecraft.field_71466_p.field_78288_b), -5592406, false);
            }
        } else {
            for (int l1 = 0; l1 < this.description.size(); ++l1) {
                this.minecraft.field_71466_p.func_175065_a(this.description.get(l1), (float)(drawX + 5), (float)(scrollY + this.y + 9 + 17 + l1 * this.minecraft.field_71466_p.field_78288_b), -5592406, false);
            }
        }
        RenderHelper.func_74520_c();
        this.minecraft.func_175599_af().func_184391_a(null, this.displayInfo.func_192298_b(), scrollX + this.x + 8, scrollY + this.y + 5);
    }

    protected void render9Sprite(int x, int y, int width, int height, int textureHeight, int textureWidth, int textureDistance, int textureX, int textureY) {
        this.func_73729_b(x, y, textureX, textureY, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, x + textureHeight, y, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY, textureWidth - textureHeight - textureHeight, textureDistance);
        this.func_73729_b(x + width - textureHeight, y, textureX + textureWidth - textureHeight, textureY, textureHeight, textureHeight);
        this.func_73729_b(x, y + height - textureHeight, textureX, textureY + textureDistance - textureHeight, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, x + textureHeight, y + height - textureHeight, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY + textureDistance - textureHeight, textureWidth - textureHeight - textureHeight, textureDistance);
        this.func_73729_b(x + width - textureHeight, y + height - textureHeight, textureX + textureWidth - textureHeight, textureY + textureDistance - textureHeight, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, x, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(this, x + textureHeight, y + textureHeight, width - textureHeight - textureHeight, height - textureHeight - textureHeight, textureX + textureHeight, textureY + textureHeight, textureWidth - textureHeight - textureHeight, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(this, x + width - textureHeight, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX + textureWidth - textureHeight, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
    }

    public boolean isMouseOver(int scrollX, int scrollY, int mouseX, int mouseY) {
        if (!this.displayInfo.func_193224_j() || this.advancementProgress != null && this.advancementProgress.func_192105_a()) {
            int left = scrollX + this.x;
            int right = left + 26;
            int top = scrollY + this.y;
            int bottom = top + 26;
            return mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
        }
        return false;
    }

    public void attachToParent() {
        if (this.parent == null && this.advancement.func_192070_b() != null) {
            this.parent = this.getFirstVisibleParent(this.advancement);
            if (this.parent != null) {
                this.parent.addGuiAdvancement(this);
            }
        }
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }
}

