/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.events;

import com.feed_the_beast.ftbguides.events.FTBGuidesEvent;
import com.feed_the_beast.ftbguides.gui.GuidePage;
import com.feed_the_beast.ftbguides.gui.GuideTitlePage;
import com.feed_the_beast.ftbguides.gui.GuideType;
import java.util.Map;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ClientGuideEvent
extends FTBGuidesEvent {
    private final GuidePage root;
    private final Map<String, GuideTitlePage> map;

    public ClientGuideEvent(GuidePage r, Map<String, GuideTitlePage> m) {
        this.root = r;
        this.map = m;
    }

    public GuideTitlePage getModPage(String modid) {
        GuideTitlePage page = this.map.get(modid);
        if (page == null) {
            page = new GuideTitlePage(modid, this.root, GuideType.MOD);
            page.isPresent = true;
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modid);
            if (mod != null) {
                page.authors.addAll(mod.getMetadata().authorList);
                if (!mod.getMetadata().description.isEmpty()) {
                    for (String s : mod.getMetadata().description.split("\n")) {
                        page.println(s);
                    }
                }
                page.title = new TextComponentString(mod.getName());
            }
            this.map.put(modid, page);
        }
        return page;
    }

    public GuideTitlePage getOtherPage(String id) {
        GuideTitlePage page = this.map.get(id);
        if (page == null) {
            page = new GuideTitlePage(id, this.root, GuideType.OTHER);
            page.isPresent = true;
            this.map.put(id, page);
        }
        return page;
    }
}

