/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.transform;

import com.enderio.core.common.transform.SimpleMixin;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=0x7FFFFFFF)
public class EnderCorePlugin
implements IFMLLoadingPlugin {
    static final Logger mainLogger = LogManager.getLogger((String)"EnderCore ASM");
    static final Logger mixinLogger = LogManager.getLogger((String)"EnderCore Mixins");
    public static boolean runtimeDeobfEnabled = false;
    private static EnderCorePlugin instance;
    List<InterfacePatchData> ifacePatches = new ArrayList<InterfacePatchData>();

    public EnderCorePlugin() {
        if (instance != null) {
            throw new IllegalStateException("EnderCorePlugin was instantiated twice?");
        }
        instance = this;
    }

    @Nonnull
    public static EnderCorePlugin instance() {
        EnderCorePlugin inst = instance;
        if (inst == null) {
            throw new IllegalStateException("EnderCorePlugin accessed too early!");
        }
        return inst;
    }

    public void addInterfacePatch(String target, String source) {
        InterfacePatchData data = new InterfacePatchData(target, source);
        this.ifacePatches.add(data);
    }

    public void loadPatchSources() {
        this.findAnnotationPatches();
        this.ifacePatches.forEach(InterfacePatchData::initialize);
    }

    private void findAnnotationPatches() {
        try {
            Field fDiscoverer = Loader.class.getDeclaredField("discoverer");
            fDiscoverer.setAccessible(true);
            ModDiscoverer discoverer = (ModDiscoverer)fDiscoverer.get(Loader.instance());
            ASMDataTable asmData = discoverer.getASMTable();
            Set data = asmData.getAll(SimpleMixin.class.getName());
            for (ASMDataTable.ASMData d : data) {
                mixinLogger.info("Found annotation mixin: {}", (Object)d.getClassName());
                List dependencies = (List)d.getAnnotationInfo().get("dependencies");
                List missingDependencies = dependencies.stream().filter(m -> !Loader.isModLoaded((String)m) && !ModAPIManager.INSTANCE.hasAPI(m)).collect(Collectors.toList());
                if (missingDependencies.size() == 0) {
                    this.addInterfacePatch(((Type)d.getAnnotationInfo().get("value")).getClassName(), d.getClassName());
                    mixinLogger.info("Registered mixin.");
                    continue;
                }
                mixinLogger.info("Skipping mixin due to missing dependencies: {}", missingDependencies);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getASMTransformerClass() {
        return new String[]{"com.enderio.core.common.transform.EnderCoreTransformer", "com.enderio.core.common.transform.SimpleMixinPatcher"};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        runtimeDeobfEnabled = (Boolean)data.get("runtimeDeobfuscationEnabled");
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static class InterfacePatchData {
        public final String target;
        public final String source;

        InterfacePatchData(String target, String source) {
            this.target = target;
            this.source = source;
        }

        void initialize() {
            try {
                Class<?> cls = Class.forName(this.source);
                cls.getName();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

