/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis.buttons;

import net.minecraft.entity.player.EntityPlayer;
import vswe.stevescarts.computer.ComputerTask;
import vswe.stevescarts.guis.buttons.ButtonAssembly;
import vswe.stevescarts.guis.buttons.ButtonBase;
import vswe.stevescarts.modules.workers.ModuleComputer;

public class ButtonFlowEndType
extends ButtonAssembly {
    private int typeId;

    public ButtonFlowEndType(ModuleComputer module, ButtonBase.LOCATION loc, int typeId) {
        super(module, loc);
        this.typeId = typeId;
    }

    @Override
    public String toString() {
        return "Change to End " + ComputerTask.getEndTypeName(this.typeId);
    }

    @Override
    public int texture() {
        return ComputerTask.getEndImage(this.typeId);
    }

    @Override
    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        if (((ModuleComputer)this.module).getSelectedTasks() != null && ((ModuleComputer)this.module).getSelectedTasks().size() > 0) {
            for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
                if (task.isFlowEnd()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
            if (this.typeId == task.getFlowEndType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onServerClick(EntityPlayer player, int mousebutton, boolean ctrlKey, boolean shiftKey) {
        for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
            task.setFlowEndType(this.typeId);
        }
    }
}

