/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.entitys;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.MovingSoundMinecart;
import net.minecraft.client.audio.MovingSoundMinecartRiding;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.entitys.EntityDataManagerLockable;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.ActivatorOption;
import vswe.stevescarts.helpers.CartVersion;
import vswe.stevescarts.helpers.DetectorType;
import vswe.stevescarts.helpers.GuiAllocationHelper;
import vswe.stevescarts.helpers.ModuleCountPair;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.items.ModItems;
import vswe.stevescarts.models.ModelCartbase;
import vswe.stevescarts.modules.IActivatorModule;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.addons.ModuleCreativeSupplies;
import vswe.stevescarts.modules.data.ModuleData;
import vswe.stevescarts.modules.engines.ModuleEngine;
import vswe.stevescarts.modules.storages.chests.ModuleChest;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;
import vswe.stevescarts.modules.workers.CompWorkModule;
import vswe.stevescarts.modules.workers.ModuleWorker;
import vswe.stevescarts.modules.workers.tools.ModuleTool;

public class EntityMinecartModular
extends EntityMinecart
implements IInventory,
IEntityAdditionalSpawnData,
IFluidHandler {
    public BlockPos disabledPos;
    protected boolean wasDisabled;
    public double pushX;
    public double pushZ;
    public double temppushX;
    public double temppushZ;
    protected boolean engineFlag = false;
    private int motorRotation;
    public boolean cornerFlip;
    private BlockRailBase.EnumRailDirection fixedRailDirection = null;
    private BlockPos fixedRailPos;
    private byte[] moduleLoadingData;
    private ForgeChunkManager.Ticket cartTicket;
    private int wrongRender;
    private boolean oldRender;
    private float lastRenderYaw;
    private double lastMotionX;
    private double lastMotionZ;
    private int workingTime;
    private ModuleWorker workingComponent;
    public TileEntityCartAssembler placeholderAsssembler;
    public boolean isPlaceholder;
    public int keepAlive;
    public static final int MODULAR_SPACE_WIDTH = 443;
    public static final int MODULAR_SPACE_HEIGHT = 168;
    public int modularSpaceHeight;
    public boolean canScrollModules;
    private ArrayList<ModuleCountPair> moduleCounts;
    public static final int[][][] railDirectionCoordinates;
    private ArrayList<ModuleBase> modules;
    private ArrayList<ModuleWorker> workModules;
    private ArrayList<ModuleEngine> engineModules;
    private ArrayList<ModuleTank> tankModules;
    private ModuleCreativeSupplies creativeSupplies;
    public Random random = new Random();
    protected String name;
    public byte cartVersion;
    private int scrollY;
    @SideOnly(value=Side.CLIENT)
    private MovingSound sound;
    @SideOnly(value=Side.CLIENT)
    private MovingSound soundRiding;
    @SideOnly(value=Side.CLIENT)
    private int keepSilent;
    private static final DataParameter<Boolean> IS_BURNING;
    private static final DataParameter<Boolean> IS_DISANABLED;
    int base = 0;

    public ArrayList<ModuleBase> getModules() {
        return this.modules;
    }

    public boolean hasModule(Class<? extends ModuleBase> module) {
        for (ModuleBase moduleBase : this.getModules()) {
            if (!moduleBase.getClass().equals(module)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ModuleWorker> getWorkers() {
        return this.workModules;
    }

    public ArrayList<ModuleEngine> getEngines() {
        return this.engineModules;
    }

    public ArrayList<ModuleTank> getTanks() {
        return this.tankModules;
    }

    public ArrayList<ModuleCountPair> getModuleCounts() {
        return this.moduleCounts;
    }

    public EntityMinecartModular(World world, double x, double y, double z, NBTTagCompound info, String name) {
        super(world, x, y, z);
        this.cartVersion = info.func_74771_c("CartVersion");
        this.loadModules(info);
        this.name = name;
        for (int i = 0; i < this.modules.size(); ++i) {
            if (!this.modules.get(i).hasExtraData() || !info.func_74764_b("Data" + i)) continue;
            this.modules.get(i).setExtraData(info.func_74771_c("Data" + i));
        }
    }

    public EntityMinecartModular(World world) {
        super(world);
    }

    public EntityMinecartModular(World world, TileEntityCartAssembler assembler, byte[] data) {
        this(world);
        this.setPlaceholder(assembler);
        this.loadPlaceholderModules(data);
    }

    private void overrideDatawatcher() {
        this.field_70180_af = new EntityDataManagerLockable((Entity)this);
    }

    private void loadPlaceholderModules(byte[] data) {
        if (this.modules == null) {
            this.modules = new ArrayList();
            this.doLoadModules(data);
        } else {
            int i;
            ArrayList<Byte> modulesToAdd = new ArrayList<Byte>();
            ArrayList<Byte> oldModules = new ArrayList<Byte>();
            for (i = 0; i < this.moduleLoadingData.length; ++i) {
                oldModules.add(this.moduleLoadingData[i]);
            }
            for (i = 0; i < data.length; ++i) {
                boolean found = false;
                for (int j = 0; j < oldModules.size(); ++j) {
                    if (data[i] != (Byte)oldModules.get(j)) continue;
                    found = true;
                    oldModules.remove(j);
                    break;
                }
                if (found) continue;
                modulesToAdd.add(data[i]);
            }
            Iterator i2 = oldModules.iterator();
            block3: while (i2.hasNext()) {
                byte id = (Byte)i2.next();
                for (int k = 0; k < this.modules.size(); ++k) {
                    if (id != this.modules.get(k).getModuleId()) continue;
                    this.modules.remove(k);
                    continue block3;
                }
            }
            byte[] newModuleData = new byte[modulesToAdd.size()];
            for (int l = 0; l < modulesToAdd.size(); ++l) {
                newModuleData[l] = (Byte)modulesToAdd.get(l);
            }
            this.doLoadModules(newModuleData);
        }
        this.initModules();
        this.moduleLoadingData = data;
    }

    private void loadModules(NBTTagCompound info) {
        NBTTagByteArray moduleIDTag = (NBTTagByteArray)info.func_74781_a("Modules");
        if (moduleIDTag == null) {
            return;
        }
        this.moduleLoadingData = this.field_70170_p.field_72995_K ? moduleIDTag.func_150292_c() : CartVersion.updateCart(this, moduleIDTag.func_150292_c());
        this.loadModules(this.moduleLoadingData);
    }

    public void updateSimulationModules(byte[] bytes) {
        if (!this.isPlaceholder) {
            System.out.println("You're stupid! This is not a placeholder cart.");
        } else {
            this.loadPlaceholderModules(bytes);
        }
    }

    protected void loadModules(byte[] bytes) {
        this.modules = new ArrayList();
        this.doLoadModules(bytes);
        this.initModules();
    }

    private void doLoadModules(byte[] bytes) {
        for (byte id : bytes) {
            try {
                ModuleBase moduleObject;
                Class<? extends ModuleBase> moduleClass = ModuleData.getList().get(id).getModuleClass();
                Constructor<? extends ModuleBase> moduleConstructor = moduleClass.getConstructor(EntityMinecartModular.class);
                ModuleBase module = moduleObject = moduleConstructor.newInstance(new Object[]{this});
                module.setModuleId(id);
                this.modules.add(module);
            }
            catch (Exception e) {
                System.out.println("Failed to load module with ID " + id + "! More info below.");
                e.printStackTrace();
            }
        }
    }

    private void initModules() {
        this.moduleCounts = new ArrayList();
        for (ModuleBase module : this.modules) {
            ModuleData data = ModuleData.getList().get(module.getModuleId());
            boolean found = false;
            for (ModuleCountPair moduleCountPair : this.moduleCounts) {
                if (!moduleCountPair.isContainingData(data)) continue;
                moduleCountPair.increase();
                found = true;
                break;
            }
            if (found) continue;
            this.moduleCounts.add(new ModuleCountPair(data));
        }
        for (ModuleBase module : this.modules) {
            module.preInit();
        }
        this.workModules = new ArrayList();
        this.engineModules = new ArrayList();
        this.tankModules = new ArrayList();
        boolean x = false;
        boolean y = false;
        boolean maxH = false;
        int guidata = 0;
        int packets = 0;
        if (this.field_70170_p.field_72995_K) {
            this.generateModels();
        }
        for (ModuleBase module2 : this.modules) {
            if (module2 instanceof ModuleWorker) {
                this.workModules.add((ModuleWorker)module2);
                continue;
            }
            if (module2 instanceof ModuleEngine) {
                this.engineModules.add((ModuleEngine)module2);
                continue;
            }
            if (module2 instanceof ModuleTank) {
                this.tankModules.add((ModuleTank)module2);
                continue;
            }
            if (!(module2 instanceof ModuleCreativeSupplies)) continue;
            this.creativeSupplies = (ModuleCreativeSupplies)module2;
        }
        CompWorkModule compWorkModule = new CompWorkModule();
        this.workModules.sort(compWorkModule);
        if (!this.isPlaceholder) {
            ArrayList<GuiAllocationHelper> lines = new ArrayList<GuiAllocationHelper>();
            int slots = 0;
            for (ModuleBase module3 : this.modules) {
                if (module3.hasGui()) {
                    boolean foundLine = false;
                    for (GuiAllocationHelper line : lines) {
                        if (line.width + module3.guiWidth() > 443) continue;
                        module3.setX(line.width);
                        GuiAllocationHelper guiAllocationHelper = line;
                        guiAllocationHelper.width += module3.guiWidth();
                        line.maxHeight = Math.max(line.maxHeight, module3.guiHeight());
                        line.modules.add(module3);
                        foundLine = true;
                        break;
                    }
                    if (!foundLine) {
                        GuiAllocationHelper line2 = new GuiAllocationHelper();
                        module3.setX(0);
                        line2.width = module3.guiWidth();
                        line2.maxHeight = module3.guiHeight();
                        line2.modules.add(module3);
                        lines.add(line2);
                    }
                    module3.setGuiDataStart(guidata);
                    guidata += module3.numberOfGuiData();
                    if (module3.hasSlots()) {
                        slots = module3.generateSlots(slots);
                    }
                }
                if (module3.numberOfDataWatchers() > 0) {
                    module3.initDw();
                }
                module3.setPacketStart(packets);
                packets += module3.totalNumberOfPackets();
            }
            int currentY = 0;
            for (GuiAllocationHelper line3 : lines) {
                for (ModuleBase module4 : line3.modules) {
                    module4.setY(currentY);
                }
                currentY += line3.maxHeight;
            }
            if (currentY > 168) {
                this.canScrollModules = true;
            }
            this.modularSpaceHeight = currentY;
        }
        for (ModuleBase module5 : this.modules) {
            module5.init();
        }
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            for (int var1 = 0; var1 < this.func_70302_i_(); ++var1) {
                this.func_70299_a(var1, ItemStack.field_190927_a);
            }
        }
        super.func_70106_y();
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.onDeath();
            }
        }
        this.dropChunkLoading();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(Minecraft minecraft) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.renderOverlay(minecraft);
            }
        }
    }

    protected void func_70088_a() {
        if (this.field_70170_p.field_72995_K && !(this.field_70180_af instanceof EntityDataManagerLockable)) {
            this.overrideDatawatcher();
        }
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BURNING, (Object)false);
        this.field_70180_af.func_187214_a(IS_DISANABLED, (Object)false);
    }

    public void updateFuel() {
        ModuleEngine engine;
        int consumption = this.getConsumption();
        if (consumption > 0 && (engine = this.getCurrentEngine()) != null) {
            engine.consumeFuel(consumption);
            if (!this.isPlaceholder && this.field_70170_p.field_72995_K && this.hasFuel() && !this.isDisabled()) {
                engine.smoke();
            }
        }
        if (this.hasFuel()) {
            if (!this.engineFlag) {
                this.pushX = this.temppushX;
                this.pushZ = this.temppushZ;
            }
        } else if (this.engineFlag) {
            this.temppushX = this.pushX;
            this.temppushZ = this.pushZ;
            double n = 0.0;
            this.pushZ = 0.0;
            this.pushX = 0.0;
        }
        this.setEngineBurning(this.hasFuel() && !this.isDisabled());
    }

    public boolean isEngineBurning() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BURNING);
    }

    public void setEngineBurning(boolean on) {
        this.field_70180_af.func_187227_b(IS_BURNING, (Object)on);
    }

    private ModuleEngine getCurrentEngine() {
        if (this.modules == null) {
            return null;
        }
        for (ModuleBase module : this.modules) {
            if (!module.stopEngines()) continue;
            return null;
        }
        int consumption = this.getConsumption(true);
        ArrayList<ModuleEngine> priority = new ArrayList<ModuleEngine>();
        int mostImportant = -1;
        for (ModuleEngine engine : this.engineModules) {
            if (!engine.hasFuel(consumption) || mostImportant != -1 && mostImportant < engine.getPriority()) continue;
            if (engine.getPriority() < mostImportant) {
                priority.clear();
            }
            mostImportant = engine.getPriority();
            priority.add(engine);
        }
        if (priority.size() > 0) {
            if (this.motorRotation >= priority.size()) {
                this.motorRotation = 0;
            }
            this.motorRotation = (this.motorRotation + 1) % priority.size();
            return (ModuleEngine)priority.get(this.motorRotation);
        }
        return null;
    }

    public int getConsumption() {
        return this.getConsumption(!this.isDisabled() && this.isEngineBurning());
    }

    public int getConsumption(boolean isMoving) {
        int consumption;
        int n = consumption = isMoving ? 1 : 0;
        if (this.modules != null && !this.isPlaceholder) {
            for (ModuleBase module : this.modules) {
                consumption += module.getConsumption(isMoving);
            }
        }
        return consumption;
    }

    public float func_70047_e() {
        return 0.9f;
    }

    public double func_70042_X() {
        if (this.modules != null && !this.func_184188_bt().isEmpty()) {
            for (ModuleBase module : this.modules) {
                float offset = module.mountedOffset((Entity)this.func_184188_bt().get(0));
                if (offset == 0.0f) continue;
                return offset;
            }
        }
        return super.func_70042_X();
    }

    @Nonnull
    public ItemStack getCartItem() {
        if (this.modules != null) {
            ItemStack cart = ModuleData.createModularCart(this);
            if (this.name != null && !this.name.equals("") && !this.name.equals(ModItems.CARTS.getName())) {
                cart.func_151001_c(this.name);
            }
            return cart;
        }
        return new ItemStack((Item)ModItems.CARTS);
    }

    public void func_94095_a(DamageSource dmg) {
        this.func_70106_y();
        if (this.dropOnDeath()) {
            this.func_70099_a(this.getCartItem(), 0.0f);
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack itemstack = this.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                float f3 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.func_190916_E() > 0) {
                    int j = this.random.nextInt(21) + 10;
                    if (j > itemstack.func_190916_E()) {
                        j = itemstack.func_190916_E();
                    }
                    ItemStack itemStack = itemstack;
                    itemStack.func_190918_g(j);
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)f, this.field_70163_u + (double)f2, this.field_70161_v + (double)f3, new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77952_i()));
                    float f4 = 0.05f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * 0.05f;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * 0.05f + 0.2f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * 0.05f;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
            }
        }
    }

    public boolean dropOnDeath() {
        if (this.isPlaceholder) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (module.dropOnDeath()) continue;
                return false;
            }
        }
        return true;
    }

    public float getMaxCartSpeedOnRail() {
        float maxSpeed = super.getMaxCartSpeedOnRail();
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                float tempMax = module.getMaxSpeed();
                if (!(tempMax < maxSpeed)) continue;
                maxSpeed = tempMax;
            }
        }
        return maxSpeed;
    }

    public boolean isPoweredCart() {
        return this.engineModules.size() > 0;
    }

    public int getDefaultDisplayTileData() {
        return -1;
    }

    public int getMinecartType() {
        return -1;
    }

    public float[] getColor() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                float[] color = module.getColor();
                if (color[0] == 1.0f && color[1] == 1.0f && color[2] == 1.0f) continue;
                return color;
            }
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public int getYTarget() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                int yTarget = module.getYTarget();
                if (yTarget == -1) continue;
                return yTarget;
            }
        }
        return (int)this.field_70163_u;
    }

    public ModuleBase getInterfaceThief() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                if (!module.doStealInterface()) continue;
                return module;
            }
        }
        return null;
    }

    public boolean func_70097_a(DamageSource dmg, float par2) {
        if (this.isPlaceholder) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                if (module.receiveDamage(dmg, par2)) continue;
                return false;
            }
        }
        return super.func_70097_a(dmg, par2);
    }

    public boolean func_190530_aW() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (module.receiveDamage(null, 0.0f)) continue;
                return true;
            }
        }
        return super.func_190530_aW();
    }

    public void func_96095_a(int x, int y, int z, boolean active) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.activatedByRail(x, y, z, active);
            }
        }
    }

    public void moveMinecartOnRail(BlockPos pos) {
        boolean forceUnDisable;
        super.moveMinecartOnRail(pos);
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.moveMinecartOnRail(pos);
            }
        }
        IBlockState blockState = this.field_70170_p.func_180495_p(pos);
        IBlockState stateBelow = this.field_70170_p.func_180495_p(pos.func_177977_b());
        int metaBelow = stateBelow.func_177230_c().func_176201_c(stateBelow);
        BlockRailBase.EnumRailDirection railDirection = ((BlockRailBase)blockState.func_177230_c()).getRailDirection((IBlockAccess)this.field_70170_p, pos, blockState, (EntityMinecart)this);
        boolean bl = this.cornerFlip = (railDirection == BlockRailBase.EnumRailDirection.SOUTH_EAST || railDirection == BlockRailBase.EnumRailDirection.SOUTH_WEST) && this.field_70159_w < 0.0 || (railDirection == BlockRailBase.EnumRailDirection.NORTH_EAST || railDirection == BlockRailBase.EnumRailDirection.NORTH_WEST) && this.field_70159_w > 0.0;
        if (blockState.func_177230_c() != ModBlocks.ADVANCED_DETECTOR.getBlock() && this.isDisabled()) {
            this.releaseCart();
        }
        boolean canBeDisabled = blockState.func_177230_c() == ModBlocks.ADVANCED_DETECTOR.getBlock() && (stateBelow.func_177230_c() != ModBlocks.DETECTOR_UNIT.getBlock() || !DetectorType.getTypeFromSate(stateBelow).canInteractWithCart() || DetectorType.getTypeFromSate(stateBelow).shouldStopCart());
        boolean bl2 = forceUnDisable = this.wasDisabled && this.disabledPos != null && this.disabledPos.equals((Object)pos);
        if (!forceUnDisable && this.wasDisabled) {
            this.wasDisabled = false;
        }
        boolean bl3 = canBeDisabled = !forceUnDisable && canBeDisabled;
        if (canBeDisabled && !this.isDisabled()) {
            this.setIsDisabled(true);
            if (this.pushX != 0.0 || this.pushZ != 0.0) {
                this.temppushX = this.pushX;
                this.temppushZ = this.pushZ;
                double n = 0.0;
                this.pushZ = 0.0;
                this.pushX = 0.0;
            }
            this.disabledPos = new BlockPos((Vec3i)pos);
        }
        if (this.fixedRailPos != null && !this.fixedRailPos.equals((Object)pos)) {
            this.fixedRailDirection = null;
            this.fixedRailPos = new BlockPos(this.fixedRailPos.func_177958_n(), -1, this.fixedRailPos.func_177952_p());
        }
    }

    public BlockRailBase.EnumRailDirection getRailDirection(BlockPos pos) {
        boolean flag;
        ModuleBase module;
        ModuleBase.RAILDIRECTION dir = ModuleBase.RAILDIRECTION.DEFAULT;
        Iterator<ModuleBase> iterator = this.getModules().iterator();
        while (iterator.hasNext() && (dir = (module = iterator.next()).getSpecialRailDirection(pos)) == ModuleBase.RAILDIRECTION.DEFAULT) {
        }
        if (dir == ModuleBase.RAILDIRECTION.DEFAULT) {
            return null;
        }
        int Yaw = (int)(this.field_70177_z % 180.0f);
        if (Yaw < 0) {
            Yaw += 180;
        }
        boolean bl = flag = Yaw >= 45 && Yaw <= 135;
        if (this.fixedRailDirection == null) {
            switch (dir) {
                case FORWARD: {
                    if (flag) {
                        this.fixedRailDirection = BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                        break;
                    }
                    this.fixedRailDirection = BlockRailBase.EnumRailDirection.EAST_WEST;
                    break;
                }
                case LEFT: {
                    if (flag) {
                        if (this.field_70179_y > 0.0) {
                            this.fixedRailDirection = BlockRailBase.EnumRailDirection.NORTH_EAST;
                            break;
                        }
                        if (!(this.field_70179_y <= 0.0)) break;
                        this.fixedRailDirection = BlockRailBase.EnumRailDirection.SOUTH_WEST;
                        break;
                    }
                    if (this.field_70159_w > 0.0) {
                        this.fixedRailDirection = BlockRailBase.EnumRailDirection.NORTH_WEST;
                        break;
                    }
                    if (!(this.field_70159_w < 0.0)) break;
                    this.fixedRailDirection = BlockRailBase.EnumRailDirection.SOUTH_EAST;
                    break;
                }
                case RIGHT: {
                    if (flag) {
                        if (this.field_70179_y > 0.0) {
                            this.fixedRailDirection = BlockRailBase.EnumRailDirection.NORTH_WEST;
                            break;
                        }
                        if (!(this.field_70179_y <= 0.0)) break;
                        this.fixedRailDirection = BlockRailBase.EnumRailDirection.SOUTH_EAST;
                        break;
                    }
                    if (this.field_70159_w > 0.0) {
                        this.fixedRailDirection = BlockRailBase.EnumRailDirection.SOUTH_WEST;
                        break;
                    }
                    if (!(this.field_70159_w < 0.0)) break;
                    this.fixedRailDirection = BlockRailBase.EnumRailDirection.NORTH_EAST;
                    break;
                }
                case NORTH: {
                    if (flag) {
                        if (!(this.field_70179_y > 0.0)) break;
                        this.fixedRailDirection = BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                        break;
                    }
                    if (this.field_70159_w > 0.0) {
                        this.fixedRailDirection = BlockRailBase.EnumRailDirection.SOUTH_WEST;
                        break;
                    }
                    if (!(this.field_70159_w < 0.0)) break;
                    this.fixedRailDirection = BlockRailBase.EnumRailDirection.SOUTH_EAST;
                    break;
                }
                default: {
                    this.fixedRailDirection = null;
                }
            }
            if (this.fixedRailDirection == null) {
                return null;
            }
            this.fixedRailPos = new BlockPos((Vec3i)pos);
        }
        return this.fixedRailDirection;
    }

    public void resetRailDirection() {
        this.fixedRailDirection = null;
    }

    public void turnback() {
        this.pushX *= -1.0;
        this.pushZ *= -1.0;
        this.temppushX *= -1.0;
        this.temppushZ *= -1.0;
        this.field_70159_w *= -1.0;
        this.field_70181_x *= -1.0;
        this.field_70179_y *= -1.0;
    }

    public void releaseCart() {
        this.wasDisabled = true;
        this.setIsDisabled(false);
        this.pushX = this.temppushX;
        this.pushZ = this.temppushZ;
    }

    public void func_70296_d() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.onInventoryChanged();
            }
        }
    }

    public int func_70302_i_() {
        int slotCount = 0;
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                slotCount += module.getInventorySize();
            }
        }
        return slotCount;
    }

    public boolean func_191420_l() {
        return false;
    }

    protected void func_180460_a(BlockPos pos, IBlockState state) {
        if (!this.func_184188_bt().isEmpty()) {
            Entity riddenByEntity = (Entity)this.func_184188_bt().get(0);
            if (riddenByEntity instanceof EntityLivingBase) {
                float move = ((EntityLivingBase)riddenByEntity).field_191988_bg;
                ((EntityLivingBase)riddenByEntity).field_191988_bg = 0.0f;
                super.func_180460_a(pos, state);
                ((EntityLivingBase)riddenByEntity).field_191988_bg = move;
            } else {
                super.func_180460_a(pos, state);
            }
        } else {
            super.func_180460_a(pos, state);
        }
        double d2 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (d2 > 1.0E-4 && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.001) {
            d2 = MathHelper.func_76133_a((double)d2);
            this.pushX /= d2;
            this.pushZ /= d2;
            if (this.pushX * this.field_70159_w + this.pushZ * this.field_70179_y < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                this.pushX = this.field_70159_w;
                this.pushZ = this.field_70179_y;
            }
        }
    }

    protected void func_94101_h() {
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        boolean bl = this.engineFlag = d0 > 1.0E-4;
        if (this.isDisabled()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        } else if (this.engineFlag) {
            d0 = MathHelper.func_76133_a((double)d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            double d2 = this.getPushFactor();
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.8f;
            this.field_70159_w += this.pushX * d2;
            this.field_70179_y += this.pushZ * d2;
        } else {
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.98f;
        }
        super.func_94101_h();
    }

    protected double getPushFactor() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                double factor = module.getPushFactor();
                if (!(factor >= 0.0)) continue;
                return factor;
            }
        }
        return 0.05;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tagCompound) {
        super.func_189511_e(tagCompound);
        tagCompound.func_74778_a("cartName", this.name);
        tagCompound.func_74780_a("pushX", this.pushX);
        tagCompound.func_74780_a("pushZ", this.pushZ);
        tagCompound.func_74780_a("temppushX", this.temppushX);
        tagCompound.func_74780_a("temppushZ", this.temppushZ);
        tagCompound.func_74777_a("workingTime", (short)this.workingTime);
        tagCompound.func_74773_a("Modules", this.moduleLoadingData);
        tagCompound.func_74774_a("CartVersion", this.cartVersion);
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ModuleBase module = this.modules.get(i);
                module.writeToNBT(tagCompound, i);
            }
        }
        return tagCompound;
    }

    public void func_70020_e(NBTTagCompound tagCompound) {
        super.func_70020_e(tagCompound);
        this.name = tagCompound.func_74779_i("cartName");
        this.pushX = tagCompound.func_74769_h("pushX");
        this.pushZ = tagCompound.func_74769_h("pushZ");
        this.temppushX = tagCompound.func_74769_h("temppushX");
        this.temppushZ = tagCompound.func_74769_h("temppushZ");
        this.workingTime = tagCompound.func_74765_d("workingTime");
        byte oldVersion = this.cartVersion = tagCompound.func_74771_c("CartVersion");
        this.loadModules(tagCompound);
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ModuleBase module = this.modules.get(i);
                module.readFromNBT(tagCompound, i);
            }
        }
        if (oldVersion < 2) {
            int newSlot = -1;
            int slotCount = 0;
            for (ModuleBase module2 : this.modules) {
                if (module2 instanceof ModuleTool) {
                    newSlot = slotCount;
                    break;
                }
                slotCount += module2.getInventorySize();
            }
            if (newSlot != -1) {
                ItemStack lastitem = ItemStack.field_190927_a;
                for (int j = newSlot; j < this.func_70302_i_(); ++j) {
                    ItemStack thisitem = this.func_70301_a(j);
                    this.func_70299_a(j, lastitem);
                    lastitem = thisitem;
                }
            }
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DISANABLED);
    }

    public void setIsDisabled(boolean disabled) {
        this.field_70180_af.func_187227_b(IS_DISANABLED, (Object)disabled);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.onCartUpdate();
        if (this.field_70170_p.field_72995_K) {
            this.updateSounds();
        }
    }

    public void onCartUpdate() {
        if (this.modules != null) {
            this.updateFuel();
            for (ModuleBase module : this.modules) {
                module.update();
            }
            for (ModuleBase module : this.modules) {
                module.postUpdate();
            }
            this.work();
            this.setCurrentCartSpeedCapOnRail(this.getMaxCartSpeedOnRail());
        }
        if (this.isPlaceholder && this.keepAlive++ > 20) {
            this.func_70106_y();
            this.placeholderAsssembler.resetPlaceholder();
        }
    }

    public boolean hasFuel() {
        if (this.isDisabled()) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!module.stopEngines()) continue;
                return false;
            }
        }
        return this.hasFuelForModule();
    }

    public boolean hasFuelForModule() {
        if (this.isPlaceholder) {
            return true;
        }
        int consumption = this.getConsumption(true);
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!module.hasFuel(consumption)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_70092_e((double)this.x(), (double)this.y(), (double)this.z()) <= 64.0;
    }

    public EnumActionResult func_184199_a(EntityPlayer entityplayer, Vec3d vec, EnumHand hand) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, entityplayer, hand))) {
            return EnumActionResult.SUCCESS;
        }
        if (this.isPlaceholder) {
            return EnumActionResult.FAIL;
        }
        if (this.modules != null && !entityplayer.func_70093_af()) {
            boolean interupt = false;
            for (ModuleBase module : this.modules) {
                if (!module.onInteractFirst(entityplayer)) continue;
                interupt = true;
            }
            if (interupt) {
                return EnumActionResult.SUCCESS;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.isDisabled() && !this.func_184196_w((Entity)entityplayer)) {
                this.temppushX = this.field_70165_t - entityplayer.field_70165_t;
                this.temppushZ = this.field_70161_v - entityplayer.field_70161_v;
            }
            if (!this.isDisabled() && this.hasFuel() && this.pushX == 0.0 && this.pushZ == 0.0) {
                this.pushX = this.temppushX;
                this.pushZ = this.temppushZ;
            }
            FMLNetworkHandler.openGui((EntityPlayer)entityplayer, (Object)StevesCarts.instance, (int)0, (World)this.field_70170_p, (int)this.func_145782_y(), (int)0, (int)0);
            this.func_174889_b(entityplayer);
        }
        return EnumActionResult.SUCCESS;
    }

    public void loadChunks() {
        this.loadChunks(this.cartTicket, this.x() >> 4, this.z() >> 4);
    }

    public void loadChunks(int chunkX, int chunkZ) {
        this.loadChunks(this.cartTicket, chunkX, chunkZ);
    }

    public void loadChunks(ForgeChunkManager.Ticket ticket) {
        this.loadChunks(ticket, this.x() >> 4, this.z() >> 4);
    }

    public void loadChunks(ForgeChunkManager.Ticket ticket, int chunkX, int chunkZ) {
        if (this.field_70170_p.field_72995_K || ticket == null) {
            return;
        }
        if (this.cartTicket == null) {
            this.cartTicket = ticket;
        }
        ImmutableSet loadedChunks = ticket.getChunkList();
        ArrayList<ChunkPos> newChunks = new ArrayList<ChunkPos>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                newChunks.add(new ChunkPos(chunkX + i, chunkZ + j));
            }
        }
        for (ChunkPos pos : loadedChunks) {
            if (newChunks.contains(pos)) continue;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.cartTicket, (ChunkPos)pos);
        }
        for (ChunkPos pos : newChunks) {
            if (loadedChunks.contains(pos)) continue;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.cartTicket, (ChunkPos)pos);
        }
    }

    public void initChunkLoading() {
        if (this.field_70170_p.field_72995_K || this.cartTicket != null) {
            return;
        }
        this.cartTicket = ForgeChunkManager.requestTicket((Object)StevesCarts.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (this.cartTicket != null) {
            this.cartTicket.bindEntity((Entity)this);
            this.cartTicket.setChunkListDepth(9);
            this.loadChunks();
        }
    }

    public void dropChunkLoading() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.cartTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.cartTicket);
            this.cartTicket = null;
        }
    }

    public void setWorker(ModuleWorker worker) {
        if (this.workingComponent != null && worker != null) {
            this.workingComponent.stopWorking();
        }
        if ((this.workingComponent = worker) == null) {
            this.setWorkingTime(0);
        }
    }

    public ModuleWorker getWorker() {
        return this.workingComponent;
    }

    public void setWorkingTime(int val) {
        this.workingTime = val;
    }

    private void work() {
        if (this.isPlaceholder) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.hasFuel()) {
            if (this.workingTime <= 0) {
                ModuleWorker oldComponent = this.workingComponent;
                if (this.workingComponent != null) {
                    boolean result = this.workingComponent.work();
                    if (this.workingComponent != null && oldComponent == this.workingComponent && this.workingTime <= 0 && !this.workingComponent.preventAutoShutdown()) {
                        this.workingComponent.stopWorking();
                    }
                    if (result) {
                        this.work();
                        return;
                    }
                }
                if (this.workModules != null) {
                    for (ModuleWorker module : this.workModules) {
                        if (!module.work()) continue;
                        return;
                    }
                }
            } else {
                --this.workingTime;
            }
        }
    }

    public void handleActivator(ActivatorOption option, boolean isOrange) {
        for (ModuleBase module : this.modules) {
            if (!(module instanceof IActivatorModule) || !option.getModule().isAssignableFrom(module.getClass())) continue;
            IActivatorModule iactivator = (IActivatorModule)((Object)module);
            if (option.shouldActivate(isOrange)) {
                iactivator.doActivate(option.getId());
                continue;
            }
            if (option.shouldDeactivate(isOrange)) {
                iactivator.doDeActivate(option.getId());
                continue;
            }
            if (!option.shouldToggle()) continue;
            if (iactivator.isActive(option.getId())) {
                iactivator.doDeActivate(option.getId());
                continue;
            }
            iactivator.doActivate(option.getId());
        }
    }

    public boolean getRenderFlippedYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if (!this.oldRender || Math.abs(yaw - this.lastRenderYaw) < 90.0f || Math.abs(yaw - this.lastRenderYaw) > 270.0f || this.field_70159_w > 0.0 && this.lastMotionX < 0.0 || this.field_70179_y > 0.0 && this.lastMotionZ < 0.0 || this.field_70159_w < 0.0 && this.lastMotionX > 0.0 || this.field_70179_y < 0.0 && this.lastMotionZ > 0.0 || this.wrongRender >= 50) {
            this.lastMotionX = this.field_70159_w;
            this.lastMotionZ = this.field_70179_y;
            this.lastRenderYaw = yaw;
            this.oldRender = true;
            this.wrongRender = 0;
            return false;
        }
        ++this.wrongRender;
        return true;
    }

    public ArrayList<String> getLabel() {
        ArrayList<String> label = new ArrayList<String>();
        if (this.getModules() != null) {
            for (ModuleBase module : this.getModules()) {
                module.addToLabel(label);
            }
        }
        return label;
    }

    public int x() {
        return MathHelper.func_76128_c((double)this.field_70165_t);
    }

    public int y() {
        return MathHelper.func_76128_c((double)this.field_70163_u);
    }

    public int z() {
        return MathHelper.func_76128_c((double)this.field_70161_v);
    }

    public BlockPos getExactPosition() {
        return new BlockPos(this.x(), this.y(), this.z());
    }

    public void addItemToChest(@Nonnull ItemStack iStack) {
        TransferHandler.TransferItem(iStack, (IInventory)this, this.getCon(null), Slot.class, null, -1);
    }

    public void addItemToChest(@Nonnull ItemStack iStack, int start, int end) {
        TransferHandler.TransferItem(iStack, this, start, end, this.getCon(null), Slot.class, null, -1);
    }

    public void addItemToChest(@Nonnull ItemStack iStack, Class validSlot, Class invalidSlot) {
        TransferHandler.TransferItem(iStack, (IInventory)this, this.getCon(null), validSlot, invalidSlot, -1);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        if (!this.func_70301_a(index).func_190926_b()) {
            ItemStack var2 = this.func_70301_a(index);
            this.func_70299_a(index, ItemStack.field_190927_a);
            return var2;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (i < module.getInventorySize()) {
                    return module.getStack(i);
                }
                i -= module.getInventorySize();
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int i, @Nonnull ItemStack item) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (i < module.getInventorySize()) {
                    module.setStack(i, item);
                    break;
                }
                i -= module.getInventorySize();
            }
        }
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int n) {
        if (this.modules == null) {
            return ItemStack.field_190927_a;
        }
        if (this.func_70301_a(i).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.func_70301_a(i).func_190916_E() <= n) {
            ItemStack item = this.func_70301_a(i);
            this.func_70299_a(i, ItemStack.field_190927_a);
            return item;
        }
        ItemStack item = this.func_70301_a(i).func_77979_a(n);
        if (this.func_70301_a(i).func_190916_E() == 0) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        return item;
    }

    public Container getCon(InventoryPlayer player) {
        return new ContainerMinecart((IInventory)player, this);
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!(module instanceof ModuleChest)) continue;
                ((ModuleChest)module).openChest();
            }
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!(module instanceof ModuleChest)) continue;
                ((ModuleChest)module).closeChest();
            }
        }
    }

    public void setPlaceholder(TileEntityCartAssembler assembler) {
        this.isPlaceholder = true;
        this.placeholderAsssembler = assembler;
    }

    public AxisAlignedBB func_174813_aQ() {
        if (this.isPlaceholder) {
            return null;
        }
        return super.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return !this.isPlaceholder && super.func_70067_L();
    }

    public boolean func_70104_M() {
        return !this.isPlaceholder && super.func_70104_M();
    }

    @SideOnly(value=Side.CLIENT)
    private void generateModels() {
        if (this.modules != null) {
            ModuleData data;
            ArrayList<String> invalid = new ArrayList<String>();
            for (ModuleBase module : this.modules) {
                data = module.getData();
                if (!data.haveRemovedModels()) continue;
                for (String remove : data.getRemovedModels()) {
                    invalid.add(remove);
                }
            }
            for (int i = this.modules.size() - 1; i >= 0; --i) {
                ModuleBase module;
                module = this.modules.get(i);
                data = module.getData();
                if (data == null || !data.haveModels(this.isPlaceholder)) continue;
                ArrayList<ModelCartbase> models = new ArrayList<ModelCartbase>();
                for (String str : data.getModels(this.isPlaceholder).keySet()) {
                    if (invalid.contains(str)) continue;
                    models.add(data.getModels(this.isPlaceholder).get(str));
                    invalid.add(str);
                }
                if (models.size() <= 0) continue;
                module.setModels(models);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player) {
        return new GuiMinecart(player.field_71071_by, this);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte(this.moduleLoadingData.length);
        for (byte b : this.moduleLoadingData) {
            data.writeByte((int)b);
        }
        data.writeByte(this.name.getBytes().length);
        for (byte b : this.name.getBytes()) {
            data.writeByte((int)b);
        }
    }

    public void readSpawnData(ByteBuf data) {
        byte length = data.readByte();
        byte[] bytes = new byte[length];
        data.readBytes(bytes);
        this.loadModules(bytes);
        int nameLength = data.readByte();
        byte[] nameBytes = new byte[nameLength];
        for (int i = 0; i < nameLength; ++i) {
            nameBytes[i] = data.readByte();
        }
        this.name = new String(nameBytes);
        if (this.func_184212_Q() instanceof EntityDataManagerLockable) {
            ((EntityDataManagerLockable)this.func_184212_Q()).release();
        }
    }

    public void setScrollY(int val) {
        if (this.canScrollModules) {
            this.scrollY = val;
        }
    }

    public int getScrollY() {
        if (this.getInterfaceThief() != null) {
            return 0;
        }
        return this.scrollY;
    }

    public int getRealScrollY() {
        return (int)((float)(this.modularSpaceHeight - 168) / 198.0f * (float)this.getScrollY());
    }

    public int fill(FluidStack resource, boolean doFill) {
        int amount = 0;
        if (resource != null && resource.amount > 0) {
            FluidStack fluid = resource.copy();
            for (int i = 0; i < this.tankModules.size(); ++i) {
                int tempAmount = this.tankModules.get(i).fill(fluid, doFill);
                amount += tempAmount;
                FluidStack fluidStack = fluid;
                fluidStack.amount -= tempAmount;
                if (fluid.amount <= 0) break;
            }
        }
        return amount;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.drain(resource, resource == null ? 0 : resource.amount, doDrain);
    }

    private FluidStack drain(FluidStack resource, int maxDrain, boolean doDrain) {
        FluidStack ret = resource;
        if (ret != null) {
            ret = ret.copy();
            ret.amount = 0;
        }
        for (int i = 0; i < this.tankModules.size(); ++i) {
            FluidStack temp = null;
            temp = this.tankModules.get(i).drain(maxDrain, doDrain);
            if (temp == null || ret != null && !ret.isFluidEqual(temp)) continue;
            if (ret == null) {
                ret = temp;
            } else {
                FluidStack fluidStack = ret;
                fluidStack.amount += temp.amount;
            }
            if ((maxDrain -= temp.amount) <= 0) break;
        }
        if (ret != null && ret.amount == 0) {
            return null;
        }
        return ret;
    }

    public int drain(Fluid type, int maxDrain, boolean doDrain) {
        int amount = 0;
        if (type != null && maxDrain > 0) {
            for (ModuleTank tank : this.tankModules) {
                FluidStack drained = tank.drain(maxDrain, false);
                if (drained == null || !type.equals(drained.getFluid())) continue;
                amount += drained.amount;
                maxDrain -= drained.amount;
                if (doDrain) {
                    tank.drain(drained.amount, true);
                }
                if (maxDrain > 0) continue;
                break;
            }
        }
        return amount;
    }

    public IFluidTankProperties[] getTankProperties() {
        IFluidTankProperties[] ret = new IFluidTankProperties[this.tankModules.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new FluidTankProperties(this.tankModules.get(i).getFluid(), this.tankModules.get(i).getCapacity());
        }
        return ret;
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack item) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (slot < module.getInventorySize()) {
                    return module.getSlots().get(slot).func_75214_a(item);
                }
                slot -= module.getInventorySize();
            }
        }
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public String getInventoryName() {
        return "container.modularcart";
    }

    public String func_70005_c_() {
        return this.getCartName();
    }

    public String getCartName() {
        if (this.name == null || this.name.length() == 0) {
            return "Modular Cart";
        }
        return this.name;
    }

    public boolean hasCreativeSupplies() {
        return this.creativeSupplies != null;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSound(MovingSound sound, boolean riding) {
        if (riding) {
            this.soundRiding = sound;
        } else {
            this.sound = sound;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void silent() {
        this.keepSilent = 6;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSounds() {
        if (this.keepSilent > 1) {
            --this.keepSilent;
            this.stopSound(this.sound);
            this.stopSound(this.soundRiding);
            this.sound = null;
            this.soundRiding = null;
        } else if (this.keepSilent == 1) {
            this.keepSilent = 0;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundMinecart((EntityMinecart)this));
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundMinecartRiding((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (EntityMinecart)this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopSound(MovingSound sound) {
        if (sound != null) {
            ReflectionHelper.setPrivateValue(MovingSound.class, (Object)sound, (Object)true, (int)0);
        }
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public EntityMinecart.Type func_184264_v() {
        return null;
    }

    public Entity getCartRider() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Nullable
    public Entity func_184179_bs() {
        return null;
    }

    public EntityDataManager func_184212_Q() {
        return this.field_70180_af;
    }

    public int getNextDataWatcher() {
        ++this.base;
        return this.func_184212_Q().func_187231_c().size() + this.base + 1;
    }

    static {
        IS_BURNING = EntityDataManager.func_187226_a(EntityMinecartModular.class, (DataSerializer)DataSerializers.field_187198_h);
        IS_DISANABLED = EntityDataManager.func_187226_a(EntityMinecartModular.class, (DataSerializer)DataSerializers.field_187198_h);
        railDirectionCoordinates = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    }
}

