/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.ItemStackHelper;
import ipsis.woot.util.WootMobName;
import ipsis.woot.util.WootMobNameBuilder;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class JsonHelper {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static WootMobName getWootMobName(JsonObject json) {
        String mobName = JsonUtils.func_151219_a((JsonObject)json, (String)"mobName", (String)"");
        if (mobName.equals("")) {
            throw new JsonSyntaxException("Mob name cannot be empty");
        }
        WootMobName wootMobName = WootMobNameBuilder.createFromConfigString(mobName);
        if (!wootMobName.isValid()) {
            LogHelper.error("Unknown mob " + mobName);
        }
        return wootMobName;
    }

    public static JsonObject toJsonObject(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        ResourceLocation resourceLocation = ItemStackHelper.getItemName(item);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("item", resourceLocation.toString());
        if (item.func_77614_k()) {
            jsonObject.addProperty("data", (Number)itemStack.func_77960_j());
        }
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_186856_d() > 0) {
            NBTTagCompound nbt = itemStack.func_77978_p().func_74737_b();
            if (nbt.func_74764_b("ForgeCaps")) {
                nbt.func_82580_o("ForgeCaps");
            }
            jsonObject.addProperty("nbt", nbt.toString());
        }
        return jsonObject;
    }

    @Nullable
    public static FluidStack getFluidStack(JsonObject json) {
        String fluidName = JsonUtils.func_151200_h((JsonObject)json, (String)"fluid");
        if (!FluidRegistry.isFluidRegistered((String)fluidName)) {
            return null;
        }
        if (!json.has("mb")) {
            LogHelper.error("getFluidStack: missing mb for fluid " + fluidName);
            return null;
        }
        int mb = JsonUtils.func_151208_a((JsonObject)json, (String)"mb", (int)1000);
        return FluidRegistry.getFluidStack((String)fluidName, (int)JsonUtils.func_151208_a((JsonObject)json, (String)"mb", (int)1000));
    }

    public static ItemStack getItemStack(JsonObject json) {
        String itemName = JsonUtils.func_151200_h((JsonObject)json, (String)"item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            LogHelper.error("getItemStack: unknown item " + itemName);
            return ItemStack.field_190927_a;
        }
        if (item.func_77614_k() && !json.has("data")) {
            LogHelper.error("getItemStack: missing data for item " + itemName);
            return ItemStack.field_190927_a;
        }
        if (json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                NBTTagCompound nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)element.getAsString());
                NBTTagCompound tmp = new NBTTagCompound();
                if (nbt.func_74764_b("ForgeCaps")) {
                    tmp.func_74782_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                    nbt.func_82580_o("ForgeCaps");
                }
                tmp.func_74782_a("tag", (NBTBase)nbt);
                tmp.func_74778_a("id", itemName);
                tmp.func_74768_a("Count", JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
                tmp.func_74768_a("Damage", JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0));
                return new ItemStack(tmp);
            }
            catch (NBTException e) {
                LogHelper.error("getItemStack: invalid NBT Entry: " + e.toString());
                return ItemStack.field_190927_a;
            }
        }
        return new ItemStack(item, JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1), JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0));
    }
}

