/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.farming;

import ipsis.woot.farming.ISpawnRecipe;
import ipsis.woot.farming.ISpawnRecipeConsumer;
import ipsis.woot.oss.ItemHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class SpawnRecipeConsumer
implements ISpawnRecipeConsumer {
    private int getItemCount(List<IItemHandler> itemHandlerList, ItemStack itemStack) {
        int count = 0;
        for (IItemHandler iItemHandler : itemHandlerList) {
            if (iItemHandler.getSlots() == 0) continue;
            for (int slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                ItemStack stack = iItemHandler.getStackInSlot(slot);
                if (stack.func_190926_b() || !ItemHelper.itemsIdentical(itemStack, stack)) continue;
                count += stack.func_190916_E();
            }
        }
        return count;
    }

    private int getFluidCount(List<IFluidHandler> fluidHandlerList, FluidStack fluidStack) {
        int amount = 0;
        for (IFluidHandler iFluidHandler : fluidHandlerList) {
            for (IFluidTankProperties iFluidTankProperties : iFluidHandler.getTankProperties()) {
                FluidStack contentStack = iFluidTankProperties.getContents();
                if (contentStack == null || !contentStack.isFluidEqual(fluidStack)) continue;
                amount += contentStack.amount;
            }
        }
        return amount;
    }

    private int consumeItems(List<IItemHandler> itemHandlerList, ItemStack itemStack, int count) {
        int left = count;
        for (IItemHandler iItemHandler : itemHandlerList) {
            if (iItemHandler.getSlots() == 0) continue;
            for (int slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                ItemStack stack = iItemHandler.getStackInSlot(slot);
                if (stack.func_190926_b() || !ItemHelper.itemsIdentical(itemStack, stack)) continue;
                ItemStack t = iItemHandler.extractItem(slot, left, false);
                left -= t.func_190916_E();
            }
        }
        return left;
    }

    private int consumeFluids(List<IFluidHandler> fluidHandlerList, FluidStack fluidStack, int amount) {
        FluidStack drainStack = fluidStack.copy();
        drainStack.amount = amount;
        for (IFluidHandler iFluidHandler : fluidHandlerList) {
            FluidStack successStack = iFluidHandler.drain(drainStack, true);
            if (successStack == null) continue;
            drainStack.amount -= successStack.amount;
            if (drainStack.amount >= 0) continue;
            drainStack.amount = 0;
        }
        return drainStack.amount;
    }

    private boolean processItems(List<IItemHandler> itemHandlerList, @Nonnull ISpawnRecipe spawnRecipe, int mobCount, boolean simulate) {
        if (spawnRecipe.getItems().isEmpty()) {
            return true;
        }
        boolean allItemsPresent = true;
        for (ItemStack itemStack : spawnRecipe.getItems()) {
            int need = itemStack.func_190916_E() * mobCount;
            int found = this.getItemCount(itemHandlerList, itemStack);
            if (found >= need) continue;
            allItemsPresent = false;
            break;
        }
        if (simulate) {
            return allItemsPresent;
        }
        if (allItemsPresent) {
            for (ItemStack itemStack : spawnRecipe.getItems()) {
                this.consumeItems(itemHandlerList, itemStack, itemStack.func_190916_E() * mobCount);
            }
            return true;
        }
        return false;
    }

    private boolean processFluids(List<IFluidHandler> fluidHandlerList, @Nonnull ISpawnRecipe spawnRecipe, int mobCount, boolean simulate) {
        if (spawnRecipe.getFluids().isEmpty()) {
            return true;
        }
        boolean allFluidPresent = true;
        for (FluidStack fluidStack : spawnRecipe.getFluids()) {
            int need = fluidStack.amount * mobCount;
            int found = this.getFluidCount(fluidHandlerList, fluidStack);
            if (found >= need) continue;
            allFluidPresent = false;
            break;
        }
        if (simulate) {
            return allFluidPresent;
        }
        if (allFluidPresent) {
            for (FluidStack fluidStack : spawnRecipe.getFluids()) {
                this.consumeFluids(fluidHandlerList, fluidStack, fluidStack.amount * mobCount);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean consume(World world, BlockPos pos, List<IFluidHandler> fluidHandlerList, List<IItemHandler> itemHandlerList, @Nullable ISpawnRecipe spawnRecipe, int mobCount, boolean simulate) {
        if (spawnRecipe == null) {
            return true;
        }
        return this.processItems(itemHandlerList, spawnRecipe, mobCount, simulate) && this.processFluids(fluidHandlerList, spawnRecipe, mobCount, simulate);
    }
}

