/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import ipsis.woot.crafting.AnvilRecipe;
import ipsis.woot.crafting.AnvilRecipeMatcher;
import ipsis.woot.crafting.IAnvilManager;
import ipsis.woot.crafting.IAnvilRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class AnvilManager
implements IAnvilManager {
    private List<ItemStack> validBaseItems = new ArrayList<ItemStack>();
    private List<IAnvilRecipe> recipes = new ArrayList<IAnvilRecipe>();

    private void addToBaseItems(ItemStack base) {
        boolean found = false;
        for (ItemStack itemStack : this.validBaseItems) {
            if (!itemStack.func_77969_a(base)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.validBaseItems.add(base);
        }
    }

    @Override
    public void addRecipe(ItemStack output, ItemStack base, boolean preserveBase, Object ... ingredients) {
        if (ingredients.length == 0) {
            return;
        }
        this.addToBaseItems(base);
        AnvilRecipe recipe = new AnvilRecipe(output, base, preserveBase);
        for (Object o : ingredients) {
            if (!(o instanceof ItemStack)) continue;
            recipe.addIngredient((ItemStack)o);
        }
        this.recipes.add(recipe);
    }

    @Override
    @Nullable
    public IAnvilRecipe getRecipe(ItemStack baseItem, @Nonnull List<ItemStack> ingredients) {
        if (this.isValidBaseItem(baseItem)) {
            for (IAnvilRecipe recipe : this.recipes) {
                if (!AnvilRecipeMatcher.isMatch(recipe, baseItem, ingredients)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public boolean isValidBaseItem(ItemStack itemStack) {
        boolean found = false;
        for (ItemStack c : this.validBaseItems) {
            if (!c.func_77969_a(itemStack)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public List<IAnvilRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public IAnvilRecipe getRecipe(ItemStack output) {
        for (IAnvilRecipe recipe : this.recipes) {
            if (!recipe.isOutput(output)) continue;
            return recipe;
        }
        return null;
    }
}

