/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.item;

import cofh.core.item.IEnchantableItem;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.helper.EnergyHelper;
import jackyy.exchangers.helper.NBTHelper;
import jackyy.exchangers.helper.StringHelper;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.registry.ModConfig;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux"), @Optional.Interface(iface="cofh.core.item.IEnchantableItem", modid="cofhcore")})
public class ItemExchangerBasePowered
extends ItemExchangerBase
implements IEnergyContainerItem,
IEnchantableItem {
    @GameRegistry.ObjectHolder(value="cofhcore:holding")
    public static final Enchantment holding = null;

    public ItemExchangerBasePowered() {
        this.func_77656_e(1);
    }

    public int receiveEnergy(ItemStack container, int energy, boolean simulate) {
        return NBTHelper.receiveEnergy(container, energy, this.getMaxEnergyStored(container), simulate);
    }

    public int extractEnergy(ItemStack container, int energy, boolean simulate) {
        return NBTHelper.extractEnergy(container, energy, simulate);
    }

    public int getEnergyStored(ItemStack container) {
        return NBTHelper.getEnergyStored(container);
    }

    public int getMaxEnergyStored(ItemStack container) {
        if (ModConfig.misc.holdingEnchantment && Loader.isModLoaded((String)"cofhcore")) {
            int enchant = EnchantmentHelper.func_77506_a((Enchantment)holding, (ItemStack)container);
            return this.getMaxEnergy() + this.getMaxEnergy() * enchant / 2;
        }
        return this.getMaxEnergy();
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag(stack, 0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (!Loader.isModLoaded((String)"redstoneflux")) {
            tooltip.add(StringHelper.localize("tooltip.redstone_flux_warning", new Object[0]));
        }
        if (StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.formatNumber(this.getEnergyStored(stack)) + " / " + StringHelper.formatNumber(this.getMaxEnergyStored(stack)) + " RF");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab) && this.checkLoaded()) {
            ItemStack empty = new ItemStack((Item)this);
            ExchangerHandler.setDefaultTagCompound(empty);
            list.add((Object)empty);
            ItemStack full = new ItemStack((Item)this);
            ExchangerHandler.setDefaultTagCompound(full);
            EnergyHelper.setDefaultEnergyTag(full, this.getMaxEnergyStored(full));
            list.add((Object)full);
        }
    }

    @Override
    public boolean isPowered() {
        return true;
    }

    @Optional.Method(modid="redstoneflux")
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return ModConfig.misc.holdingEnchantment && Loader.isModLoaded((String)"cofhcore") && enchantment == holding;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_185306_r || enchantment == Enchantments.field_185307_s;
    }
}

