/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.items;

import QuantumStorage.items.prefab.ItemBase;
import QuantumStorage.utils.CustomEnergyStorage;
import QuantumStorage.utils.RfUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemQuantumBattery
extends ItemBase {
    public ItemQuantumBattery() {
        this.func_77655_b("quantumstorage.quantum_battery");
        this.setRegistryName("quantum_battery");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af() && !stack.func_190926_b() && !this.isActive(stack)) {
            stack.func_77964_b(1);
        } else {
            stack.func_77964_b(0);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean isActive(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && entity instanceof EntityPlayer && !isSelected && this.isActive(stack)) {
            EntityPlayer player = (EntityPlayer)entity;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                IEnergyStorage cap;
                ItemStack slot = player.field_71071_by.func_70301_a(i);
                if (!RfUtils.isPoweredItem(slot)) continue;
                int extractable = RfUtils.dischargeItem(stack, Integer.MAX_VALUE, true);
                int received = 0;
                if (slot.hasCapability(CapabilityEnergy.ENERGY, null) && (cap = (IEnergyStorage)slot.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
                    received = cap.receiveEnergy(extractable, false);
                }
                if (received <= 0) continue;
                RfUtils.dischargeItem(stack, received, false);
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isActive(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(RfUtils.addPowerTooltip(stack));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return RfUtils.getDurabilityForDisplay(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyCapabilityProvider(stack, this);
    }

    private static class EnergyCapabilityProvider
    implements ICapabilityProvider {
        public final CustomEnergyStorage storage;

        public EnergyCapabilityProvider(final ItemStack stack, ItemQuantumBattery item) {
            this.storage = new CustomEnergyStorage(Integer.MAX_VALUE, 500000, 500000){

                public int getEnergyStored() {
                    if (stack.func_77942_o()) {
                        return stack.func_77978_p().func_74762_e("Energy");
                    }
                    return 0;
                }

                @Override
                public void setEnergyStored(int energy) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74768_a("Energy", energy);
                }
            };
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return this.getCapability(capability, facing) != null;
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.storage);
            }
            return null;
        }
    }
}

