/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.compat.jei;

import QuantumStorage.api.RecipeQuantumCrafter;
import QuantumStorage.client.GuiBuilderQuantumStorage;
import com.google.common.collect.ImmutableList;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class CrafterRecipeWrapper
extends BlankRecipeWrapper {
    private final List input;
    private final ItemStack output;
    private final int time;
    private IDrawableAnimated progress;

    public CrafterRecipeWrapper(IJeiHelpers guiHelper, RecipeQuantumCrafter recipe) {
        ImmutableList.Builder builder = ImmutableList.builder();
        IDrawableStatic progressStatic = guiHelper.getGuiHelper().createDrawable(GuiBuilderQuantumStorage.GUI_SHEET, 100, 151, 16, 10);
        int ticksPerCycle = 250;
        this.progress = guiHelper.getGuiHelper().createAnimatedDrawable(progressStatic, ticksPerCycle, IDrawableAnimated.StartDirection.LEFT, false);
        if (recipe.getInput() instanceof ItemStack) {
            builder.add(recipe.getInput());
        }
        if (recipe.getInput() instanceof String) {
            builder.add((Object)OreDictionary.getOres((String)((String)recipe.getInput())));
        }
        this.input = builder.build();
        this.output = recipe.getOutput();
        this.time = recipe.getTime();
    }

    public void getIngredients(IIngredients iIngredients) {
        iIngredients.setInputs(ItemStack.class, this.input);
        iIngredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public void drawInfo(Minecraft minecraft, int i, int i1, int i2, int i3) {
        super.drawInfo(minecraft, i, i1, i2, i3);
        this.progress.draw(minecraft, 40, 24);
        minecraft.field_71466_p.func_78276_b(this.time / 20 + " Seconds", 10, 45, TextFormatting.BLACK.func_175746_b());
    }
}

