/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.blocks;

import QuantumStorage.client.CreativeTabQuantumStorage;
import QuantumStorage.tiles.AdvancedTileEntity;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancedBlock
extends BlockContainer {
    public AdvancedTileEntity advancedTileEntity;
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    private static final EnumFacing[] validRotationAxes = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};

    public AdvancedBlock(AdvancedTileEntity advancedTileEntity) {
        super(Material.field_151573_f);
        this.advancedTileEntity = advancedTileEntity;
        this.func_149647_a(CreativeTabQuantumStorage.INSTANCE);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
        ACTIVE = PropertyBool.func_177716_a((String)"active");
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (this.advancedTileEntity != null) {
            return this.advancedTileEntity.getRenderType(state);
        }
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.advancedTileEntity != null) {
            return this.advancedTileEntity.getBoundingBox(state, source, pos);
        }
        return super.func_185496_a(state, source, pos);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.advancedTileEntity.createNewTileEntity(worldIn, meta);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.advancedTileEntity != null) {
            return this.advancedTileEntity.onBlockActivated(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (this.advancedTileEntity != null) {
            this.advancedTileEntity.onBlockClicked(worldIn, pos, playerIn);
        }
        super.func_180649_a(worldIn, pos, playerIn);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof AdvancedTileEntity) {
            float xOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float yOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float zOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            ItemStack stacknbt = ((AdvancedTileEntity)te).getDropWithNBT();
            int amountToDrop = Math.min(world.field_73012_v.nextInt(21) + 10, stacknbt.func_190916_E());
            EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + xOffset), (double)((float)pos.func_177956_o() + yOffset), (double)((float)pos.func_177952_p() + zOffset), stacknbt.func_77979_a(amountToDrop));
            world.func_72838_d((Entity)entityitem);
        } else {
            super.func_180657_a(world, player, pos, state, te, stack);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        AdvancedTileEntity adva = (AdvancedTileEntity)worldIn.func_175625_s(pos);
        if (stack.func_77942_o()) {
            adva.readFromNBTWithoutCoords(stack.func_77978_p().func_74775_l("tileEntity"));
        }
        this.setFacing(placer.func_174811_aO().func_176734_d(), worldIn, pos);
        adva.setFacing(placer.func_174811_aO().func_176734_d());
        worldIn.func_184138_a(pos, state, state, 3);
    }

    public void setFacing(EnumFacing facing, World world, BlockPos pos) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)facing));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        worldIn.func_184138_a(pos, state, state, 3);
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState sate = worldIn.func_180495_p(pos.func_177978_c());
            Block block = sate.func_177230_c();
            IBlockState state1 = worldIn.func_180495_p(pos.func_177968_d());
            Block block1 = state1.func_177230_c();
            IBlockState state2 = worldIn.func_180495_p(pos.func_177976_e());
            Block block2 = state2.func_177230_c();
            IBlockState state3 = worldIn.func_180495_p(pos.func_177974_f());
            Block block3 = state3.func_177230_c();
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_149730_j(state) && !block1.func_149730_j(state1)) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_149730_j(state1) && !block.func_149730_j(state)) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_149730_j(state2) && !block3.func_149730_j(state2)) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_149730_j(state3) && !block2.func_149730_j(state2)) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public EnumFacing getSideFromint(int i) {
        if (i == 0) {
            return EnumFacing.NORTH;
        }
        if (i == 1) {
            return EnumFacing.SOUTH;
        }
        if (i == 2) {
            return EnumFacing.EAST;
        }
        if (i == 3) {
            return EnumFacing.WEST;
        }
        return EnumFacing.NORTH;
    }

    public int getSideFromEnum(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.SOUTH) {
            return 1;
        }
        if (facing == EnumFacing.EAST) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        return 0;
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = this.getSideFromEnum((EnumFacing)state.func_177229_b((IProperty)FACING));
        int activeInt = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 0 : 4;
        return facingInt + activeInt;
    }

    public IBlockState func_176203_a(int meta) {
        boolean active = false;
        int facingInt = meta;
        if (facingInt > 4) {
            active = true;
            facingInt -= 4;
        }
        EnumFacing facing = this.getSideFromint(facingInt);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        if (this.advancedTileEntity != null) {
            return this.advancedTileEntity.getBlockLayer();
        }
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP || side == EnumFacing.DOWN;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumFacing[] getValidRotations(World worldObj, BlockPos pos) {
        return validRotationAxes;
    }

    public boolean rotateBlock(World worldObj, BlockPos pos, EnumFacing axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        if (axis == EnumFacing.UP || axis == EnumFacing.DOWN) {
            TileEntity tileEntity = worldObj.func_175625_s(pos);
            if (tileEntity instanceof AdvancedTileEntity) {
                AdvancedTileEntity icte = (AdvancedTileEntity)tileEntity;
                icte.rotateAround();
            }
            return true;
        }
        return false;
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (this.advancedTileEntity != null) {
            this.advancedTileEntity.addInformation(stack, world, tooltip, advanced);
        }
        super.func_190948_a(stack, world, tooltip, advanced);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return 100.0f;
    }
}

