/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.items.CapabilityItemHandler;
import openblocks.client.gui.GuiDonationStation;
import openblocks.common.DonationUrlManager;
import openblocks.common.container.ContainerDonationStation;
import openmods.api.IHasGui;
import openmods.fixers.GenericInventoryTeFixerWalker;
import openmods.fixers.RegisterFixer;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.ModIdentifier;

@RegisterFixer(value=GenericInventoryTeFixerWalker.class)
public class TileEntityDonationStation
extends OpenTileEntity
implements IHasGui,
IInventoryProvider {
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "donationstation", true, 1));

    public Object getServerGui(EntityPlayer player) {
        return new ContainerDonationStation((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiDonationStation(new ContainerDonationStation((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    private ModContainer identifyDonationItem() {
        ItemStack stack = this.inventory.getStackInSlot((Enum)Slots.input);
        if (stack.func_190926_b()) {
            return null;
        }
        return ModIdentifier.INSTANCE.getModItemStack(stack);
    }

    public boolean hasItem() {
        return this.inventory.getStackInSlot((Enum)Slots.input) != null;
    }

    public String getDonationUrl() {
        ModContainer container = this.identifyDonationItem();
        return container != null ? DonationUrlManager.instance().getUrl(container.getModId()) : null;
    }

    public String getModName() {
        ModContainer container = this.identifyDonationItem();
        return container != null ? container.getName() : null;
    }

    public List<String> getModAuthors() {
        ModContainer container = this.identifyDonationItem();
        return container != null ? container.getMetadata().authorList : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    public static enum Slots {
        input;

    }
}

