/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.IMCIntegration;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerMaterials;

@Pulse(id="TinkerIntegration", forced=true)
public class TinkerIntegration
extends TinkerPulse {
    public static final String PulseId = "TinkerIntegration";
    static final Logger log = Util.getLogger("TinkerIntegration");
    private static List<NBTTagList> alloys = Lists.newLinkedList();

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        TinkerIntegration.integrate(TinkerMaterials.wood, "plankWood");
        TinkerIntegration.integrate(TinkerMaterials.stone);
        TinkerIntegration.integrate(TinkerMaterials.flint);
        TinkerIntegration.integrate(TinkerMaterials.cactus);
        TinkerIntegration.integrate(TinkerMaterials.bone);
        TinkerIntegration.integrate(TinkerMaterials.obsidian, TinkerFluids.obsidian);
        TinkerIntegration.integrate(TinkerMaterials.prismarine);
        TinkerIntegration.integrate(TinkerMaterials.endstone);
        TinkerIntegration.integrate(TinkerMaterials.paper);
        TinkerIntegration.integrate(TinkerMaterials.sponge);
        TinkerIntegration.integrate(TinkerMaterials.firewood);
        TinkerIntegration.integrate(TinkerMaterials.iron, TinkerFluids.iron, "Iron").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.pigiron, TinkerFluids.pigIron, "Pigiron").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.knightslime, TinkerFluids.knightslime, "Knightslime").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.slime, "slimecrystalGreen");
        TinkerIntegration.integrate(TinkerMaterials.blueslime, "slimecrystalBlue");
        TinkerIntegration.integrate(TinkerMaterials.magmaslime, "slimecrystalMagma");
        TinkerRegistry.integrate(new MaterialIntegration(null, TinkerFluids.alubrass, "Alubrass", "ingotCopper", "ingotAluminum")).toolforge();
        TinkerIntegration.integrate(TinkerMaterials.netherrack);
        TinkerIntegration.integrate(TinkerMaterials.cobalt, TinkerFluids.cobalt, "Cobalt").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.ardite, TinkerFluids.ardite, "Ardite").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.manyullyn, TinkerFluids.manyullyn, "Manyullyn").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.copper, TinkerFluids.copper, "Copper").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.bronze, TinkerFluids.bronze, "Bronze").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.lead, TinkerFluids.lead, "Lead").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.silver, TinkerFluids.silver, "Silver").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.electrum, TinkerFluids.electrum, "Electrum").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.steel, TinkerFluids.steel, "Steel").toolforge();
        TinkerIntegration.integrate(TinkerFluids.gold, "Gold").toolforge();
        TinkerIntegration.integrate(TinkerFluids.brass, "Brass").toolforge();
        TinkerIntegration.integrate(TinkerFluids.tin, "Tin").toolforge();
        TinkerIntegration.integrate(TinkerFluids.nickel, "Nickel").toolforge();
        TinkerIntegration.integrate(TinkerFluids.zinc, "Zinc").toolforge();
        TinkerIntegration.integrate(TinkerFluids.aluminum, "Aluminum").toolforge();
        TinkerIntegration.integrate(TinkerMaterials.string);
        TinkerIntegration.integrate(TinkerMaterials.slimevine_blue);
        TinkerIntegration.integrate(TinkerMaterials.slimevine_purple);
        TinkerIntegration.integrate(TinkerMaterials.vine);
        TinkerIntegration.integrate(TinkerMaterials.blaze);
        TinkerIntegration.integrate(TinkerMaterials.reed);
        TinkerIntegration.integrate(TinkerMaterials.ice);
        TinkerIntegration.integrate(TinkerMaterials.endrod);
        TinkerIntegration.integrate(TinkerMaterials.feather);
        TinkerIntegration.integrate(TinkerMaterials.slimeleaf_blue);
        TinkerIntegration.integrate(TinkerMaterials.slimeleaf_orange);
        TinkerIntegration.integrate(TinkerMaterials.slimeleaf_purple);
        TinkerIntegration.integrate(TinkerMaterials.leaf);
        for (MaterialIntegration integration : TinkerRegistry.getMaterialIntegrations()) {
            integration.preInit();
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (MaterialIntegration integration : TinkerRegistry.getMaterialIntegrations()) {
            integration.registerFluidBlock((IForgeRegistry<Block>)registry);
        }
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        if (TinkerIntegration.isToolsLoaded()) {
            for (MaterialIntegration integration : TinkerRegistry.getMaterialIntegrations()) {
                integration.registerToolForgeRecipe((IForgeRegistry<IRecipe>)registry);
            }
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (MaterialIntegration integration : TinkerRegistry.getMaterialIntegrations()) {
            integration.registerFluidModel();
        }
    }

    public static void addAlloyNBTTag(NBTTagList alloyTagList) {
        alloys.add(alloyTagList);
    }

    public static boolean isIntegrated(Fluid fluid) {
        String name = FluidRegistry.getFluidName((Fluid)fluid);
        if (name != null) {
            for (MaterialIntegration integration : TinkerRegistry.getMaterialIntegrations()) {
                if (!integration.isIntegrated() || integration.fluid == null || !name.equals(integration.fluid.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        this.handleIMCs();
        this.handleAlloyIMCs();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        for (MaterialIntegration integration : TinkerRegistry.getMaterialIntegrations()) {
            integration.integrate();
        }
        TinkerSmeltery.registerAlloys();
        TinkerSmeltery.registerRecipeOredictMelting();
        TinkerRegistry.removeHiddenMaterials();
    }

    private void handleIMCs() {
        for (FMLInterModComms.IMCMessage message : FMLInterModComms.fetchRuntimeMessages((Object)TConstruct.instance)) {
            try {
                if (message.key.equals("integrateSmeltery")) {
                    IMCIntegration.integrateSmeltery(message);
                    continue;
                }
                if (message.key.equals("alloy")) {
                    IMCIntegration.alloy(message);
                    continue;
                }
                if (message.key.equals("blacklistMelting")) {
                    IMCIntegration.blacklistMelting(message);
                    continue;
                }
                if (!message.key.equals("addDryingRecipe")) continue;
                IMCIntegration.addDryingRecipe(message);
            }
            catch (ClassCastException e) {
                log.error("Got invalid " + message.key + " IMC from " + message.getSender());
            }
        }
    }

    private void handleAlloyIMCs() {
        for (NBTTagList taglist : alloys) {
            LinkedList fluids = Lists.newLinkedList();
            for (int i = 0; i < taglist.func_74745_c(); ++i) {
                NBTTagCompound tag = taglist.func_150305_b(i);
                FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                if (fs == null) {
                    fluids.clear();
                    break;
                }
                fluids.add(fs);
            }
            if (fluids.size() <= 2) continue;
            FluidStack output = (FluidStack)fluids.get(0);
            FluidStack[] input = new FluidStack[fluids.size() - 1];
            input = fluids.subList(1, fluids.size()).toArray(input);
            TinkerRegistry.registerAlloy(output, input);
            log.debug("Added integration alloy: " + output.getLocalizedName());
        }
    }

    private static MaterialIntegration integrate(Material material) {
        return TinkerIntegration.add(new MaterialIntegration(material));
    }

    private static MaterialIntegration integrate(Material material, Fluid fluid) {
        return TinkerIntegration.add(new MaterialIntegration(material, fluid));
    }

    private static MaterialIntegration integrate(Material material, String oreRequirement) {
        MaterialIntegration materialIntegration = new MaterialIntegration(oreRequirement, material, null, null);
        materialIntegration.setRepresentativeItem(oreRequirement);
        return TinkerIntegration.add(materialIntegration);
    }

    private static MaterialIntegration integrate(Material material, Fluid fluid, String oreSuffix) {
        return TinkerIntegration.add(new MaterialIntegration(material, fluid, oreSuffix));
    }

    private static MaterialIntegration integrate(Fluid fluid, String oreSuffix) {
        return TinkerIntegration.add(new MaterialIntegration(null, fluid, oreSuffix));
    }

    private static MaterialIntegration add(MaterialIntegration integration) {
        return TinkerRegistry.integrate(integration);
    }
}

