/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.teamislands;

import com.feed_the_beast.ftblib.events.team.ForgeTeamDataEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDeletedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerLeftEvent;
import com.feed_the_beast.ftblib.lib.data.TeamData;
import com.feed_the_beast.teamislands.FTBUtilitiesIntegration;
import com.feed_the_beast.teamislands.Island;
import com.feed_the_beast.teamislands.TeamIslandsConfig;
import com.feed_the_beast.teamislands.TeamIslandsTeamData;
import com.feed_the_beast.teamislands.TeamIslandsUniverseData;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="teamislands")
public class TeamIslandsEventHandler {
    @SubscribeEvent
    public static void registerTeamData(ForgeTeamDataEvent event) {
        event.register((TeamData)new TeamIslandsTeamData(event.getTeam()));
    }

    @SubscribeEvent
    public static void onPlayerJoinedTeam(ForgeTeamPlayerJoinedEvent event) {
        if (!TeamIslandsConfig.general.isEnabled(event.getUniverse().server)) {
            return;
        }
        Island island = TeamIslandsUniverseData.INSTANCE.getIsland(event.getTeam());
        if (!island.spawned) {
            island.spawned = true;
            WorldServer w = event.getUniverse().world;
            BlockPos pos = island.getBlockPos();
            TeamIslandsUniverseData.INSTANCE.islandTemplate.func_189962_a((World)w, pos, new PlacementSettings(), 2);
            w.func_175712_a(new StructureBoundingBox((Vec3i)pos, (Vec3i)pos.func_177971_a((Vec3i)TeamIslandsUniverseData.INSTANCE.islandTemplate.func_186259_a())), true);
        }
        if (TeamIslandsConfig.lobby.autoteleport_to_island && event.getPlayer().isOnline()) {
            event.getPlayer().getPlayer().setSpawnChunk(island.getEntitySpawnPos(), true, 0);
            island.teleport((Entity)event.getPlayer().getPlayer());
        }
        if (Loader.isModLoaded((String)"ftbutilities")) {
            FTBUtilitiesIntegration.onPlayerJoinedTeam(event);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftTeam(ForgeTeamPlayerLeftEvent event) {
        if (TeamIslandsConfig.general.isEnabled(event.getUniverse().server) && event.getPlayer().isOnline()) {
            if (TeamIslandsConfig.general.clear_inv_when_team_left) {
                event.getPlayer().getPlayer().field_71071_by.func_174888_l();
            }
            event.getPlayer().getPlayer().setSpawnChunk(TeamIslandsUniverseData.INSTANCE.getIsland(0).getEntitySpawnPos(), true, 0);
            TeamIslandsUniverseData.INSTANCE.getIsland(0).teleport((Entity)event.getPlayer().getPlayer());
        }
    }

    @SubscribeEvent
    public static void onTeamDeleted(ForgeTeamDeletedEvent event) {
        if (!TeamIslandsConfig.general.isEnabled(event.getUniverse().server)) {
            return;
        }
        Island island = TeamIslandsUniverseData.INSTANCE.getIsland(event.getTeam());
        if (!island.isLobby()) {
            island.active = false;
        }
    }
}

