/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.teamislands;

import com.feed_the_beast.ftblib.lib.math.TeleporterDimPos;
import com.feed_the_beast.teamislands.TeamIslandsConfig;
import com.feed_the_beast.teamislands.TeamIslandsUniverseData;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class Island {
    public final TeamIslandsUniverseData data;
    public final int id;
    public final int x;
    public final int z;
    public boolean active;
    public boolean spawned;
    public String creator;
    public BlockPos spawnPoint;

    public Island(TeamIslandsUniverseData d, int i, int _x, int _z, String c) {
        this.data = d;
        this.id = i;
        this.x = _x;
        this.z = _z;
        this.active = true;
        this.spawned = false;
        this.creator = c;
        this.spawnPoint = new BlockPos(this.x * 512 + 256, TeamIslandsConfig.islands.height, this.z * 512 + 256);
    }

    public Island(TeamIslandsUniverseData d, int i, NBTTagCompound nbt) {
        this.data = d;
        this.id = i;
        this.x = nbt.func_74762_e("X");
        this.z = nbt.func_74762_e("Z");
        this.active = !nbt.func_74767_n("Inactive");
        this.spawned = nbt.func_74767_n("Spawned");
        this.creator = nbt.func_74779_i("Creator");
        this.spawnPoint = new BlockPos(nbt.func_74762_e("SpawnX"), nbt.func_74762_e("SpawnY"), nbt.func_74762_e("SpawnZ"));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("X", this.x);
        nbt.func_74768_a("Z", this.z);
        nbt.func_74757_a("Inactive", !this.active);
        nbt.func_74757_a("Spawned", this.spawned);
        nbt.func_74778_a("Creator", this.creator);
        nbt.func_74768_a("SpawnX", this.spawnPoint.func_177958_n());
        nbt.func_74768_a("SpawnY", this.spawnPoint.func_177956_o());
        nbt.func_74768_a("SpawnZ", this.spawnPoint.func_177952_p());
    }

    public boolean isLobby() {
        return this.id <= 0;
    }

    public BlockPos getBlockPos() {
        if (this.isLobby()) {
            BlockPos spawnpoint = this.data.universe.world.func_175694_M();
            while (this.data.universe.world.func_180495_p(spawnpoint).func_185917_h()) {
                spawnpoint = spawnpoint.func_177984_a();
            }
            return spawnpoint;
        }
        return this.spawnPoint;
    }

    public BlockPos getEntitySpawnPos() {
        if (this.isLobby()) {
            BlockPos spawnpoint = this.data.universe.world.func_175694_M();
            while (this.data.universe.world.func_180495_p(spawnpoint).func_185917_h()) {
                spawnpoint = spawnpoint.func_177984_a();
            }
            return spawnpoint;
        }
        return this.spawnPoint.func_177971_a((Vec3i)this.data.relativeSpawn);
    }

    public void teleport(Entity entity) {
        TeleporterDimPos.of((BlockPos)this.getEntitySpawnPos(), (int)0).teleport(entity);
    }
}

