/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.teamislands;

import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.command.CmdTreeBase;
import com.feed_the_beast.ftblib.lib.command.CommandUtils;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.teamislands.TeamIslandsConfig;
import com.feed_the_beast.teamislands.TeamIslandsUniverseData;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;

public class CmdTeamIslands
extends CmdTreeBase {
    public CmdTeamIslands() {
        super("teamislands");
        this.addSubcommand((ICommand)new CmdIsland());
        this.addSubcommand((ICommand)new CmdLobby());
        if (TeamIslandsConfig.general.enable_myisland_command) {
            this.addSubcommand((ICommand)new CmdMyIsand());
        }
    }

    private static class CmdMyIsand
    extends CmdBase {
        private CmdMyIsand() {
            super("myisland", CmdBase.Level.ALL);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            ForgePlayer player = CommandUtils.getForgePlayer((ICommandSender)sender);
            if (player.hasTeam()) {
                TeamIslandsUniverseData.INSTANCE.getIsland(player.team).teleport((Entity)player.getPlayer());
            }
        }
    }

    private static class CmdLobby
    extends CmdBase {
        private CmdLobby() {
            super("lobby", CmdBase.Level.ALL);
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            this.checkArgs(sender, args, 1);
            TeamIslandsUniverseData.INSTANCE.getIsland(0).teleport((Entity)CmdLobby.func_184888_a((MinecraftServer)server, (ICommandSender)server, (String)args[0]));
        }
    }

    private static class CmdIsland
    extends CmdBase {
        private CmdIsland() {
            super("island", CmdBase.Level.OP);
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            this.checkArgs(sender, args, 1);
            ForgePlayer player = CommandUtils.getForgePlayer((ICommandSender)sender, (String)args[0]);
            if (player.isOnline() && player.hasTeam()) {
                TeamIslandsUniverseData.INSTANCE.getIsland(player.team).teleport((Entity)player.getPlayer());
            }
        }
    }
}

