/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.proxy;

import java.io.File;
import java.lang.reflect.Method;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.proxy.AbstractCommonProxy;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WrenchChecker;
import mcjty.rftools.CommandHandler;
import mcjty.rftools.ForgeEventHandlers;
import mcjty.rftools.GeneralConfiguration;
import mcjty.rftools.RFTools;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.blocks.ModBlocks;
import mcjty.rftools.blocks.blockprotector.BlockProtectorConfiguration;
import mcjty.rftools.blocks.booster.BoosterConfiguration;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.crafter.CrafterConfiguration;
import mcjty.rftools.blocks.elevator.ElevatorConfiguration;
import mcjty.rftools.blocks.endergen.EndergenicConfiguration;
import mcjty.rftools.blocks.environmental.EnvironmentalConfiguration;
import mcjty.rftools.blocks.generator.CoalGeneratorConfiguration;
import mcjty.rftools.blocks.infuser.MachineInfuserConfiguration;
import mcjty.rftools.blocks.powercell.PowerCellConfiguration;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.security.SecurityConfiguration;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.blocks.shield.ShieldConfiguration;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storagemonitor.StorageScannerConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.crafting.ModCrafting;
import mcjty.rftools.gui.GuiProxy;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.netmonitor.NetworkMonitorConfiguration;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.playerprops.BuffProperties;
import mcjty.rftools.playerprops.FavoriteDestinationsProperties;
import mcjty.rftools.world.ModWorldgen;
import mcjty.rftools.world.WorldTickHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy
extends AbstractCommonProxy {
    public static Method Block_getSilkTouch;

    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        CommandHandler.registerCommands();
        this.reflect();
        GeneralConfig.preInit((FMLPreInitializationEvent)e);
        this.mainConfig = new Configuration(new File(this.modConfigDir.getPath() + File.separator + "rftools", "rftools.cfg"));
        CapabilityManager.INSTANCE.register(BuffProperties.class, (Capability.IStorage)new Capability.IStorage<BuffProperties>(){

            public NBTBase writeNBT(Capability<BuffProperties> capability, BuffProperties instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<BuffProperties> capability, BuffProperties instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
        CapabilityManager.INSTANCE.register(FavoriteDestinationsProperties.class, (Capability.IStorage)new Capability.IStorage<FavoriteDestinationsProperties>(){

            public NBTBase writeNBT(Capability<FavoriteDestinationsProperties> capability, FavoriteDestinationsProperties instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<FavoriteDestinationsProperties> capability, FavoriteDestinationsProperties instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
        CapabilityManager.INSTANCE.register(IModuleProvider.class, (Capability.IStorage)new Capability.IStorage<IModuleProvider>(){

            public NBTBase writeNBT(Capability<IModuleProvider> capability, IModuleProvider instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<IModuleProvider> capability, IModuleProvider instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
        this.readMainConfig();
        SimpleNetworkWrapper network = PacketHandler.registerMessages((String)"rftools", (String)"rftools");
        RFToolsMessages.registerNetworkMessages(network);
        ModItems.init();
        ModBlocks.init();
        ModWorldgen.init();
        RFTools.screenModuleRegistry.registerBuiltins();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)RFTools.instance, (tickets, world) -> {});
    }

    private void reflect() {
        Block_getSilkTouch = ReflectionHelper.findMethod(Block.class, (String)"getSilkTouchDrop", (String)"func_180643_i", (Class[])new Class[]{IBlockState.class});
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment("general", "General settings");
            cfg.addCustomCategoryComment("security", "Settings for the block security system");
            cfg.addCustomCategoryComment("coalgen", "Settings for the coal generator");
            cfg.addCustomCategoryComment("crafter", "Settings for the crafter");
            cfg.addCustomCategoryComment("storage", "Settings for the modular storage system");
            cfg.addCustomCategoryComment("storageconfig", "Generic item module categories for various items");
            cfg.addCustomCategoryComment("screen", "Settings for the screen system");
            cfg.addCustomCategoryComment("infuser", "Settings for the infuser");
            cfg.addCustomCategoryComment("builder", "Settings for the builder");
            cfg.addCustomCategoryComment("scanner", "Settings for the scanner, composer, and projector");
            cfg.addCustomCategoryComment("powercell", "Settings for the powercell");
            cfg.addCustomCategoryComment("shield", "Settings for the shield system");
            cfg.addCustomCategoryComment("environmental", "Settings for the environmental controller");
            cfg.addCustomCategoryComment("spawner", "Settings for the spawner system");
            cfg.addCustomCategoryComment("mobspawnamounts", "Amount of materials needed to spawn mobs");
            cfg.addCustomCategoryComment("mobspawnrf", "Amount of RF needed to spawn mobs");
            cfg.addCustomCategoryComment("livingmatter", "Blocks and items that are seen as living for the spawner");
            cfg.addCustomCategoryComment("blockprotector", "Settings for the block protector machine");
            cfg.addCustomCategoryComment("networkmonitor", "Settings for the network monitor item");
            cfg.addCustomCategoryComment("endergenic", "Settings for the endergenic generator");
            cfg.addCustomCategoryComment("storagemonitor", "Settings for the storage scanner machine");
            cfg.addCustomCategoryComment("elevator", "Settings for the elevator");
            cfg.addCustomCategoryComment("booster", "Settings for the booster");
            GeneralConfiguration.init(cfg);
            SecurityConfiguration.init(cfg);
            CoalGeneratorConfiguration.init(cfg);
            CrafterConfiguration.init(cfg);
            ModularStorageConfiguration.init(cfg);
            ScreenConfiguration.init(cfg);
            MachineInfuserConfiguration.init(cfg);
            BuilderConfiguration.init(cfg);
            ScannerConfiguration.init(cfg);
            PowerCellConfiguration.init(cfg);
            ShieldConfiguration.init(cfg);
            EnvironmentalConfiguration.init(cfg);
            SpawnerConfiguration.init(cfg);
            BlockProtectorConfiguration.init(cfg);
            NetworkMonitorConfiguration.init(cfg);
            EndergenicConfiguration.init(cfg);
            StorageScannerConfiguration.init(cfg);
            ElevatorConfiguration.init(cfg);
            BoosterConfiguration.init(cfg);
            TeleportConfiguration.init(cfg);
        }
        catch (Exception e1) {
            Logging.getLogger().log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        super.init(e);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)RFTools.instance, (IGuiHandler)new GuiProxy());
        MinecraftForge.EVENT_BUS.register((Object)WorldTickHandler.instance);
        ModCrafting.init();
    }

    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        this.mainConfig = null;
        WrenchChecker.init();
    }
}

