/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import mcjty.rftools.blocks.crafter.PacketCrafter;
import mcjty.rftools.craftinggrid.CraftingRecipe;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCrafter
extends GenericGuiContainer<CrafterBaseTE> {
    private EnergyBar energyBar;
    private WidgetList recipeList;
    private ChoiceLabel keepItem;
    private ChoiceLabel internalRecipe;
    private Button applyButton;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private static int lastSelected = -1;

    public GuiCrafter(CrafterBaseTE te, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)te, (Container)container, RFTools.GUI_MANUAL_MAIN, "crafter");
        GenericEnergyStorageTileEntity.setCurrentRF((long)te.getStoredPower());
    }

    public void func_73866_w_() {
        this.window = new Window((GuiScreen)this, this.tileEntity, RFToolsMessages.INSTANCE, new ResourceLocation("rftools", "gui/crafter.gui"));
        super.func_73866_w_();
        this.initializeFields();
        if (lastSelected != -1 && lastSelected < ((CrafterBaseTE)this.tileEntity).func_70302_i_()) {
            this.recipeList.setSelected(lastSelected);
        }
        this.window.event("apply", (source, params) -> this.applyRecipe());
        this.window.event("select", (source, params) -> this.selectRecipe());
        ((CrafterBaseTE)this.tileEntity).requestRfFromServer("rftools");
    }

    private void initializeFields() {
        this.recipeList = (WidgetList)this.window.findChild("recipes");
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.applyButton = (Button)this.window.findChild("apply");
        this.keepItem = (ChoiceLabel)this.window.findChild("keep");
        this.internalRecipe = (ChoiceLabel)this.window.findChild("internal");
        this.energyBar.setMaxValue(((CrafterBaseTE)this.tileEntity).getCapacity());
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        ((ImageChoiceLabel)this.window.findChild("redstone")).setCurrentChoice(((CrafterBaseTE)this.tileEntity).getRSMode().ordinal());
        ((ImageChoiceLabel)this.window.findChild("speed")).setCurrentChoice(((CrafterBaseTE)this.tileEntity).getSpeedMode());
        this.populateList();
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < ((CrafterBaseTE)this.tileEntity).getSupportedRecipes(); ++i) {
            CraftingRecipe recipe = ((CrafterBaseTE)this.tileEntity).getRecipe(i);
            this.addRecipeLine(recipe.getResult());
        }
    }

    private void addRecipeLine(ItemStack craftingResult) {
        String readableName = BlockTools.getReadableName((ItemStack)craftingResult);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult.func_190926_b()) {
            readableName = "<no recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)craftingResult).setTooltips(new String[]{"Double click to edit this recipe"}))).addChild((Widget)((Label)((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(color)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDynamic(true)).setText(readableName)).setTooltips(new String[]{"Double click to edit this recipe"}));
        this.recipeList.addChild((Widget)panel);
    }

    private void selectRecipe() {
        int selected;
        lastSelected = selected = this.recipeList.getSelected();
        if (selected == -1) {
            for (int i = 0; i < 10; ++i) {
                this.field_147002_h.func_75139_a(i).func_75215_d(ItemStack.field_190927_a);
            }
            this.keepItem.setChoice("All");
            this.internalRecipe.setChoice("Ext");
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        InventoryCrafting inv = craftingRecipe.getInventory();
        for (int i = 0; i < 9; ++i) {
            this.field_147002_h.func_75139_a(i).func_75215_d(inv.func_70301_a(i));
        }
        this.field_147002_h.func_75139_a(9).func_75215_d(craftingRecipe.getResult());
        this.keepItem.setChoice(craftingRecipe.isKeepOne() ? "Keep" : "All");
        this.internalRecipe.setChoice(craftingRecipe.getCraftMode().getDescription());
    }

    private void testRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.field_147002_h.func_75139_a(i).func_75211_c());
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.field_146297_k.field_71441_e, inv);
        ItemStack newResult = recipe == null ? ItemStack.field_190927_a : recipe.func_77572_b(inv);
        this.field_147002_h.func_75139_a(9).func_75215_d(newResult);
    }

    private void applyRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        if (selected >= ((CrafterBaseTE)this.tileEntity).getSupportedRecipes()) {
            this.recipeList.setSelected(-1);
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        InventoryCrafting inv = craftingRecipe.getInventory();
        for (int i = 0; i < 9; ++i) {
            ItemStack newStack;
            ItemStack oldStack = inv.func_70301_a(i);
            if (this.itemStacksEqual(oldStack, newStack = this.field_147002_h.func_75139_a(i).func_75211_c())) continue;
            inv.func_70299_a(i, newStack);
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.field_146297_k.field_71441_e, inv);
        ItemStack newResult = recipe == null ? ItemStack.field_190927_a : recipe.func_77572_b(inv);
        ItemStack oldResult = this.field_147002_h.func_75139_a(9).func_75211_c();
        if (!this.itemStacksEqual(oldResult, newResult)) {
            this.field_147002_h.func_75139_a(9).func_75215_d(newResult);
        }
        craftingRecipe.setResult(newResult);
        this.updateRecipe();
        this.populateList();
    }

    private void updateRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        boolean keepOne = "Keep".equals(this.keepItem.getCurrentChoice());
        CraftingRecipe.CraftMode mode = "Int".equals(this.internalRecipe.getCurrentChoice()) ? CraftingRecipe.CraftMode.INT : ("Ext".equals(this.internalRecipe.getCurrentChoice()) ? CraftingRecipe.CraftMode.EXT : CraftingRecipe.CraftMode.EXTC);
        craftingRecipe.setKeepOne(keepOne);
        craftingRecipe.setCraftMode(mode);
        this.sendChangeToServer(selected, craftingRecipe.getInventory(), craftingRecipe.getResult(), keepOne, mode);
    }

    private boolean itemStacksEqual(ItemStack matches, ItemStack oldStack) {
        if (matches.func_190926_b()) {
            return oldStack.func_190926_b();
        }
        return !oldStack.func_190926_b() && matches.func_77969_a(oldStack);
    }

    private void sendChangeToServer(int index, InventoryCrafting inv, ItemStack result, boolean keepOne, CraftingRecipe.CraftMode mode) {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketCrafter(((CrafterBaseTE)this.tileEntity).func_174877_v(), index, inv, result, keepOne, mode));
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.updateButtons();
        super.func_73863_a(par1, par2, par3);
        this.testRecipe();
    }

    private void updateButtons() {
        boolean selected = this.recipeList.getSelected() != -1;
        this.keepItem.setEnabled(selected);
        this.internalRecipe.setEnabled(selected);
        this.applyButton.setEnabled(selected);
    }

    protected void func_146976_a(float v, int x, int y) {
        this.drawWindow();
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((CrafterBaseTE)this.tileEntity).requestRfFromServer("rftools");
        this.drawGhostSlots();
    }

    private void drawGhostSlots() {
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        ItemStackList ghostSlots = ((CrafterBaseTE)this.tileEntity).getGhostSlots();
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        for (int i = 0; i < ghostSlots.size(); ++i) {
            int slotIdx;
            Slot slot;
            ItemStack stack = (ItemStack)ghostSlots.get(i);
            if (stack.func_190926_b() || (slot = this.field_147002_h.func_75139_a(slotIdx = i < 26 ? i + 10 : i + 36 - 26)).func_75216_d()) continue;
            this.field_146296_j.func_180450_b(stack, slot.field_75223_e, slot.field_75221_f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179097_i();
            this.field_146297_k.func_110434_K().func_110577_a(iconGuiElements);
            RenderHelper.drawTexturedModalRect((int)slot.field_75223_e, (int)slot.field_75221_f, (int)224, (int)48, (int)16, (int)16);
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
        GlStateManager.func_179121_F();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
    }
}

