/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry.bee;

import elec332.core.asm.ASMTransformer;
import elec332.core.asm.AbstractASMClassTransformer;
import elec332.core.util.MCVersion;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@ASMTransformer
public class ForestryCompatFixer
extends AbstractASMClassTransformer {
    private static final String owner = "forestry/api/apiculture/IHiveDrop";
    private static final String name = "getExtraItems";
    private static final String newDesc = "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;I)Ljava/util/Collection;";

    @Override
    public String getDeObfuscatedClassName() {
        return "elec332.core.compat.forestry.bee.IHiveEnum";
    }

    @Override
    public boolean transformClass(ClassNode classNode) {
        if (!MCVersion.getCurrentVersion().isLowerThan(MCVersion.MC_1_11)) {
            return false;
        }
        for (MethodNode mn : classNode.methods) {
            InsnList insnList = mn.instructions;
            for (int i = 0; i < insnList.size(); ++i) {
                AbstractInsnNode ain = insnList.get(i);
                if (ain.getOpcode() != 185) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.owner.equals(owner) || !min.name.equals(name)) continue;
                min.desc = newDesc;
            }
        }
        return true;
    }
}

