/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.abstraction.abstracted.item;

import elec332.core.abstraction.DefaultInstances;
import elec332.core.abstraction.IItem;
import elec332.core.abstraction.IItemArmor;
import elec332.core.abstraction.IItemArrow;
import elec332.core.abstraction.IItemBlock;
import elec332.core.abstraction.abstracted.IAbstractionType;
import elec332.core.abstraction.abstracted.item.AbstractedItemArmor;
import elec332.core.abstraction.abstracted.item.AbstractedItemArrow;
import elec332.core.abstraction.abstracted.item.AbstractedItemBlock;
import elec332.core.abstraction.abstracted.item.IAbstractedItem;
import elec332.core.abstraction.abstracted.item.ItemClassModifier;
import elec332.core.util.ASMHelper;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBlock;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public enum ItemType implements IAbstractionType<IItem, Item>
{
    ITEM(IItem.class, Item.class, null, null, new Object[0]),
    ARROW(IItemArrow.class, ItemArrow.class, AbstractedItemArrow.class, null, new Object[0]),
    ARMOR((Class)IItemArmor.class, (Class)ItemArmor.class, (Class)AbstractedItemArmor.class, null, new Object[0]){

        @Override
        public Object[] getParams(IItem iItem) {
            super.getParams(iItem);
            return new Object[]{((IItemArmor)iItem).getArmorMaterial(), ((IItemArmor)iItem).getRenderIndex(), ((IItemArmor)iItem).getEquipmentSlot()};
        }
    }
    ,
    ITEMBLOCK((Class)IItemBlock.class, (Class)ItemBlock.class, (Class)AbstractedItemBlock.class, new ASMHelper.IClassModifier(){

        @Override
        public ClassWriter modifyClass(String internalClassName, ClassWriter cw, Object ... additionalData) {
            ClassNode cn = new ClassNode(327680);
            ClassReader cr = new ClassReader(cw.toByteArray());
            cr.accept((ClassVisitor)cn, 0);
            for (MethodNode mn : cn.methods) {
                if (!mn.name.equals("<init>")) continue;
                mn.instructions.remove(mn.instructions.getLast());
                mn.visitVarInsn(25, 0);
                mn.visitVarInsn(25, 0);
                mn.visitFieldInsn(180, internalClassName, "instance", Type.getDescriptor(Object.class));
                mn.visitTypeInsn(192, Type.getInternalName(IItemBlock.class));
                mn.visitMethodInsn(184, Type.getInternalName(DefaultInstances.class), "getDefaultBlockPlacementBehaviour", "(" + Type.getDescriptor(IItemBlock.class) + ")" + Type.getDescriptor(IItemBlock.IDefaultBlockPlaceBehaviour.class), false);
                mn.visitFieldInsn(181, internalClassName, "defaultBlockPlaceBehaviour", Type.getDescriptor(IItemBlock.IDefaultBlockPlaceBehaviour.class));
                mn.visitInsn(177);
                mn.maxStack += 2;
                mn.maxLocals += 2;
            }
            ClassWriter ret = new ClassWriter(0);
            cn.accept((ClassVisitor)ret);
            return ret;
        }
    }, new Object[0]){

        @Override
        public Object[] getParams(IItem item) {
            super.getParams(item);
            return new Object[]{((IItemBlock)item).getBlock()};
        }
    };

    private final Class<? extends IItem> itemType;
    private final Class<? extends Item> baseType;
    private final Class<? extends Item> copyType;
    private final ASMHelper.IClassModifier modifier;
    private final Object[] params;

    private <V extends Item, I extends Item, T extends IItem> ItemType(@Nullable Class<T> itemType, @Nullable Class<I> baseType, Class<V> copyType, ASMHelper.IClassModifier modifier, Object ... params) {
        this.itemType = itemType;
        this.baseType = baseType;
        this.copyType = copyType;
        if (copyType != null && !baseType.isAssignableFrom(copyType)) {
            throw new IllegalArgumentException();
        }
        this.params = params == null ? new Object[]{} : params;
        this.modifier = modifier;
    }

    @Override
    public Class<? extends IItem> getAbstractionType() {
        return this.itemType;
    }

    @Override
    public Class<? extends Item> getBaseType() {
        return this.baseType;
    }

    @Override
    public Object[] getParams(IItem item) {
        if (item == null || !this.itemType.isInstance(item)) {
            throw new IllegalArgumentException();
        }
        return this.params;
    }

    @Override
    public ASMHelper.IClassModifier getClassModifier() {
        return ASMHelper.IClassModifier.combine(ItemClassModifier.DEFAULT, this.copyType == null ? null : new ItemClassModifier(this.copyType), this.modifier);
    }

    @Override
    public Class<IItem> getBaseAbstractionType() {
        return IItem.class;
    }

    @Override
    public Class<?> getInterfaceExclusion() {
        return IAbstractedItem.class;
    }
}

