/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.client;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.client.ModelBuilder;
import com.feed_the_beast.ftblib.lib.client.SpriteSet;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.misc.TextureSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.latmod.yabba.api.BarrelSkin;
import com.latmod.yabba.util.EnumBarrelModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class BarrelModel {
    public static final Set<EnumFacing> SET_ALL_FACES = new HashSet<EnumFacing>(Arrays.asList(EnumFacing.field_82609_l));
    public final EnumBarrelModel id;
    public final Map<String, TextureSet> textures;
    public final List<ModelFunction> model;
    public final List<ModelFunction> itemModel;
    public Map<String, SpriteSet> textureMap;
    public SpriteSet currentTexture;
    public Vec3d offset;
    public final float textDistance;
    public final float iconDistance;
    public BlockRenderLayer currentLayer;
    public Icon icon = Icon.EMPTY;

    public static Set<EnumFacing> parseFaces(JsonArray json) {
        HashSet set = new HashSet();
        block10: for (JsonElement e : json) {
            String f;
            switch (f = e.getAsString()) {
                case "x": {
                    set.add(EnumFacing.WEST);
                    set.add(EnumFacing.EAST);
                    continue block10;
                }
                case "y": {
                    set.add(EnumFacing.DOWN);
                    set.add(EnumFacing.UP);
                    continue block10;
                }
                case "z": {
                    set.add(EnumFacing.NORTH);
                    set.add(EnumFacing.SOUTH);
                    continue block10;
                }
            }
            set.add(EnumFacing.func_176739_a((String)f));
        }
        return set.isEmpty() ? Collections.emptySet() : set;
    }

    public static Vec3d parseVec(JsonElement e) {
        JsonObject o;
        if (e.isJsonArray()) {
            JsonArray a = e.getAsJsonArray();
            if (a.size() == 3) {
                return new Vec3d(a.get(0).getAsDouble(), a.get(1).getAsDouble(), a.get(2).getAsDouble());
            }
        } else if (e.isJsonObject() && (o = e.getAsJsonObject()).has("x") && o.has("y") && o.has("z")) {
            return new Vec3d(o.get("x").getAsDouble(), o.get("y").getAsDouble(), o.get("z").getAsDouble());
        }
        return Vec3d.field_186680_a;
    }

    public static Pair<Vec3d, Vec3d> parseVecPair(JsonElement e) {
        JsonArray a;
        if (e.isJsonArray() && (a = e.getAsJsonArray()).size() == 6) {
            double x0 = a.get(0).getAsDouble();
            double y0 = a.get(1).getAsDouble();
            double z0 = a.get(2).getAsDouble();
            double x1 = a.get(3).getAsDouble();
            double y1 = a.get(4).getAsDouble();
            double z1 = a.get(5).getAsDouble();
            return Pair.of((Object)new Vec3d(x0, y0, z0), (Object)new Vec3d(x1, y1, z1));
        }
        return Pair.of((Object)Vec3d.field_186680_a, (Object)Vec3d.field_186680_a);
    }

    @Nullable
    public static ModelFunction parseFunction(JsonObject json) {
        if (json.has("add")) {
            switch (json.get("add").getAsString()) {
                case "cube": {
                    Cube cube = new Cube();
                    Cube.parseCube(cube, json);
                    return cube;
                }
                case "inverted_cube": 
                case "cube_inverted": {
                    InvertedCube cube = new InvertedCube();
                    Cube.parseCube(cube, json);
                    return cube;
                }
            }
        } else {
            if (json.has("uvlock")) {
                return json.get("uvlock").getAsBoolean() ? SetUvlock.TRUE : SetUvlock.FALSE;
            }
            if (json.has("shade")) {
                return json.get("shade").getAsBoolean() ? SetShade.TRUE : SetShade.FALSE;
            }
            if (json.has("texture")) {
                return new SetTexture(json.get("texture").getAsString());
            }
            if (json.has("offset")) {
                return new SetOffset(BarrelModel.parseVec(json.get("offset")));
            }
            if (json.has("layer")) {
                return new SetLayer((BlockRenderLayer)ClientUtils.BLOCK_RENDER_LAYER_NAME_MAP.get(json.get("layer").getAsString()));
            }
        }
        return null;
    }

    public BarrelModel(EnumBarrelModel _id, JsonObject json) {
        ModelFunction func;
        this.id = _id;
        if (json.has("textures")) {
            this.textures = new HashMap<String, TextureSet>();
            for (Map.Entry entry : json.get("textures").getAsJsonObject().entrySet()) {
                this.textures.put((String)entry.getKey(), TextureSet.of((JsonElement)((JsonElement)entry.getValue())));
            }
        } else {
            this.textures = Collections.emptyMap();
        }
        this.model = new ArrayList<ModelFunction>();
        for (JsonElement e : json.get("model").getAsJsonArray()) {
            if (!e.isJsonObject() || (func = BarrelModel.parseFunction(e.getAsJsonObject())) == null) continue;
            this.model.add(func);
        }
        if (json.has("item_model")) {
            this.itemModel = new ArrayList<ModelFunction>();
            for (JsonElement e : json.get("item_model").getAsJsonArray()) {
                if (!e.isJsonObject() || (func = BarrelModel.parseFunction(e.getAsJsonObject())) == null) continue;
                this.itemModel.add(func);
            }
        } else {
            this.itemModel = this.model;
        }
        this.textDistance = (json.has("text_distance") ? json.get("text_distance").getAsFloat() : -0.08f) / 16.0f;
        this.iconDistance = (json.has("icon_distance") ? json.get("icon_distance").getAsFloat() : 0.64f) / 16.0f;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BarrelModel) {
            return this.id.equals((Object)((BarrelModel)o).id);
        }
        return false;
    }

    public String toString() {
        return I18n.func_135052_a((String)this.id.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public List<BakedQuad> buildModel(VertexFormat format, ModelRotation rotation, BarrelSkin skin, BlockRenderLayer layer, @Nullable EnumFacing side) {
        this.currentTexture = this.textureMap.get("skin");
        if (this.currentTexture == null || this.currentTexture == SpriteSet.EMPTY) {
            return Collections.emptyList();
        }
        this.offset = Vec3d.field_186680_a;
        this.currentLayer = skin.layer;
        ModelBuilder builder = new ModelBuilder(format, rotation);
        for (ModelFunction func : this.model) {
            func.apply(builder, this, skin, layer, side);
        }
        this.currentTexture = SpriteSet.EMPTY;
        this.offset = Vec3d.field_186680_a;
        return builder.getQuads().isEmpty() ? Collections.emptyList() : Arrays.asList(builder.getQuads().toArray(new BakedQuad[0]));
    }

    public List<BakedQuad> buildItemModel(VertexFormat format, BarrelSkin skin, @Nullable EnumFacing side) {
        this.currentTexture = this.textureMap.get("skin");
        if (this.currentTexture == null || this.currentTexture == SpriteSet.EMPTY) {
            return Collections.emptyList();
        }
        this.offset = Vec3d.field_186680_a;
        this.currentLayer = skin.layer;
        ModelBuilder builder = new ModelBuilder(format, ModelRotation.X0_Y0);
        for (ModelFunction func : this.itemModel) {
            func.apply(builder, this, skin, BlockRenderLayer.SOLID, side);
        }
        this.currentTexture = this.textureMap.get("skin");
        this.offset = Vec3d.field_186680_a;
        this.currentLayer = skin.layer;
        for (ModelFunction func : this.itemModel) {
            func.apply(builder, this, skin, BlockRenderLayer.CUTOUT, side);
        }
        this.currentTexture = this.textureMap.get("skin");
        this.offset = Vec3d.field_186680_a;
        this.currentLayer = skin.layer;
        for (ModelFunction func : this.itemModel) {
            func.apply(builder, this, skin, BlockRenderLayer.TRANSLUCENT, side);
        }
        this.currentTexture = SpriteSet.EMPTY;
        this.offset = Vec3d.field_186680_a;
        return builder.getQuads().isEmpty() ? Collections.emptyList() : Arrays.asList(builder.getQuads().toArray(new BakedQuad[0]));
    }

    public static class InvertedCube
    extends Cube {
        @Override
        public void apply(ModelBuilder builder, BarrelModel model, BarrelSkin skin, BlockRenderLayer layer, @Nullable EnumFacing side) {
            if (this.faces.isEmpty() || model.currentLayer != layer) {
                return;
            }
            builder.setTintIndex(!skin.color.isEmpty() && model.currentTexture == model.textureMap.get("skin") ? 0 : -1);
            Vector3f fromv = new Vector3f((float)(model.offset.field_72450_a + this.from.field_72450_a), (float)(model.offset.field_72448_b + this.from.field_72448_b), (float)(model.offset.field_72449_c + this.from.field_72449_c));
            Vector3f tov = new Vector3f((float)(model.offset.field_72450_a + this.to.field_72450_a), (float)(model.offset.field_72448_b + this.to.field_72448_b), (float)(model.offset.field_72449_c + this.to.field_72449_c));
            for (EnumFacing facing : this.faces) {
                if (this.drawFace(side, facing)) continue;
                builder.addQuad(tov, fromv, facing, model.currentTexture.get(facing));
            }
        }
    }

    public static class Cube
    implements ModelFunction {
        public Vec3d from;
        public Vec3d to;
        public Set<EnumFacing> faces;
        public Set<EnumFacing> cull;

        public static void parseCube(Cube c, JsonObject o) {
            if (o.has("from_to")) {
                Pair<Vec3d, Vec3d> vecs = BarrelModel.parseVecPair(o.get("from_to"));
                c.from = (Vec3d)vecs.getLeft();
                c.to = (Vec3d)vecs.getRight();
            } else if (o.has("pos_size")) {
                Pair<Vec3d, Vec3d> vecs = BarrelModel.parseVecPair(o.get("pos_size"));
                c.from = (Vec3d)vecs.getLeft();
                c.to = c.from.func_178787_e((Vec3d)vecs.getRight());
            } else if (o.has("center_size")) {
                Pair<Vec3d, Vec3d> vecs = BarrelModel.parseVecPair(o.get("center_size"));
                Vec3d size = ((Vec3d)vecs.getRight()).func_186678_a(0.5);
                c.from = ((Vec3d)vecs.getLeft()).func_178788_d(size);
                c.to = ((Vec3d)vecs.getLeft()).func_178787_e(size);
            }
            c.faces = SET_ALL_FACES;
            if (o.has("faces")) {
                c.faces = BarrelModel.parseFaces(JsonUtils.toArray((JsonElement)o.get("faces")));
            } else if (o.has("faces_except")) {
                c.faces = new HashSet<EnumFacing>(SET_ALL_FACES);
                c.faces.removeAll(BarrelModel.parseFaces(JsonUtils.toArray((JsonElement)o.get("faces_except"))));
            }
            c.cull = Collections.emptySet();
            if (o.has("cull")) {
                c.cull = BarrelModel.parseFaces(JsonUtils.toArray((JsonElement)o.get("cull")));
            } else if (o.has("cull_except")) {
                c.cull = new HashSet<EnumFacing>(SET_ALL_FACES);
                c.cull.removeAll(BarrelModel.parseFaces(JsonUtils.toArray((JsonElement)o.get("cull_except"))));
            }
        }

        @Override
        public void apply(ModelBuilder builder, BarrelModel model, BarrelSkin skin, BlockRenderLayer layer, @Nullable EnumFacing side) {
            if (this.faces.isEmpty() || model.currentLayer != layer) {
                return;
            }
            builder.setTintIndex(!skin.color.isEmpty() && model.currentTexture == model.textureMap.get("skin") ? 0 : -1);
            Vector3f fromv = new Vector3f((float)(model.offset.field_72450_a + this.from.field_72450_a), (float)(model.offset.field_72448_b + this.from.field_72448_b), (float)(model.offset.field_72449_c + this.from.field_72449_c));
            Vector3f tov = new Vector3f((float)(model.offset.field_72450_a + this.to.field_72450_a), (float)(model.offset.field_72448_b + this.to.field_72448_b), (float)(model.offset.field_72449_c + this.to.field_72449_c));
            for (EnumFacing facing : this.faces) {
                if (!this.drawFace(side, facing)) continue;
                builder.addQuad(fromv, tov, facing, model.currentTexture.get(facing));
            }
        }

        protected boolean drawFace(@Nullable EnumFacing side, EnumFacing facing) {
            return side == null;
        }
    }

    public static class SetLayer
    implements ModelFunction {
        public final BlockRenderLayer layer;

        public SetLayer(BlockRenderLayer l) {
            this.layer = l;
        }

        @Override
        public void applyFunction(ModelBuilder builder, BarrelModel model) {
            model.currentLayer = this.layer;
        }
    }

    public static class SetOffset
    implements ModelFunction {
        public final Vec3d off;

        public SetOffset(Vec3d o) {
            this.off = o;
        }

        @Override
        public void applyFunction(ModelBuilder builder, BarrelModel model) {
            model.offset = this.off;
        }
    }

    public static class SetTexture
    implements ModelFunction {
        public final String tex;

        public SetTexture(String t) {
            this.tex = t;
        }

        @Override
        public void applyFunction(ModelBuilder builder, BarrelModel model) {
            model.currentTexture = model.textureMap.get(this.tex);
        }
    }

    public static enum SetShade implements ModelFunction
    {
        TRUE,
        FALSE;


        @Override
        public void applyFunction(ModelBuilder builder, BarrelModel model) {
            builder.setShade(this == TRUE);
        }
    }

    public static enum SetUvlock implements ModelFunction
    {
        TRUE,
        FALSE;


        @Override
        public void applyFunction(ModelBuilder builder, BarrelModel model) {
            builder.setUVLocked(this == TRUE);
        }
    }

    public static interface ModelFunction {
        default public void apply(ModelBuilder builder, BarrelModel model, BarrelSkin skin, BlockRenderLayer layer, @Nullable EnumFacing side) {
            this.applyFunction(builder, model);
        }

        default public void applyFunction(ModelBuilder builder, BarrelModel model) {
        }
    }
}

