/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.config;

import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.config.OldConfig;
import bre.smoothfont.config.PlayerConfig;
import bre.smoothfont.util.Logger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class CommonConfig {
    protected static final String configVersion = "5";
    protected Configuration config;
    public static GlobalConfig globalConfig = null;
    public static PlayerConfig playerConfig = null;
    public static CommonConfig currentConfig = null;
    public float fontScaleRoundingToleranceRate = 0.0f;
    public float charWidthFractionToRoundUpFloat = 0.5f;
    public float mipmapLodBiasFloat = 0.0f;
    public float overlayLodBiasFloat = 0.0f;
    public boolean enableInterpolation;
    public boolean enableAlphaBlend;
    public boolean enablePremultipliedAlpha;
    public boolean enableDouble;
    public boolean excludeIntMultiple;
    public double fontScaleRoundingTolerance;
    public boolean excludeHighMag;
    public double limitMagnification;
    public boolean alternativeInterpolation;
    public boolean removeScaleRestriction;
    public boolean disableSmallItalic;
    public boolean enableMipmap;
    public int mipmapLevel;
    public int mipmapLodBias;
    public int overlayLodBias;
    public int brightness;
    public boolean autoBrightness;
    public boolean useOSFont;
    public String fontName;
    public String secondaryFontName;
    public int fontAntiAlias;
    public int fontEmphasis;
    public int fontResIndex;
    public boolean fontAutoSizing;
    public int fontSizeAdjustment;
    public int fontGap;
    public int fontSpaceWidth;
    public int fontTargetToReplace;
    public boolean fontAlignBaseline;
    public boolean fontDetailList;
    public int verticalMargin;
    public int horizontalMargin;
    public String sizeAdjustChars;
    public int shadowLength;
    public int blurReduction;
    public boolean allowNPOTTexture;
    public boolean enableAnisotropicFilter;
    public boolean forceUnicode;
    public int saveMemory;
    public double charWidthFractionToRoundUp;
    public boolean performanceMode;
    public int runMode;
    private Property enableInterpolationProp;
    private Property enableAlphaBlendProp;
    private Property enablePremultipliedAlphaProp;
    private Property enableDoubleProp;
    private Property excludeIntMultipleProp;
    private Property fontScaleRoundingToleranceProp;
    private Property excludeHighMagProp;
    private Property limitMagnificationProp;
    private Property alternativeInterpolationProp;
    private Property removeScaleRestrictionProp;
    private Property disableSmallItalicProp;
    private Property enableMipmapProp;
    private Property mipmapLevelProp;
    private Property mipmapLodBiasProp;
    private Property overlayLodBiasProp;
    private Property brightnessProp;
    private Property autoBrightnessProp;
    private Property useOSFontProp;
    private Property fontNameProp;
    private Property secondaryFontNameProp;
    private Property fontAntiAliasProp;
    private Property fontEmphasisProp;
    private Property fontResIndexProp;
    private Property fontAutoSizingProp;
    private Property fontSizeAdjProp;
    private Property fontGapProp;
    private Property fontSpaceWidthProp;
    private Property fontTargetToReplaceProp;
    private Property fontAlignBaselineProp;
    private Property fontDetailListProp;
    private Property verticalMarginProp;
    private Property horizontalMarginProp;
    private Property sizeAdjustCharsProp;
    private Property shadowLengthProp;
    private Property blurReductionProp;
    private Property allowNPOTTextureProp;
    private Property enableAnisotropicFilterProp;
    private Property forceUnicodeProp;
    private Property saveMemoryProp;
    private Property charWidthFractionToRoundUpProp;
    private Property performanceModeProp;
    private Property runModeProp;
    protected boolean enableInterpolationDefault;
    protected boolean enableAlphaBlendDefault;
    protected boolean enablePremultipliedAlphaDefault;
    protected boolean enableDoubleDefault;
    protected boolean excludeIntMultipleDefault;
    protected double fontScaleRoundingToleranceDefault;
    protected boolean excludeHighMagDefault;
    protected double limitMagnificationDefault;
    protected boolean alternativeInterpolationDefault;
    protected boolean removeScaleRestrictionDefault;
    protected boolean disableSmallItalicDefault;
    protected boolean enableMipmapDefault;
    protected int mipmapLevelDefault;
    protected int mipmapLodBiasDefault;
    protected int overlayLodBiasDefault;
    protected int brightnessDefault;
    protected boolean autoBrightnessDefault;
    protected boolean useOSFontDefault;
    protected String fontNameDefault;
    protected String secondaryFontNameDefault;
    protected int fontAntiAliasDefault;
    protected int fontEmphasisDefault;
    protected int fontResIndexDefault;
    protected boolean fontAutoSizingDefault;
    protected int fontSizeAdjustmentDefault;
    protected int fontGapDefault;
    protected int fontSpaceWidthDefault;
    protected int fontTargetToReplaceDefault;
    protected boolean fontAlignBaselineDefault;
    protected boolean fontDetailListDefault;
    protected int verticalMarginDefault;
    protected int horizontalMarginDefault;
    protected String sizeAdjustCharsDefault;
    protected int shadowLengthDefault;
    protected int blurReductionDefault;
    protected boolean allowNPOTTextureDefault;
    protected boolean enableAnisotropicFilterDefault;
    protected boolean forceUnicodeDefault;
    protected int saveMemoryDefault;
    protected double charWidthFractionToRoundUpDefault;
    protected boolean performanceModeDefault;
    protected int runModeDefault;

    public CommonConfig(File configFile) {
        this.config = new Configuration(configFile, configVersion);
        try {
            this.loadConfig();
            this.convertVersion();
        }
        catch (Exception e) {
            Logger.error("Configuration file access error.");
        }
        finally {
            this.saveConfig();
        }
    }

    public CommonConfig() {
    }

    protected void initDefaultValues() {
        this.enableInterpolationDefault = true;
        this.enableAlphaBlendDefault = true;
        this.enablePremultipliedAlphaDefault = false;
        this.enableDoubleDefault = false;
        this.excludeIntMultipleDefault = true;
        this.fontScaleRoundingToleranceDefault = 0.5;
        this.excludeHighMagDefault = true;
        this.limitMagnificationDefault = 3.0;
        this.alternativeInterpolationDefault = false;
        this.removeScaleRestrictionDefault = true;
        this.disableSmallItalicDefault = false;
        this.enableMipmapDefault = true;
        this.mipmapLevelDefault = 4;
        this.mipmapLodBiasDefault = -3;
        this.overlayLodBiasDefault = -5;
        this.brightnessDefault = 3;
        this.autoBrightnessDefault = true;
        this.useOSFontDefault = false;
        this.fontNameDefault = "SansSerif";
        this.secondaryFontNameDefault = "SansSerif";
        this.fontAntiAliasDefault = 0;
        this.fontEmphasisDefault = 0;
        this.fontResIndexDefault = 3;
        this.fontAutoSizingDefault = true;
        this.fontSizeAdjustmentDefault = 0;
        this.fontGapDefault = 0;
        this.fontSpaceWidthDefault = 0;
        this.fontTargetToReplaceDefault = 0;
        this.fontAlignBaselineDefault = true;
        this.fontDetailListDefault = false;
        this.verticalMarginDefault = 1;
        this.horizontalMarginDefault = 1;
        this.sizeAdjustCharsDefault = "";
        this.shadowLengthDefault = 5;
        this.blurReductionDefault = 10;
        this.allowNPOTTextureDefault = false;
        this.enableAnisotropicFilterDefault = true;
        this.forceUnicodeDefault = false;
        this.saveMemoryDefault = 1;
        this.charWidthFractionToRoundUpDefault = 0.3333335;
        this.performanceModeDefault = false;
        this.runModeDefault = 0;
    }

    protected void loadConfig() {
        this.config.load();
        this.initDefaultValues();
        this.enableInterpolationProp = this.config.get("common", "enableInterpolation", this.enableInterpolationDefault, "Enable linear interpolation");
        this.enableAlphaBlendProp = this.config.get("common", "enableAlphaBlend", this.enableAlphaBlendDefault, "Enable alpha blending");
        this.enablePremultipliedAlphaProp = this.config.get("common", "enablePremultipliedAlpha", this.enablePremultipliedAlphaDefault, "Enable premultiplied alpha instead of straight alpha.");
        this.enableDoubleProp = this.config.get("common", "enableDouble", this.enableDoubleDefault, "Enable double rendering");
        this.excludeIntMultipleProp = this.config.get("common", "excludeIntMultiple", this.excludeIntMultipleDefault, "Disable interpolation for the integral multiple of default size.");
        this.fontScaleRoundingToleranceProp = this.config.get("common", "fontScaleRoundingTolerance", this.fontScaleRoundingToleranceDefault, "Tolerance (in percent) for rounding font scale to integer.(Default: 0.5)");
        this.excludeHighMagProp = this.config.get("common", "excludeHighMag", this.excludeHighMagDefault, "Disable interpolation for characters drawn with high magnification.");
        this.limitMagnificationProp = this.config.get("common", "limitMagnification", this.limitMagnificationDefault, "Disable interpolation for fonts above this magnification when excludeHighMag is enabled.(Default: 3.0)");
        this.alternativeInterpolationProp = this.config.get("common", "alternativeInterpolation", this.alternativeInterpolationDefault, "Experimental: Try interpolation for MOD original font renderer.");
        this.removeScaleRestrictionProp = this.config.get("common", "removeScaleRestriction", this.removeScaleRestrictionDefault, "Enable odd multiple GUI scale factors (x3,x5,...) when using unicode font.");
        this.disableSmallItalicProp = this.config.get("common", "disableSmallItalic", this.disableSmallItalicDefault, "Disable italic for small fonts.");
        this.enableMipmapProp = this.config.get("common", "enableMipmap", this.enableMipmapDefault, "Enable mipmap for fonts.");
        this.mipmapLevelProp = this.config.get("common", "mipmapLevel", this.mipmapLevelDefault, "Mipmap level.");
        this.mipmapLodBiasProp = this.config.get("common", "mipmapLodBias", this.mipmapLodBiasDefault, "Mipmap LOD bias.");
        this.overlayLodBiasProp = this.config.get("common", "overlayLodBias", this.overlayLodBiasDefault, "Mipmap LOD bias for overlay screen.");
        this.brightnessProp = this.config.get("common", "brightness", this.brightnessDefault, "Brightness correction level for interpolated fonts.");
        this.autoBrightnessProp = this.config.get("common", "autoBrightness", this.autoBrightnessDefault, "Automatic detection of brightness.");
        this.useOSFontProp = this.config.get("common", "useOSFont", this.useOSFontDefault, "Use the installed fonts in the operating system.");
        this.fontNameProp = this.config.get("common", "fontName", this.fontNameDefault, "Primary font name.\n(The font installed in the system or existing in the externalFontPaths folders (default:<minecraft dir>/fontfiles).)");
        this.secondaryFontNameProp = this.config.get("common", "secondaryFontName", this.secondaryFontNameDefault, "Secondary font name. It is used if the character cannot be rendered with the primary font.\n(The font installed in the system or existing in the externalFontPaths folders (default:<minecraft dir>/fontfiles).)");
        this.fontAntiAliasProp = this.config.get("common", "fontAntiAlias", this.fontAntiAliasDefault, "Enable anti-alias for OS fonts.(0:off, 1:normal, 2:high precision)");
        this.fontEmphasisProp = this.config.get("common", "fontEmphasis", this.fontEmphasisDefault, "Enable emphasis for OS fonts. (0:off, 1:Ascii only, 2:Non-Ascii, 3:All)");
        this.fontResIndexProp = this.config.get("common", "fontResolution", this.fontResIndexDefault, "OS font resolution. (0:8px, 1:10px, 2:12px, 3:16px, 4:24px, 5:32px, 6:48px, 7:64px)");
        this.fontAutoSizingProp = this.config.get("common", "fontAutoSizing", this.fontAutoSizingDefault, "Enable automatic font size detection for the font resolution.");
        this.fontSizeAdjProp = this.config.get("common", "fontSizeAdjustment", this.fontSizeAdjustmentDefault, "OS font size. (-4:-20%, ... 0:normal, ... 6:+30%)");
        this.fontGapProp = this.config.get("common", "fontGap", this.fontGapDefault, "Font gap.");
        this.fontSpaceWidthProp = this.config.get("common", "fontSpaceWidth", this.fontSpaceWidthDefault, "Space width for system fonts.\n(0:space width specified by the primary font, 1~3:custom width, 4:Minecraft default width)");
        this.fontTargetToReplaceProp = this.config.get("common", "fontTargetToReplace", this.fontTargetToReplaceDefault, "Target to replace fonts. (0:Exclude special fonts specified by mods, 1:All fonts)");
        this.fontAlignBaselineProp = this.config.get("common", "fontAlignBaseline", this.fontAlignBaselineDefault, "Align baseline among different fonts.");
        this.fontDetailListProp = this.config.get("common", "fontDetailList", this.fontDetailListDefault, "Internal state.");
        this.verticalMarginProp = this.config.get("common", "verticalMargin", this.verticalMarginDefault, "Vertical margin width.");
        this.horizontalMarginProp = this.config.get("common", "horizontalMargin", this.horizontalMarginDefault, "Horizontal margin width.");
        this.sizeAdjustCharsProp = this.config.get("common", "sizeAdjustmentChars", this.sizeAdjustCharsDefault, "The size of the font is determined so that the height and width of these characters will not protrude.");
        this.shadowLengthProp = this.config.get("common", "shadowLength", this.shadowLengthDefault, "Shadow length. (0~10)");
        this.blurReductionProp = this.config.get("common", "blurReduction", this.blurReductionDefault, "Enable a blur reduction for fonts less than or equal to the specified size.(0~16)");
        this.allowNPOTTextureProp = this.config.get("common", "allowNPOTTexture", this.allowNPOTTextureDefault, "Allow to use NPOT Texture in order to reduce resource consumption.");
        this.enableAnisotropicFilterProp = this.config.get("common", "enableAnisotropicFilter", this.enableAnisotropicFilterDefault, "Enable anisotropic filtering.");
        this.forceUnicodeProp = this.config.get("common", "forceUnicode", this.forceUnicodeDefault, "Force to use unicode font.");
        this.saveMemoryProp = this.config.get("common", "saveMemory", this.saveMemoryDefault, "To save memory and VRAM usage by adjusting some parameters when a large amount of memory or VRAM will be required.\n(0:off, 1:conservative, 2:moderate, 3:aggressive)");
        this.charWidthFractionToRoundUpProp = this.config.get("common", "charWidthFractionToRoundUp", this.charWidthFractionToRoundUpDefault, "This value is an option to adjust the rounding method of the character width that can be obtained by getCharWidth().\nThe character widths are rounded up if the fractions of the character width are equal to or more than this fraction value.\nOther character widths are rounded down. (Default: 0.3333335)");
        this.performanceModeProp = this.config.get("common", "performanceMode", this.performanceModeDefault, "Prioritize performance rather than quality.");
        this.runModeProp = this.config.get("common", "runMode", this.runModeDefault, "Select run mode. (0:Enable mod, 1:Disable mod, 2:Disable mod(Optimization only)");
        this.setValues();
    }

    private void setValues() {
        this.enableInterpolation = this.enableInterpolationProp.getBoolean();
        this.enableAlphaBlend = this.enableAlphaBlendProp.getBoolean();
        this.enablePremultipliedAlpha = this.enablePremultipliedAlphaProp.getBoolean();
        this.enableDouble = this.enableDoubleProp.getBoolean();
        this.excludeIntMultiple = this.excludeIntMultipleProp.getBoolean();
        this.fontScaleRoundingTolerance = this.fontScaleRoundingToleranceProp.getDouble();
        this.excludeHighMag = this.excludeHighMagProp.getBoolean();
        this.limitMagnification = this.limitMagnificationProp.getDouble();
        this.alternativeInterpolation = this.alternativeInterpolationProp.getBoolean();
        this.removeScaleRestriction = this.removeScaleRestrictionProp.getBoolean();
        this.disableSmallItalic = this.disableSmallItalicProp.getBoolean();
        this.enableMipmap = this.enableMipmapProp.getBoolean();
        this.mipmapLevel = this.mipmapLevelProp.getInt();
        this.mipmapLodBias = this.mipmapLodBiasProp.getInt();
        this.overlayLodBias = this.overlayLodBiasProp.getInt();
        this.brightness = this.brightnessProp.getInt();
        this.autoBrightness = this.autoBrightnessProp.getBoolean();
        this.useOSFont = this.useOSFontProp.getBoolean();
        this.fontName = this.fontNameProp.getString();
        this.secondaryFontName = this.secondaryFontNameProp.getString();
        this.fontAntiAlias = this.fontAntiAliasProp.getInt();
        this.fontEmphasis = this.fontEmphasisProp.getInt();
        this.fontResIndex = this.fontResIndexProp.getInt();
        this.fontAutoSizing = this.fontAutoSizingProp.getBoolean();
        this.fontSizeAdjustment = this.fontSizeAdjProp.getInt();
        this.fontGap = this.fontGapProp.getInt();
        this.fontSpaceWidth = this.fontSpaceWidthProp.getInt();
        this.fontTargetToReplace = this.fontTargetToReplaceProp.getInt();
        this.fontAlignBaseline = this.fontAlignBaselineProp.getBoolean();
        this.fontDetailList = this.fontDetailListProp.getBoolean();
        this.verticalMargin = this.verticalMarginProp.getInt();
        this.horizontalMargin = this.horizontalMarginProp.getInt();
        this.sizeAdjustChars = this.sizeAdjustCharsProp.getString();
        this.shadowLength = this.shadowLengthProp.getInt();
        this.blurReduction = this.blurReductionProp.getInt();
        this.allowNPOTTexture = this.allowNPOTTextureProp.getBoolean();
        this.enableAnisotropicFilter = this.enableAnisotropicFilterProp.getBoolean();
        this.forceUnicode = this.forceUnicodeProp.getBoolean();
        this.saveMemory = this.saveMemoryProp.getInt();
        this.charWidthFractionToRoundUp = this.charWidthFractionToRoundUpProp.getDouble();
        this.performanceMode = this.performanceModeProp.getBoolean();
        this.runMode = this.runModeProp.getInt();
        this.updateCalculatedValues();
    }

    public void updateCalculatedValues() {
        this.fontScaleRoundingToleranceRate = (float)this.fontScaleRoundingTolerance * 0.01f;
        this.charWidthFractionToRoundUpFloat = (float)this.charWidthFractionToRoundUp;
        this.mipmapLodBiasFloat = (float)this.mipmapLodBias / 10.0f;
        this.overlayLodBiasFloat = (float)this.overlayLodBias / 10.0f;
    }

    protected void saveConfig() {
        this.enableInterpolationProp.setValue(this.enableInterpolation);
        this.enableAlphaBlendProp.setValue(this.enableAlphaBlend);
        this.enablePremultipliedAlphaProp.setValue(this.enablePremultipliedAlpha);
        this.enableDoubleProp.setValue(this.enableDouble);
        this.excludeIntMultipleProp.setValue(this.excludeIntMultiple);
        this.fontScaleRoundingToleranceProp.setValue(this.fontScaleRoundingTolerance);
        this.excludeHighMagProp.setValue(this.excludeHighMag);
        this.limitMagnificationProp.setValue(this.limitMagnification);
        this.alternativeInterpolationProp.setValue(this.alternativeInterpolation);
        this.removeScaleRestrictionProp.setValue(this.removeScaleRestriction);
        this.disableSmallItalicProp.setValue(this.disableSmallItalic);
        this.enableMipmapProp.setValue(this.enableMipmap);
        this.mipmapLevelProp.setValue(this.mipmapLevel);
        this.mipmapLodBiasProp.setValue(this.mipmapLodBias);
        this.overlayLodBiasProp.setValue(this.overlayLodBias);
        this.brightnessProp.setValue(this.brightness);
        this.autoBrightnessProp.setValue(this.autoBrightness);
        this.useOSFontProp.setValue(this.useOSFont);
        this.fontNameProp.setValue(this.fontName);
        this.secondaryFontNameProp.setValue(this.secondaryFontName);
        this.fontAntiAliasProp.setValue(this.fontAntiAlias);
        this.fontEmphasisProp.setValue(this.fontEmphasis);
        this.fontResIndexProp.setValue(this.fontResIndex);
        this.fontAutoSizingProp.setValue(this.fontAutoSizing);
        this.fontSizeAdjProp.setValue(this.fontSizeAdjustment);
        this.fontGapProp.setValue(this.fontGap);
        this.fontSpaceWidthProp.setValue(this.fontSpaceWidth);
        this.fontTargetToReplaceProp.setValue(this.fontTargetToReplace);
        this.fontAlignBaselineProp.setValue(this.fontAlignBaseline);
        this.fontDetailListProp.setValue(this.fontDetailList);
        this.verticalMarginProp.setValue(this.verticalMargin);
        this.horizontalMarginProp.setValue(this.horizontalMargin);
        this.sizeAdjustCharsProp.setValue(this.sizeAdjustChars);
        this.shadowLengthProp.setValue(this.shadowLength);
        this.blurReductionProp.setValue(this.blurReduction);
        this.allowNPOTTextureProp.setValue(this.allowNPOTTexture);
        this.enableAnisotropicFilterProp.setValue(this.enableAnisotropicFilter);
        this.forceUnicodeProp.setValue(this.forceUnicode);
        this.saveMemoryProp.setValue(this.saveMemory);
        this.charWidthFractionToRoundUpProp.setValue(this.charWidthFractionToRoundUp);
        this.performanceModeProp.setValue(this.performanceMode);
        this.runModeProp.setValue(this.runMode);
        this.config.save();
    }

    protected void resetConfig() {
        this.enableInterpolationProp.setToDefault();
        this.enableAlphaBlendProp.setToDefault();
        this.excludeIntMultipleProp.setToDefault();
        this.excludeHighMagProp.setToDefault();
        this.limitMagnificationProp.setToDefault();
        this.alternativeInterpolationProp.setToDefault();
        this.removeScaleRestrictionProp.setToDefault();
        this.enableMipmapProp.setToDefault();
        this.mipmapLodBiasProp.setToDefault();
        this.overlayLodBiasProp.setToDefault();
        this.brightnessProp.setToDefault();
        this.autoBrightnessProp.setToDefault();
        this.useOSFontProp.setToDefault();
        this.fontNameProp.setToDefault();
        this.secondaryFontNameProp.setToDefault();
        this.fontAntiAliasProp.setToDefault();
        this.fontEmphasisProp.setToDefault();
        this.fontResIndexProp.setToDefault();
        this.fontAutoSizingProp.setToDefault();
        this.fontSizeAdjProp.setToDefault();
        this.fontGapProp.setToDefault();
        this.fontSpaceWidthProp.setToDefault();
        this.fontTargetToReplaceProp.setToDefault();
        this.fontAlignBaselineProp.setToDefault();
        this.fontDetailListProp.setToDefault();
        this.sizeAdjustCharsProp.setToDefault();
        this.shadowLengthProp.setToDefault();
        this.forceUnicodeProp.setToDefault();
        this.blurReductionProp.setToDefault();
        this.allowNPOTTextureProp.setToDefault();
        this.enableAnisotropicFilterProp.setToDefault();
        this.performanceModeProp.setToDefault();
        this.runModeProp.setToDefault();
        this.setValues();
        this.config.save();
    }

    protected void convertVersion() {
        if (this.getLoadedConfigVersionInt() <= 2 && this.saveMemory == 2) {
            this.saveMemory = 1;
        }
        if (this.getLoadedConfigVersionInt() <= 4 && this.fontGap != this.fontGapDefault) {
            this.fontGap += 2;
        }
    }

    protected void removeKey(String category, String key) {
        if (this.config.hasKey(category, key)) {
            this.config.moveProperty(category, key, "work");
            this.config.removeCategory(this.config.getCategory("work"));
        }
    }

    protected void takeoverOldConfigValues() {
        this.enableInterpolation = OldConfig.enableInterpolation;
        this.enableAlphaBlend = OldConfig.enableAlphaBlend;
        this.enablePremultipliedAlpha = OldConfig.enablePremultipliedAlpha;
        this.enableDouble = OldConfig.enableDouble;
        this.excludeIntMultiple = OldConfig.excludeIntMultiple;
        this.fontScaleRoundingTolerance = OldConfig.fontScaleRoundingTolerance;
        this.excludeHighMag = OldConfig.excludeHighMag;
        this.limitMagnification = OldConfig.limitMagnification;
        this.alternativeInterpolation = OldConfig.alternativeInterpolation;
        this.removeScaleRestriction = OldConfig.removeScaleRestriction;
        this.disableSmallItalic = OldConfig.disableSmallItalic;
        this.enableMipmap = OldConfig.enableMipmap;
        this.mipmapLevel = OldConfig.mipmapLevel;
        this.mipmapLodBias = OldConfig.mipmapLodBias;
        this.overlayLodBias = OldConfig.overlayLodBias;
        this.brightness = OldConfig.brightness;
        this.autoBrightness = OldConfig.autoBrightness;
        this.useOSFont = OldConfig.useOSFont;
        this.fontName = OldConfig.fontName;
        this.secondaryFontName = OldConfig.secondaryFontName;
        this.fontAntiAlias = OldConfig.fontAntiAlias;
        this.fontEmphasis = OldConfig.fontEmphasis;
        this.fontResIndex = OldConfig.fontResIndex;
        this.fontAutoSizing = OldConfig.fontAutoSizing;
        this.fontSizeAdjustment = OldConfig.fontSizeAdjustment;
        this.fontGap = OldConfig.fontGap;
        this.fontAlignBaseline = OldConfig.fontAlignBaseline;
        this.fontDetailList = OldConfig.fontDetailList;
        this.verticalMargin = OldConfig.verticalMargin;
        this.horizontalMargin = OldConfig.horizontalMargin;
        this.sizeAdjustChars = OldConfig.sizeAdjustChars;
        this.shadowLength = OldConfig.shadowLength;
        this.blurReduction = OldConfig.blurReduction;
        this.allowNPOTTexture = OldConfig.allowNPOTTexture;
        this.enableAnisotropicFilter = OldConfig.enableAnisotropicFilter;
        this.forceUnicode = OldConfig.forceUnicode;
        this.updateCalculatedValues();
    }

    public static void saveCurrentConfig() {
        if (CommonConfig.isPlayerConfig()) {
            playerConfig.saveConfig();
        }
        globalConfig.saveConfig();
    }

    public static boolean isPlayerConfig() {
        return CommonConfig.globalConfig.enablePerPlayerConfig && playerConfig != null && CommonConfig.playerConfig.usePlayerConfig;
    }

    public static void resetCurrentConfig() {
        if (CommonConfig.isPlayerConfig()) {
            playerConfig.resetConfig();
        } else {
            globalConfig.resetConfig();
        }
    }

    public static void toggleConfig() {
        if (!CommonConfig.globalConfig.enablePerPlayerConfig) {
            return;
        }
        if (playerConfig == null) {
            PlayerConfig.readPlayerConfig();
        }
        if (playerConfig != null) {
            CommonConfig.playerConfig.usePlayerConfig = !CommonConfig.playerConfig.usePlayerConfig;
            currentConfig = CommonConfig.isPlayerConfig() ? playerConfig : globalConfig;
            playerConfig.saveConfig();
        }
    }

    public int getLoadedConfigVersionInt() {
        if (this.config.getLoadedConfigVersion() == null) {
            return 0;
        }
        return Integer.parseInt(this.config.getLoadedConfigVersion());
    }
}

