/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.tileentity;

import com.timwoodcreates.roost.data.DataChicken;
import java.text.DecimalFormat;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileEntityChickenContainer
extends TileEntity
implements ISidedInventory,
ITickable {
    private static final DecimalFormat FORMATTER = new DecimalFormat("0.0%");
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    private boolean mightNeedToUpdateChickenInfo = true;
    private boolean skipNextTimerReset = false;
    private int timeUntilNextDrop = 0;
    private int timeElapsed = 0;
    private int progress = 0;
    private DataChicken[] chickenData = new DataChicken[this.getSizeChickenInventory()];
    private boolean fullOfChickens = false;
    private boolean fullOfSeeds = false;
    private IItemHandler itemHandler;

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateChickenInfoIfNeeded();
            this.updateTimerIfNeeded();
            this.spawnChickenDropIfNeeded();
            this.updateProgress();
            this.skipNextTimerReset = false;
        }
    }

    public void willNeedToUpdateChickenInfo() {
        this.mightNeedToUpdateChickenInfo = true;
    }

    private void updateChickenInfoIfNeeded() {
        if (!this.mightNeedToUpdateChickenInfo) {
            return;
        }
        if (this.fullOfChickens != this.isFullOfChickens()) {
            this.fullOfChickens = !this.fullOfChickens;
            this.notifyBlockUpdate();
        }
        if (this.fullOfSeeds != this.isFullOfSeeds()) {
            this.fullOfSeeds = !this.fullOfSeeds;
            this.notifyBlockUpdate();
        }
        this.mightNeedToUpdateChickenInfo = false;
    }

    private void updateChickenInfoIfNeededForSlot(int slot) {
        boolean wasChanged;
        DataChicken oldChicken = this.chickenData[slot];
        DataChicken newChicken = this.createChickenData(slot);
        boolean wasCreated = oldChicken == null && newChicken != null;
        boolean wasDeleted = oldChicken != null && newChicken == null;
        boolean bl = wasChanged = oldChicken != null && newChicken != null && !oldChicken.isEqual(newChicken);
        if (wasCreated || wasChanged || wasDeleted) {
            this.chickenData[slot] = newChicken;
            if (!this.skipNextTimerReset) {
                this.resetTimer();
            }
        }
    }

    protected DataChicken getChickenData(int slot) {
        if (slot >= this.chickenData.length || slot < 0) {
            return null;
        }
        return this.chickenData[slot];
    }

    protected DataChicken createChickenData(int slot) {
        return DataChicken.getDataFromStack(this.func_70301_a(slot));
    }

    private void updateTimerIfNeeded() {
        if (this.fullOfChickens && this.fullOfSeeds && !this.outputIsFull()) {
            this.timeElapsed += this.getTimeElapsed();
            this.func_70296_d();
        }
    }

    private void updateProgress() {
        this.progress = this.timeUntilNextDrop == 0 ? 0 : this.timeElapsed * 1000 / this.timeUntilNextDrop;
    }

    private int getTimeElapsed() {
        int time = Integer.MAX_VALUE;
        for (int i = 0; i < this.chickenData.length; ++i) {
            if (this.chickenData[i] == null) {
                return 0;
            }
            time = Math.min(time, this.chickenData[i].getAddedTime(this.func_70301_a(i)));
        }
        return time;
    }

    public double getProgress() {
        return (double)this.progress / 1000.0;
    }

    public String getFormattedProgress() {
        return this.formatProgress(this.getProgress());
    }

    public String formatProgress(double progress) {
        return FORMATTER.format(progress);
    }

    private void spawnChickenDropIfNeeded() {
        if (this.fullOfChickens && this.fullOfSeeds && this.timeElapsed >= this.timeUntilNextDrop) {
            if (this.timeUntilNextDrop > 0) {
                this.func_70298_a(this.getSizeChickenInventory(), this.requiredSeedsForDrop());
                this.spawnChickenDrop();
            }
            this.resetTimer();
        }
    }

    private void resetTimer() {
        this.timeElapsed = 0;
        this.timeUntilNextDrop = 0;
        for (int i = 0; i < this.chickenData.length; ++i) {
            if (this.chickenData[i] == null) continue;
            this.timeUntilNextDrop = Math.max(this.timeUntilNextDrop, this.chickenData[i].getLayTime());
            this.timeUntilNextDrop = (int)((double)this.timeUntilNextDrop / this.speedMultiplier());
        }
        this.func_70296_d();
    }

    protected abstract void spawnChickenDrop();

    protected abstract int getSizeChickenInventory();

    protected abstract int requiredSeedsForDrop();

    protected abstract double speedMultiplier();

    public boolean isFullOfChickens() {
        for (int i = 0; i < this.chickenData.length; ++i) {
            this.updateChickenInfoIfNeededForSlot(i);
            if (this.chickenData[i] != null) continue;
            return false;
        }
        return true;
    }

    public boolean isFullOfSeeds() {
        int needed = this.requiredSeedsForDrop();
        if (needed == 0) {
            return true;
        }
        ItemStack stack = this.func_70301_a(this.getSizeChickenInventory());
        return stack.func_190916_E() >= needed;
    }

    private boolean outputIsFull() {
        int max = this.func_70302_i_();
        for (int i = this.getOutputStackIndex(); i < max; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190916_E() >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private int getOutputStackIndex() {
        if (this.requiredSeedsForDrop() > 0) {
            return this.getSizeChickenInventory() + 1;
        }
        return this.getSizeChickenInventory();
    }

    protected ItemStack putStackInOutput(ItemStack stack) {
        int max = this.func_70302_i_();
        for (int i = this.getOutputStackIndex(); i < max && !stack.func_190926_b(); ++i) {
            stack = this.insertStack(stack, i);
        }
        this.func_70296_d();
        return stack;
    }

    private ItemStack insertStack(ItemStack stack, int index) {
        int max = Math.min(stack.func_77976_d(), this.func_70297_j_());
        ItemStack outputStack = this.func_70301_a(index);
        if (outputStack.func_190926_b()) {
            if (stack.func_190916_E() >= max) {
                this.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
            } else {
                this.func_70299_a(index, stack.func_77979_a(max));
            }
        } else if (this.canCombine(outputStack, stack) && outputStack.func_190916_E() < max) {
            int itemsToMove = Math.min(stack.func_190916_E(), max - outputStack.func_190916_E());
            stack.func_190918_g(itemsToMove);
            outputStack.func_190917_f(itemsToMove);
        }
        return stack;
    }

    private boolean canCombine(ItemStack a, ItemStack b) {
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        if (a.func_190916_E() > a.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public int func_70302_i_() {
        return 5;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public boolean func_191420_l() {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index < this.getOutputStackIndex()) {
            this.willNeedToUpdateChickenInfo();
        }
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        if (index < this.getOutputStackIndex()) {
            this.willNeedToUpdateChickenInfo();
        }
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index < this.getOutputStackIndex()) {
            this.willNeedToUpdateChickenInfo();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= this.getOutputStackIndex();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index < this.getSizeChickenInventory()) {
            return DataChicken.isChicken(stack);
        }
        if (index < this.getOutputStackIndex()) {
            return TileEntityChickenContainer.isSeed(stack);
        }
        return false;
    }

    public static boolean isSeed(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151014_N || item == Items.field_151081_bc || item == Items.field_151080_bb || item == Items.field_185163_cU;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public int[] func_180463_a(EnumFacing side) {
        int count = this.func_70302_i_();
        int[] itemSlots = new int[count];
        for (int i = 0; i < count; ++i) {
            itemSlots[i] = i;
        }
        return itemSlots;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.notifyBlockUpdate();
    }

    private void notifyBlockUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 2);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.func_174888_l();
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.timeUntilNextDrop = compound.func_74762_e("TimeUntilNextChild");
        this.timeElapsed = compound.func_74762_e("TimeElapsed");
        this.skipNextTimerReset = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        compound.func_74768_a("TimeUntilNextChild", this.timeUntilNextDrop);
        compound.func_74768_a("TimeElapsed", this.timeElapsed);
        return compound;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemHandler == null) {
                this.itemHandler = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
            }
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

