/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.sync.packets;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.util.math.BlockPos;
import p455w0rd.wct.init.ModGuiHandler;
import p455w0rd.wct.sync.WCTPacket;
import p455w0rd.wct.sync.network.INetworkInfo;

public class PacketOpenGui
extends WCTPacket {
    private final int whichGui;
    private final int slot;
    private final boolean isBauble;

    public PacketOpenGui(ByteBuf stream) {
        this.whichGui = stream.readInt();
        this.slot = stream.readInt();
        this.isBauble = stream.readBoolean();
    }

    public PacketOpenGui(int gui, int slot, boolean isBauble) {
        this.whichGui = gui;
        this.slot = slot;
        this.isBauble = isBauble;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(gui);
        data.writeInt(slot);
        data.writeBoolean(isBauble);
        this.configureWrite(data);
        ModGuiHandler.setIsBauble(isBauble);
        ModGuiHandler.setSlot(slot);
    }

    public PacketOpenGui(int gui) {
        this(gui, -1, false);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerPlayer && this.slot >= 0) {
            ModGuiHandler.open(this.whichGui, player, player.func_130014_f_(), new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v), false, this.isBauble, this.slot);
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, WCTPacket packet, EntityPlayer player) {
    }
}

