/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.tools;

import com.direwolf20.buildinggadgets.ModItems;
import com.direwolf20.buildinggadgets.items.ConstructionPaste;
import com.direwolf20.buildinggadgets.items.CopyPasteTool;
import com.direwolf20.buildinggadgets.items.GenericPasteContainer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDoubleWoodSlab;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class InventoryManipulation {
    private static final Set<IProperty> safeProperties = Stream.of(BlockSlab.field_176554_a, BlockStairs.field_176308_b, BlockLog.field_176299_a, BlockDirectional.field_176387_N, BlockStairs.field_176309_a, BlockTrapDoor.field_176285_M, BlockTorch.field_176596_a, BlockStairs.field_176310_M, BlockLever.field_176360_a, BlockLever.field_176359_b, BlockRedstoneRepeater.field_176410_b).collect(Collectors.toSet());
    private static final Set<IProperty> safePropertiesCopyPaste = Stream.of(BlockSlab.field_176554_a, BlockStairs.field_176308_b, BlockLog.field_176299_a, BlockDirectional.field_176387_N, BlockStairs.field_176309_a, BlockTrapDoor.field_176285_M, BlockTorch.field_176596_a, BlockStairs.field_176310_M, BlockRail.field_176565_b, BlockRailPowered.field_176568_b, BlockLever.field_176360_a, BlockLever.field_176359_b, BlockRedstoneRepeater.field_176410_b, BlockDoubleWoodSlab.field_176557_b).collect(Collectors.toSet());

    public static boolean giveItem(ItemStack itemStack, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (itemStack.func_77973_b() instanceof ConstructionPaste) {
            itemStack = InventoryManipulation.addPasteToContainer(player, itemStack);
        }
        if (itemStack.func_190916_E() == 0) {
            return true;
        }
        InventoryPlayer inv = player.field_71071_by;
        List<IItemHandler> invContainers = InventoryManipulation.findInvContainers(inv);
        if (invContainers.size() > 0) {
            for (IItemHandler container : invContainers) {
                for (int i = 0; i < container.getSlots(); ++i) {
                    ItemStack containerItem = container.getStackInSlot(i);
                    ItemStack giveItemStack = itemStack.func_77946_l();
                    if (containerItem.func_77973_b() != giveItemStack.func_77973_b() || containerItem.func_77960_j() != giveItemStack.func_77960_j() || !(giveItemStack = container.insertItem(i, giveItemStack, false)).func_190926_b()) continue;
                    return true;
                }
            }
        }
        ItemStack giveItemStack = itemStack.func_77946_l();
        boolean success = inv.func_70441_a(giveItemStack);
        return success;
    }

    public static boolean useItem(ItemStack itemStack, EntityPlayer player, int count) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItem(itemStack.func_77973_b(), itemStack.func_77960_j(), inv);
        List<IItemHandler> invContainers = InventoryManipulation.findInvContainers(inv);
        if (invContainers.size() > 0) {
            for (IItemHandler container : invContainers) {
                for (int i = 0; i < container.getSlots(); ++i) {
                    ItemStack containerItem = container.getStackInSlot(i);
                    if (containerItem.func_77973_b() != itemStack.func_77973_b() || containerItem.func_77960_j() != itemStack.func_77960_j() || containerItem.func_190916_E() < count) continue;
                    container.extractItem(i, count, false);
                    return true;
                }
            }
        }
        if (slots.size() == 0) {
            return false;
        }
        int slot = slots.get(0);
        ItemStack stackInSlot = inv.func_70301_a(slot);
        if (stackInSlot.func_190916_E() < count) {
            return false;
        }
        stackInSlot.func_190918_g(count);
        return true;
    }

    public static int countItem(ItemStack itemStack, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return 10000;
        }
        int count = 0;
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItem(itemStack.func_77973_b(), itemStack.func_77960_j(), inv);
        List<IItemHandler> invContainers = InventoryManipulation.findInvContainers(inv);
        if (slots.size() == 0 && invContainers.size() == 0) {
            return 0;
        }
        if (invContainers.size() > 0) {
            for (IItemHandler container : invContainers) {
                count += InventoryManipulation.countInContainer(container, itemStack.func_77973_b(), itemStack.func_77960_j());
            }
        }
        Iterator<Object> iterator = slots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack stackInSlot = inv.func_70301_a(slot);
            count += stackInSlot.func_190916_E();
        }
        return count;
    }

    public static int countPaste(EntityPlayer player) {
        List<Integer> containerSlots;
        if (player.field_71075_bZ.field_75098_d) {
            return 10000;
        }
        int count = 0;
        ConstructionPaste item = ModItems.constructionPaste;
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItem(item, 0, inv);
        if (slots.size() > 0) {
            for (int slot : slots) {
                ItemStack stackInSlot = inv.func_70301_a(slot);
                count += stackInSlot.func_190916_E();
            }
        }
        if ((containerSlots = InventoryManipulation.findItemClass(GenericPasteContainer.class, inv)).size() > 0) {
            for (int slot : containerSlots) {
                ItemStack stackInSlot = inv.func_70301_a(slot);
                if (!(stackInSlot.func_77973_b() instanceof GenericPasteContainer)) continue;
                count += GenericPasteContainer.getPasteAmount(stackInSlot);
            }
        }
        return count;
    }

    public static ItemStack addPasteToContainer(EntityPlayer player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ConstructionPaste)) {
            return itemStack;
        }
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItemClass(GenericPasteContainer.class, inv);
        if (slots.size() == 0) {
            return itemStack;
        }
        HashMap<Integer, Integer> slotMap = new HashMap<Integer, Integer>();
        for (int slot : slots) {
            slotMap.put(slot, GenericPasteContainer.getPasteAmount(inv.func_70301_a(slot)));
        }
        ArrayList list = new ArrayList(slotMap.entrySet());
        Comparator<Map.Entry> comparator = Comparator.comparing(entry -> (Integer)entry.getValue());
        comparator = comparator.reversed();
        list.sort(comparator);
        for (Map.Entry entry2 : list) {
            ItemStack containerStack = inv.func_70301_a(((Integer)entry2.getKey()).intValue());
            int maxAmount = ((GenericPasteContainer)containerStack.func_77973_b()).getMaxAmount();
            int pasteInContainer = GenericPasteContainer.getPasteAmount(containerStack);
            int freeSpace = maxAmount - pasteInContainer;
            int stackSize = itemStack.func_190916_E();
            int remainingPaste = stackSize - freeSpace;
            if (remainingPaste < 0) {
                remainingPaste = 0;
            }
            int usedPaste = Math.abs(stackSize - remainingPaste);
            itemStack.func_190920_e(remainingPaste);
            GenericPasteContainer.setPasteAmount(containerStack, pasteInContainer + usedPaste);
        }
        return itemStack;
    }

    public static boolean usePaste(EntityPlayer player, int count) {
        List<Integer> containerSlots;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItem(ModItems.constructionPaste, 0, inv);
        if (slots.size() > 0) {
            for (int slot : slots) {
                ItemStack pasteStack = inv.func_70301_a(slot);
                if (pasteStack.func_190916_E() < count) continue;
                pasteStack.func_190918_g(count);
                return true;
            }
        }
        if ((containerSlots = InventoryManipulation.findItemClass(GenericPasteContainer.class, inv)).size() > 0) {
            for (int slot : containerSlots) {
                int pasteAmt;
                ItemStack containerStack = inv.func_70301_a(slot);
                if (!(containerStack.func_77973_b() instanceof GenericPasteContainer) || (pasteAmt = GenericPasteContainer.getPasteAmount(containerStack)) < count) continue;
                GenericPasteContainer.setPasteAmount(containerStack, pasteAmt - count);
                return true;
            }
        }
        return false;
    }

    private static List<IItemHandler> findInvContainers(InventoryPlayer inv) {
        ArrayList<IItemHandler> containers = new ArrayList<IItemHandler>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
            containers.add((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        return containers;
    }

    private static int countInContainer(IItemHandler container, Item item, int meta) {
        int count = 0;
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack tempItem = container.getStackInSlot(i);
            if (tempItem.func_77973_b() != item || tempItem.func_77960_j() != meta) continue;
            count += tempItem.func_190916_E();
        }
        return count;
    }

    private static List<Integer> findItem(Item item, int meta, InventoryPlayer inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || meta != stack.func_77960_j()) continue;
            slots.add(i);
        }
        return slots;
    }

    public static List<Integer> findItemClass(Class c, InventoryPlayer inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !c.isInstance(stack.func_77973_b())) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack getSilkTouchDrop(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        int i = 0;
        if (item.func_77614_k()) {
            i = state.func_177230_c().func_180651_a(state);
        }
        return new ItemStack(item, 1, i);
    }

    public static IBlockState getSpecificStates(IBlockState originalState, World world, EntityPlayer player, BlockPos pos, ItemStack tool) {
        IBlockState placeState = Blocks.field_150350_a.func_176223_P();
        Block block = originalState.func_177230_c();
        ItemStack item = block.getPickBlock(originalState, null, world, pos, player);
        int meta = item.func_77960_j();
        try {
            placeState = originalState.func_177230_c().getStateForPlacement(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, meta, (EntityLivingBase)player, EnumHand.MAIN_HAND);
        }
        catch (Exception var8) {
            placeState = originalState.func_177230_c().func_176223_P();
        }
        for (IProperty prop : placeState.func_177227_a()) {
            if (tool.func_77973_b() instanceof CopyPasteTool) {
                if (!safePropertiesCopyPaste.contains(prop)) continue;
                placeState = placeState.func_177226_a(prop, originalState.func_177229_b(prop));
                continue;
            }
            if (!safeProperties.contains(prop)) continue;
            placeState = placeState.func_177226_a(prop, originalState.func_177229_b(prop));
        }
        return placeState;
    }
}

