/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.tools;

import com.direwolf20.buildinggadgets.Config;
import com.direwolf20.buildinggadgets.items.BuildingTool;
import com.direwolf20.buildinggadgets.tools.BlockMap;
import com.direwolf20.buildinggadgets.tools.GadgetUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BuildingModes {
    private static boolean isReplaceable(World world, BlockPos pos, IBlockState setBlock) {
        if (!setBlock.func_177230_c().func_176196_c(world, pos)) {
            return false;
        }
        if (pos.func_177956_o() < 0) {
            return false;
        }
        return !(Config.canOverwriteBlocks ? !world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) : world.func_180495_p(pos).func_185904_a() != Material.field_151579_a);
    }

    public static List<BlockPos> getBuildOrders(World world, EntityPlayer player, BlockPos startBlock, EnumFacing sideHit, ItemStack tool) {
        ArrayList<BlockPos> coordinates;
        block61: {
            BlockPos pos;
            int range;
            IBlockState setBlock;
            BuildingTool.ToolMode mode;
            block73: {
                block76: {
                    block75: {
                        block74: {
                            EnumFacing playerFacing;
                            block72: {
                                int bound;
                                block68: {
                                    block71: {
                                        block70: {
                                            block69: {
                                                block67: {
                                                    block66: {
                                                        int boundZ;
                                                        int boundX;
                                                        block59: {
                                                            BlockPos playerPos;
                                                            block65: {
                                                                block64: {
                                                                    block63: {
                                                                        block62: {
                                                                            block60: {
                                                                                mode = BuildingTool.getToolMode(tool);
                                                                                setBlock = GadgetUtils.getToolBlock(tool);
                                                                                range = GadgetUtils.getToolRange(tool);
                                                                                coordinates = new ArrayList<BlockPos>();
                                                                                playerPos = new BlockPos(Math.floor(player.field_70165_t), Math.floor(player.field_70163_u), Math.floor(player.field_70161_v));
                                                                                pos = startBlock;
                                                                                bound = (range - 1) / 2;
                                                                                playerFacing = player.func_174811_aO();
                                                                                if (playerFacing == EnumFacing.SOUTH || playerFacing == EnumFacing.NORTH) {
                                                                                    boundX = bound;
                                                                                    boundZ = 0;
                                                                                } else {
                                                                                    boundX = 0;
                                                                                    boundZ = bound;
                                                                                }
                                                                                if (mode != BuildingTool.ToolMode.BuildToMe) break block59;
                                                                                if (sideHit != EnumFacing.SOUTH) break block60;
                                                                                for (int i = startBlock.func_177952_p() + 1; i <= playerPos.func_177952_p() - 1; ++i) {
                                                                                    pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o(), i);
                                                                                    if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                                    coordinates.add(pos);
                                                                                }
                                                                                break block61;
                                                                            }
                                                                            if (sideHit != EnumFacing.NORTH) break block62;
                                                                            for (int i = startBlock.func_177952_p() - 1; i >= playerPos.func_177952_p() + 1; --i) {
                                                                                pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o(), i);
                                                                                if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                                coordinates.add(pos);
                                                                            }
                                                                            break block61;
                                                                        }
                                                                        if (sideHit != EnumFacing.EAST) break block63;
                                                                        for (int i = startBlock.func_177958_n() + 1; i <= playerPos.func_177958_n() - 1; ++i) {
                                                                            pos = new BlockPos(i, startBlock.func_177956_o(), startBlock.func_177952_p());
                                                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                            coordinates.add(pos);
                                                                        }
                                                                        break block61;
                                                                    }
                                                                    if (sideHit != EnumFacing.WEST) break block64;
                                                                    for (int i = startBlock.func_177958_n() - 1; i >= playerPos.func_177958_n() + 1; --i) {
                                                                        pos = new BlockPos(i, startBlock.func_177956_o(), startBlock.func_177952_p());
                                                                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                        coordinates.add(pos);
                                                                    }
                                                                    break block61;
                                                                }
                                                                if (sideHit != EnumFacing.UP) break block65;
                                                                for (int i = startBlock.func_177956_o() + 1; i <= playerPos.func_177956_o() - 1; ++i) {
                                                                    pos = new BlockPos(startBlock.func_177958_n(), i, startBlock.func_177952_p());
                                                                    if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                    coordinates.add(pos);
                                                                }
                                                                break block61;
                                                            }
                                                            if (sideHit != EnumFacing.DOWN) break block61;
                                                            for (int i = startBlock.func_177956_o() - 1; i >= playerPos.func_177956_o() + 1; --i) {
                                                                pos = new BlockPos(startBlock.func_177958_n(), i, startBlock.func_177952_p());
                                                                if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                coordinates.add(pos);
                                                            }
                                                            break block61;
                                                        }
                                                        if (mode != BuildingTool.ToolMode.VerticalWall) break block66;
                                                        if (sideHit == EnumFacing.UP) {
                                                            for (int y = 1; y <= range; ++y) {
                                                                for (int x = boundX * -1; x <= boundX; ++x) {
                                                                    for (int z = boundZ * -1; z <= boundZ; ++z) {
                                                                        pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() + y, startBlock.func_177952_p() + z);
                                                                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                        coordinates.add(pos);
                                                                    }
                                                                }
                                                            }
                                                        } else if (sideHit == EnumFacing.DOWN) {
                                                            for (int y = 1; y <= range; ++y) {
                                                                for (int x = boundX * -1; x <= boundX; ++x) {
                                                                    for (int z = boundZ * -1; z <= boundZ; ++z) {
                                                                        pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() - y, startBlock.func_177952_p() + z);
                                                                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                        coordinates.add(pos);
                                                                    }
                                                                }
                                                            }
                                                        } else {
                                                            for (int y = bound; y >= bound * -1; --y) {
                                                                for (int x = boundX * -1; x <= boundX; ++x) {
                                                                    for (int z = boundZ * -1; z <= boundZ; ++z) {
                                                                        pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() - y, startBlock.func_177952_p() + z);
                                                                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                        coordinates.add(pos);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        break block61;
                                                    }
                                                    if (mode != BuildingTool.ToolMode.VerticalColumn) break block67;
                                                    if (sideHit == EnumFacing.UP) {
                                                        for (int y = 1; y <= range; ++y) {
                                                            pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() + y, startBlock.func_177952_p());
                                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                            coordinates.add(pos);
                                                        }
                                                    } else if (sideHit == EnumFacing.DOWN) {
                                                        for (int y = 1; y <= range; ++y) {
                                                            pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() - y, startBlock.func_177952_p());
                                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                            coordinates.add(pos);
                                                        }
                                                    } else {
                                                        for (int y = bound * -1; y <= bound; ++y) {
                                                            pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() - y, startBlock.func_177952_p());
                                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                            coordinates.add(pos);
                                                        }
                                                    }
                                                    break block61;
                                                }
                                                if (mode != BuildingTool.ToolMode.HorizontalColumn) break block68;
                                                if (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN) {
                                                    sideHit = playerFacing.func_176734_d();
                                                }
                                                if (sideHit != EnumFacing.NORTH) break block69;
                                                for (int z = 1; z <= range; ++z) {
                                                    pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                                    if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                    coordinates.add(pos);
                                                }
                                                break block61;
                                            }
                                            if (sideHit != EnumFacing.SOUTH) break block70;
                                            for (int z = 1; z <= range; ++z) {
                                                pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o(), startBlock.func_177952_p() - z);
                                                if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                coordinates.add(pos);
                                            }
                                            break block61;
                                        }
                                        if (sideHit != EnumFacing.EAST) break block71;
                                        for (int x = 1; x <= range; ++x) {
                                            pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p());
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                        break block61;
                                    }
                                    if (sideHit != EnumFacing.WEST) break block61;
                                    for (int x = 1; x <= range; ++x) {
                                        pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p());
                                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                        coordinates.add(pos);
                                    }
                                    break block61;
                                }
                                if (mode != BuildingTool.ToolMode.HorizontalWall) break block72;
                                if (sideHit == EnumFacing.NORTH) {
                                    for (int z = 1; z <= range; ++z) {
                                        for (int x = bound * -1; x <= bound; ++x) {
                                            pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p() - z);
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                } else if (sideHit == EnumFacing.SOUTH) {
                                    for (int z = 1; z <= range; ++z) {
                                        for (int x = bound * -1; x <= bound; ++x) {
                                            pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                } else if (sideHit == EnumFacing.EAST) {
                                    for (int x = 1; x <= range; ++x) {
                                        for (int z = bound * -1; z <= bound; ++z) {
                                            pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                } else if (sideHit == EnumFacing.WEST) {
                                    for (int x = 1; x <= range; ++x) {
                                        for (int z = bound * -1; z <= bound; ++z) {
                                            pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                } else {
                                    for (int x = bound * -1; x <= bound; ++x) {
                                        for (int z = bound * -1; z <= bound; ++z) {
                                            pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                }
                                break block61;
                            }
                            if (mode != BuildingTool.ToolMode.Stairs) break block73;
                            if (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN) {
                                sideHit = playerFacing.func_176734_d();
                            }
                            if (sideHit != EnumFacing.NORTH) break block74;
                            for (int z = 1; z <= range; ++z) {
                                pos = (double)startBlock.func_177956_o() > player.field_70163_u + 1.0 ? new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() - z, startBlock.func_177952_p() - z) : ((double)startBlock.func_177956_o() < player.field_70163_u - 2.0 ? new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() + z, startBlock.func_177952_p() - z + 1) : new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() + z, startBlock.func_177952_p() + z - 1));
                                if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                coordinates.add(pos);
                            }
                            break block61;
                        }
                        if (sideHit != EnumFacing.SOUTH) break block75;
                        for (int z = 1; z <= range; ++z) {
                            pos = (double)startBlock.func_177956_o() > player.field_70163_u + 1.0 ? new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() - z, startBlock.func_177952_p() + z) : ((double)startBlock.func_177956_o() < player.field_70163_u - 2.0 ? new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() + z, startBlock.func_177952_p() + z - 1) : new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() + z, startBlock.func_177952_p() - z + 1));
                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                            coordinates.add(pos);
                        }
                        break block61;
                    }
                    if (sideHit != EnumFacing.EAST) break block76;
                    for (int x = 1; x <= range; ++x) {
                        pos = (double)startBlock.func_177956_o() > player.field_70163_u + 1.0 ? new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() - x, startBlock.func_177952_p()) : ((double)startBlock.func_177956_o() < player.field_70163_u - 2.0 ? new BlockPos(startBlock.func_177958_n() + x - 1, startBlock.func_177956_o() + x, startBlock.func_177952_p()) : new BlockPos(startBlock.func_177958_n() - x + 1, startBlock.func_177956_o() + x, startBlock.func_177952_p()));
                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                        coordinates.add(pos);
                    }
                    break block61;
                }
                if (sideHit != EnumFacing.WEST) break block61;
                for (int x = 1; x <= range; ++x) {
                    pos = (double)startBlock.func_177956_o() > player.field_70163_u + 1.0 ? new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o() - x, startBlock.func_177952_p()) : ((double)startBlock.func_177956_o() < player.field_70163_u - 2.0 ? new BlockPos(startBlock.func_177958_n() - x + 1, startBlock.func_177956_o() + x, startBlock.func_177952_p()) : new BlockPos(startBlock.func_177958_n() + x - 1, startBlock.func_177956_o() + x, startBlock.func_177952_p()));
                    if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                    coordinates.add(pos);
                }
                break block61;
            }
            if (mode == BuildingTool.ToolMode.Checkerboard) {
                for (int x = ++range * -7 / 5; x <= range * 7 / 5; ++x) {
                    for (int z = range * -7 / 5; z <= range * 7 / 5; ++z) {
                        if (x % ((range - 2) % 6 + 2) != 0 || z % ((range - 2) % 6 + 2) != 0 || !BuildingModes.isReplaceable(world, pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() + 1, startBlock.func_177952_p() + z), setBlock)) continue;
                        coordinates.add(pos);
                    }
                }
            }
        }
        return coordinates;
    }

    public static List<BlockPos> sortByDistance(List<BlockPos> unSortedList, EntityPlayer player) {
        ArrayList<BlockPos> sortedList = new ArrayList<BlockPos>();
        HashMap<Double, BlockPos> rangeMap = new HashMap<Double, BlockPos>();
        Object[] distances = new Double[unSortedList.size()];
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        int i = 0;
        for (BlockPos pos : unSortedList) {
            Double distance = pos.func_177957_d(x, y, z);
            rangeMap.put(distance, pos);
            distances[i] = distance;
            ++i;
        }
        Arrays.sort(distances);
        for (Object dist : distances) {
            sortedList.add((BlockPos)rangeMap.get(dist));
        }
        return sortedList;
    }

    public static List<BlockMap> sortMapByDistance(List<BlockMap> unSortedMap, EntityPlayer player) {
        ArrayList<BlockPos> unSortedList = new ArrayList<BlockPos>();
        HashMap<BlockPos, IBlockState> PosToStateMap = new HashMap<BlockPos, IBlockState>();
        HashMap<BlockPos, Integer> PosToX = new HashMap<BlockPos, Integer>();
        HashMap<BlockPos, Integer> PosToY = new HashMap<BlockPos, Integer>();
        HashMap<BlockPos, Integer> PosToZ = new HashMap<BlockPos, Integer>();
        for (BlockMap blockMap : unSortedMap) {
            PosToStateMap.put(blockMap.pos, blockMap.state);
            PosToX.put(blockMap.pos, blockMap.xOffset);
            PosToY.put(blockMap.pos, blockMap.yOffset);
            PosToZ.put(blockMap.pos, blockMap.zOffset);
            unSortedList.add(blockMap.pos);
        }
        ArrayList<BlockMap> sortedMap = new ArrayList<BlockMap>();
        HashMap<Double, BlockPos> rangeMap = new HashMap<Double, BlockPos>();
        Object[] distances = new Double[unSortedList.size()];
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        int i = 0;
        for (BlockPos pos : unSortedList) {
            Double distance = pos.func_177957_d(x, y, z);
            rangeMap.put(distance, pos);
            distances[i] = distance;
            ++i;
        }
        Arrays.sort(distances);
        for (Object dist : distances) {
            BlockPos pos = new BlockPos((Vec3i)rangeMap.get(dist));
            sortedMap.add(new BlockMap(pos, (IBlockState)PosToStateMap.get(pos), (Integer)PosToX.get(pos), (Integer)PosToY.get(pos), (Integer)PosToZ.get(pos)));
        }
        return sortedMap;
    }
}

