/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets;

import com.direwolf20.buildinggadgets.BuildingGadgets;
import com.direwolf20.buildinggadgets.Config;
import com.direwolf20.buildinggadgets.ModBlocks;
import com.direwolf20.buildinggadgets.ModEntities;
import com.direwolf20.buildinggadgets.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.blocks.ConstructionBlockPowder;
import com.direwolf20.buildinggadgets.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.blocks.templatemanager.TemplateManager;
import com.direwolf20.buildinggadgets.blocks.templatemanager.TemplateManagerTileEntity;
import com.direwolf20.buildinggadgets.gui.GuiProxy;
import com.direwolf20.buildinggadgets.items.BuildingTool;
import com.direwolf20.buildinggadgets.items.ConstructionPaste;
import com.direwolf20.buildinggadgets.items.ConstructionPasteContainer;
import com.direwolf20.buildinggadgets.items.ConstructionPasteContainerT2;
import com.direwolf20.buildinggadgets.items.ConstructionPasteContainerT3;
import com.direwolf20.buildinggadgets.items.CopyPasteTool;
import com.direwolf20.buildinggadgets.items.DestructionTool;
import com.direwolf20.buildinggadgets.items.ExchangerTool;
import com.direwolf20.buildinggadgets.items.Template;
import com.direwolf20.buildinggadgets.network.PacketHandler;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="buildinggadgets")
public class CommonProxy {
    public static Configuration config;

    public void preInit(FMLPreInitializationEvent e) {
        ModEntities.init();
        PacketHandler.registerMessages();
        File directory = e.getModConfigurationDirectory();
        config = new Configuration(new File(directory.getPath(), "BuildingGadgets.cfg"));
        Config.readConfig();
    }

    public void init() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)BuildingGadgets.instance, (IGuiHandler)new GuiProxy());
    }

    public void postInit() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new EffectBlock());
        event.getRegistry().register((IForgeRegistryEntry)new TemplateManager());
        GameRegistry.registerTileEntity(TemplateManagerTileEntity.class, (String)"buildinggadgets:templateManager");
        if (Config.enablePaste) {
            event.getRegistry().register((IForgeRegistryEntry)new ConstructionBlock());
            event.getRegistry().register((IForgeRegistryEntry)new ConstructionBlockPowder());
            GameRegistry.registerTileEntity(ConstructionBlockTileEntity.class, (String)"buildinggadgets_constructionBlock");
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BuildingTool());
        event.getRegistry().register((IForgeRegistryEntry)new ExchangerTool());
        event.getRegistry().register((IForgeRegistryEntry)new CopyPasteTool());
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.templateManager).setRegistryName(ModBlocks.templateManager.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)new Template());
        if (Config.enableDestructionTool) {
            event.getRegistry().register((IForgeRegistryEntry)new DestructionTool());
        }
        if (Config.enablePaste) {
            event.getRegistry().register(new ItemBlock((Block)ModBlocks.constructionBlock).setRegistryName(ModBlocks.constructionBlock.getRegistryName()));
            event.getRegistry().register(new ItemBlock((Block)ModBlocks.constructionBlockPowder).setRegistryName(ModBlocks.constructionBlockPowder.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)new ConstructionPaste());
            event.getRegistry().register((IForgeRegistryEntry)new ConstructionPasteContainer());
            event.getRegistry().register((IForgeRegistryEntry)new ConstructionPasteContainerT2());
            event.getRegistry().register((IForgeRegistryEntry)new ConstructionPasteContainerT3());
        }
    }
}

