/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets;

import com.direwolf20.buildinggadgets.CommonProxy;
import com.direwolf20.buildinggadgets.Config;
import com.direwolf20.buildinggadgets.KeyBindings;
import com.direwolf20.buildinggadgets.ModBlocks;
import com.direwolf20.buildinggadgets.ModEntities;
import com.direwolf20.buildinggadgets.ModItems;
import com.direwolf20.buildinggadgets.blocks.Models.BakedModelLoader;
import com.direwolf20.buildinggadgets.entities.BlockBuildEntity;
import com.direwolf20.buildinggadgets.entities.BlockBuildEntityRender;
import com.direwolf20.buildinggadgets.entities.ConstructionBlockEntity;
import com.direwolf20.buildinggadgets.entities.ConstructionBlockEntityRender;
import com.direwolf20.buildinggadgets.items.BuildingTool;
import com.direwolf20.buildinggadgets.items.CopyPasteTool;
import com.direwolf20.buildinggadgets.items.DestructionTool;
import com.direwolf20.buildinggadgets.items.ExchangerTool;
import com.direwolf20.buildinggadgets.items.GenericGadget;
import com.direwolf20.buildinggadgets.tools.PasteContainerMeshDefinition;
import com.direwolf20.buildinggadgets.tools.ToolRenders;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="buildinggadgets")
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent e) {
        ModEntities.initModels();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new BakedModelLoader());
        super.preInit(e);
    }

    @Override
    public void init() {
        super.init();
        KeyBindings.init();
        ModBlocks.initColorHandlers();
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModBlocks.effectBlock.initModel();
        ModBlocks.templateManager.initModel();
        ModItems.buildingTool.initModel();
        ModItems.exchangerTool.initModel();
        ModItems.copyPasteTool.initModel();
        ModItems.template.initModel();
        if (Config.enableDestructionTool) {
            ModItems.destructionTool.initModel();
        }
        if (Config.enablePaste) {
            ModItems.constructionPaste.initModel();
            ModItems.constructionPasteContainer.initModel();
            ModItems.constructionPasteContainert2.initModel();
            ModItems.constructionPasteContainert3.initModel();
            ModBlocks.constructionBlock.initModel();
            ModBlocks.constructionBlockPowder.initModel();
            ModelLoader.setCustomMeshDefinition((Item)ModItems.constructionPasteContainer, (ItemMeshDefinition)new PasteContainerMeshDefinition());
            ModelLoader.setCustomMeshDefinition((Item)ModItems.constructionPasteContainert2, (ItemMeshDefinition)new PasteContainerMeshDefinition());
            ModelLoader.setCustomMeshDefinition((Item)ModItems.constructionPasteContainert3, (ItemMeshDefinition)new PasteContainerMeshDefinition());
        }
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(BlockBuildEntity.class, (IRenderFactory)new BlockBuildEntityRender.Factory());
        RenderingRegistry.registerEntityRenderingHandler(ConstructionBlockEntity.class, (IRenderFactory)new ConstructionBlockEntityRender.Factory());
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderWorldLastEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP p = mc.field_71439_g;
        ItemStack heldItem = p.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof GenericGadget) && !((heldItem = p.func_184592_cb()).func_77973_b() instanceof GenericGadget)) {
            return;
        }
        if (heldItem.func_77973_b() instanceof BuildingTool) {
            ToolRenders.renderBuilderOverlay(evt, (EntityPlayer)p, heldItem);
        } else if (heldItem.func_77973_b() instanceof ExchangerTool) {
            ToolRenders.renderExchangerOverlay(evt, (EntityPlayer)p, heldItem);
        } else if (heldItem.func_77973_b() instanceof CopyPasteTool) {
            ToolRenders.renderPasteOverlay(evt, (EntityPlayer)p, heldItem);
        } else if (heldItem.func_77973_b() instanceof DestructionTool) {
            ToolRenders.renderDestructionOverlay(evt, (EntityPlayer)p, heldItem);
        }
    }

    @SubscribeEvent
    public static void registerSprites(TextureStitchEvent.Pre event) {
        ClientProxy.registerSprite(event, "buildinggadgets:gui/slot_copypastetool");
        ClientProxy.registerSprite(event, "buildinggadgets:gui/slot_template");
    }

    private static void registerSprite(TextureStitchEvent.Pre event, String loc) {
        event.getMap().func_174942_a(new ResourceLocation(loc));
    }
}

