/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.GenericExpressionCompiler;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.gui.GuiElementToolTip;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.ITooltipElement;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.gui.json.JsonGuiInfo;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;

public class ElementTypeToolTip
extends ElementType {
    public static final String NAME = "buildcraftlib:tooltip";
    public static final ElementTypeToolTip INSTANCE = new ElementTypeToolTip();

    private ElementTypeToolTip() {
        super(NAME);
    }

    @Override
    public IGuiElement deserialize0(BuildCraftJsonGui gui, IGuiPosition parent, JsonGuiInfo info, JsonGuiElement json) {
        ITooltipElement source;
        FunctionContext ctx = ElementTypeToolTip.createContext(json);
        ArrayList<String> text = new ArrayList<String>();
        String key = "text";
        boolean isExpression = false;
        if (json.properties.containsKey("expression") || json.properties.containsKey("expression[0]")) {
            key = "expression";
            isExpression = true;
        }
        if (json.properties.containsKey(key + "[0]")) {
            String prop;
            int i = 0;
            while ((prop = json.properties.get(key + "[" + i + "]")) != null) {
                text.add(prop);
                ++i;
            }
        } else {
            text.add(json.properties.getOrDefault(key, "ERROR: Text not given!"));
        }
        IExpressionNode.INodeBoolean visible = ElementTypeToolTip.getEquationBool(json, "visible", ctx, true);
        if (isExpression) {
            ArrayList<IExpressionNode.INodeObject<String>> nodes = new ArrayList<IExpressionNode.INodeObject<String>>(text.size());
            try {
                for (String s : text) {
                    nodes.add(GenericExpressionCompiler.compileExpressionString(s, ctx));
                }
            }
            catch (InvalidExpressionException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
            source = list -> {
                if (visible.evaluate()) {
                    String[] arr = new String[nodes.size()];
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = (String)((IExpressionNode.INodeObject)nodes.get(i)).evaluate();
                    }
                    list.add(ToolTip.createLocalized(arr));
                }
            };
        } else {
            ToolTip tooltip = ToolTip.createLocalized(text.toArray(new String[0]));
            source = list -> {
                if (visible.evaluate()) {
                    list.add(tooltip);
                }
            };
        }
        ElementTypeToolTip.inheritProperty(json, "pos[0]", "area[0]");
        ElementTypeToolTip.inheritProperty(json, "pos[1]", "area[1]");
        ElementTypeToolTip.inheritProperty(json, "size[0]", "area[2]");
        ElementTypeToolTip.inheritProperty(json, "size[1]", "area[3]");
        IGuiArea area = ElementTypeToolTip.resolveArea(json, "area", parent, ctx);
        return new GuiElementToolTip(gui, area, source);
    }
}

