/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectWorldInteraction;
import com.rwtema.careerbees.items.ItemIngredients;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.oredict.OreDictionary;

public class EffectLumber
extends EffectWorldInteraction {
    public static final EffectLumber INSTANCE = new EffectLumber("lumber", 200.0f);

    public EffectLumber(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    @Nonnull
    public static BlockPos.MutableBlockPos searchUpForNextNotEqual(World world, @Nonnull BlockPos startSearch, @Nonnull Predicate<BlockPos> isWood) {
        BlockPos.MutableBlockPos lower = new BlockPos.MutableBlockPos(startSearch);
        BlockPos.MutableBlockPos upper = new BlockPos.MutableBlockPos(startSearch).func_189534_c(EnumFacing.UP, 4);
        while (isWood.test((BlockPos)upper)) {
            lower.func_185336_p(upper.func_177956_o());
            upper.func_185336_p(startSearch.func_177956_o() + (upper.func_177956_o() - startSearch.func_177956_o()) * 2);
        }
        BlockPos.MutableBlockPos center = new BlockPos.MutableBlockPos(startSearch);
        do {
            center.func_185336_p((lower.func_177956_o() + upper.func_177956_o()) / 2);
            if (isWood.test((BlockPos)center)) {
                lower.func_185336_p(center.func_177956_o());
                continue;
            }
            upper.func_185336_p(center.func_177956_o());
        } while (upper.func_177956_o() - lower.func_177956_o() > 1);
        return upper;
    }

    @Override
    protected boolean performPosEffect(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState state, IBeeGenome genome, @Nonnull IBeeHousing housing) {
        if (state.func_177230_c().isWood((IBlockAccess)world, blockPos)) {
            BlockPos.MutableBlockPos topBlock = EffectLumber.searchUpForNextNotEqual(world, blockPos, s -> world.func_180495_p(s).func_177230_c().isWood((IBlockAccess)world, s));
            IBlockState leafState = world.func_180495_p((BlockPos)topBlock);
            if (!leafState.func_177230_c().isLeaves(leafState, (IBlockAccess)world, (BlockPos)topBlock)) {
                return false;
            }
            NonNullList drops = NonNullList.func_191196_a();
            state.func_177230_c().getDrops(drops, (IBlockAccess)world, blockPos, state, 0);
            float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)blockPos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, null);
            block0: for (ItemStack drop : drops) {
                int blockWood = OreDictionary.getOreID((String)"logWood");
                for (int i : OreDictionary.getOreIDs((ItemStack)drop)) {
                    if (i != blockWood) continue;
                    if (chance != 1.0f && !(world.field_73012_v.nextFloat() <= chance)) continue block0;
                    NBTTagCompound tag = drop.func_77955_b(new NBTTagCompound());
                    ItemStack barkStack = ItemIngredients.IngredientType.BARK.get();
                    barkStack.func_77983_a("bark", (NBTBase)tag);
                    barkStack.func_190920_e(1 + world.field_73012_v.nextInt(1 + world.field_73012_v.nextInt(8)));
                    housing.getBeeInventory().addProduct(barkStack, false);
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandleBlock(World world, BlockPos blockPos, @Nonnull IBeeGenome genome, EnumFacing sideHit) {
        if (world.func_180495_p(blockPos).func_177230_c().isWood((IBlockAccess)world, blockPos)) {
            BlockPos.MutableBlockPos topBlock = EffectLumber.searchUpForNextNotEqual(world, blockPos, s -> world.func_180495_p(s).func_177230_c().isWood((IBlockAccess)world, s));
            IBlockState leafState = world.func_180495_p((BlockPos)topBlock);
            return leafState.func_177230_c().isLeaves(leafState, (IBlockAccess)world, (BlockPos)topBlock);
        }
        return false;
    }
}

