/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.block;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.common.block.SonarBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.utils.ISpecialTooltip;
import sonar.flux.FluxTranslate;
import sonar.flux.common.item.ItemConfigurator;
import sonar.flux.common.tileentity.TileFlux;

public abstract class FluxConnection
extends SonarBlock
implements ITileEntityProvider,
ISpecialTooltip {
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");

    public FluxConnection() {
        super(SonarMaterials.machine, false);
        this.hasSpecialRenderer = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
    }

    public void addSpecialToolTip(ItemStack stack, World world, List<String> list, NBTTagCompound tag) {
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem;
        ItemStack itemStack = heldItem = hand == null ? ItemStack.field_190927_a : player.func_184586_b(hand);
        if (heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ItemConfigurator)) {
            TileEntity target;
            if (!world.field_72995_K && (target = world.func_175625_s(pos)) instanceof TileFlux) {
                TileFlux flux = (TileFlux)target;
                if (flux.canAccess(player).canView()) {
                    FlexibleGuiHandler.instance().openBasicTile(player, (TileEntity)flux, 0);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(SonarHelper.getProfileByUUID((UUID)((UUID)flux.playerUUID.getValue())).getName() + " : " + FluxTranslate.ERROR_NO_PERMISSION.t()));
                }
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemstack) {
        super.func_180633_a(world, pos, state, player, itemstack);
        TileEntity target = world.func_175625_s(pos);
        if (target instanceof TileFlux) {
            TileFlux flux = (TileFlux)target;
            flux.onBlockPlacedBy(world, pos, state, player, itemstack);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        if (!world.field_72995_K) {
            this.updateRedstonePower(world, pos);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (!world.field_72995_K) {
            this.updateRedstonePower(world, pos);
        }
    }

    private void updateRedstonePower(World world, BlockPos pos) {
        TileEntity target = world.func_175625_s(pos);
        if (target instanceof TileFlux) {
            TileFlux flux = (TileFlux)target;
            flux.updateRedstonePower();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTED});
    }
}

