/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.power.storage;

import ipsis.Woot;
import ipsis.woot.block.BlockMobFactoryCell;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.power.storage.IPowerStation;
import ipsis.woot.power.storage.WootEnergyStorage;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class SinglePowerStation
implements IPowerStation {
    WootEnergyStorage energyStorage;
    BlockMobFactoryCell.EnumCellTier tier;

    public SinglePowerStation() {
        this.setTier(BlockMobFactoryCell.EnumCellTier.TIER_I);
    }

    @Override
    public void setTier(BlockMobFactoryCell.EnumCellTier tier) {
        this.tier = tier;
        if (tier == BlockMobFactoryCell.EnumCellTier.TIER_I) {
            this.energyStorage = new WootEnergyStorage(Woot.wootConfiguration.getInteger(EnumConfigKey.T1_POWER_MAX), Woot.wootConfiguration.getInteger(EnumConfigKey.T1_POWER_RX_TICK));
        } else if (tier == BlockMobFactoryCell.EnumCellTier.TIER_II) {
            this.energyStorage = new WootEnergyStorage(Woot.wootConfiguration.getInteger(EnumConfigKey.T2_POWER_MAX), Woot.wootConfiguration.getInteger(EnumConfigKey.T2_POWER_RX_TICK));
        } else if (tier == BlockMobFactoryCell.EnumCellTier.TIER_III) {
            this.energyStorage = new WootEnergyStorage(Woot.wootConfiguration.getInteger(EnumConfigKey.T3_POWER_MAX), Woot.wootConfiguration.getInteger(EnumConfigKey.T3_POWER_RX_TICK));
        }
    }

    @Override
    public BlockMobFactoryCell.EnumCellTier getTier() {
        return this.tier;
    }

    @Override
    public int consume(int power) {
        int consumed = this.energyStorage.extractEnergyInternal(power, true);
        if (consumed > 0) {
            this.energyStorage.extractEnergyInternal(consumed, false);
        }
        return consumed;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.setTier(BlockMobFactoryCell.EnumCellTier.byMetadata(compound.func_74762_e("Tier")));
        this.energyStorage.readFromNBT(compound);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("Tier", this.tier.ordinal());
        this.energyStorage.writeToNBT(compound);
    }

    @Override
    @Nonnull
    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }
}

