/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackHelper {
    public static boolean equalStacksRegular(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ItemStack getOrCreateStack(Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack stack = ((ItemStack)obj).func_77946_l();
            if (stack.func_190916_E() == 0) {
                stack.func_190920_e(1);
            }
            return stack;
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, 1);
        }
        if (!(obj instanceof Block)) {
            throw new RuntimeException(String.format("Invalid ItemStack: %s", obj));
        }
        return new ItemStack((Block)obj, 1);
    }

    public static boolean matchingModid(ItemStack target, ItemStack stack) {
        String targetID = target.func_77973_b().getRegistryName().func_110624_b();
        String stackID = stack.func_77973_b().getRegistryName().func_110624_b();
        return targetID != null && !targetID.isEmpty() && !stackID.isEmpty() && targetID.equals(stackID);
    }

    public static boolean matchingOreDictID(ItemStack target, ItemStack stack) {
        int[] stackIDs = OreDictionary.getOreIDs((ItemStack)stack);
        int[] filterIDs = OreDictionary.getOreIDs((ItemStack)target);
        for (int sID : stackIDs) {
            for (int fID : filterIDs) {
                if (sID != fID) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getBlockItem(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = state.func_177230_c().func_185473_a(world, pos, state);
        if (stack.func_190926_b()) {
            stack = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()));
        }
        return stack;
    }
}

