/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.discovery.IASMDataProcessor;
import elec332.core.util.ReflectionHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class FMLUtil {
    private static IASMDataHelper asmData;

    public static Class<?> loadClass(String clazz) throws ClassNotFoundException {
        try {
            return Class.forName(clazz, true, (ClassLoader)FMLUtil.getLoader().getModClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (asmData.hasSideOnlyAnnotation(clazz)) {
                throw new SideOnlyClassNotFoundException(e.getMessage(), e.getCause());
            }
            throw e;
        }
    }

    public static String getOwnerName(Class<?> clazz) {
        ModContainer mod = FMLUtil.getOwner(clazz);
        return mod == null ? "<unknown>" : mod.getModId();
    }

    public static String getMcVersion() {
        return (String)FMLInjectionData.data()[4];
    }

    @Nullable
    public static ModContainer getOwner(Class<?> clazz) {
        for (ModContainer modContainer : FMLUtil.getLoader().getActiveModList()) {
            if (!modContainer.getOwnedPackages().contains(ReflectionHelper.getPackage(clazz))) continue;
            return modContainer;
        }
        return null;
    }

    @Nullable
    public static ModContainer getModContainer(Object mod) {
        return mod instanceof ModContainer ? (ModContainer)mod : FMLCommonHandler.instance().findContainerFor(mod);
    }

    public static boolean isInModInitialisation() {
        return !FMLUtil.hasReachedState(LoaderState.AVAILABLE);
    }

    public static boolean hasReachedState(LoaderState state) {
        return FMLUtil.getLoader().hasReachedState(state);
    }

    @Nonnull
    public static Loader getLoader() {
        return Loader.instance();
    }

    public static boolean hasFMLModContainer(ModContainer mc) {
        return mc instanceof FMLModContainer || mc instanceof InjectedModContainer && FMLUtil.hasFMLModContainer(((InjectedModContainer)mc).wrappedContainer);
    }

    public static FMLModContainer getFMLModContainer(ModContainer mc) {
        if (mc instanceof FMLModContainer) {
            return (FMLModContainer)mc;
        }
        if (mc instanceof InjectedModContainer) {
            return FMLUtil.getFMLModContainer(((InjectedModContainer)mc).wrappedContainer);
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public static ModContainer findMod(String modId) {
        for (ModContainer mc : FMLUtil.getLoader().getActiveModList()) {
            if (!mc.getModId().equals(modId)) continue;
            return mc;
        }
        return null;
    }

    @ASMDataProcessor(value={LoaderState.CONSTRUCTING}, importance=0x7FFFFFFF)
    public static class ASMGetter
    implements IASMDataProcessor {
        public ASMGetter() {
            if (asmData != null) {
                throw new IllegalStateException();
            }
        }

        @Override
        public void processASMData(IASMDataHelper asmData, LoaderState state) {
            asmData = asmData;
        }
    }

    public static class SideOnlyClassNotFoundException
    extends ClassNotFoundException {
        public SideOnlyClassNotFoundException(String s, Throwable ex) {
            super(s, ex);
        }
    }
}

