/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.window;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.client.RenderHelper;
import elec332.core.client.util.GuiDraw;
import elec332.core.inventory.tooltip.ToolTip;
import elec332.core.inventory.widget.IWidget;
import elec332.core.inventory.widget.IWidgetListener;
import elec332.core.inventory.widget.slot.WidgetSlot;
import elec332.core.inventory.widget.slot.WidgetSlotOutput;
import elec332.core.inventory.window.IWidgetContainer;
import elec332.core.inventory.window.IWindowContainer;
import elec332.core.inventory.window.IWindowListener;
import elec332.core.inventory.window.IWindowModifier;
import elec332.core.proxies.CommonProxy;
import elec332.core.util.ItemStackHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.lwjgl.input.Mouse;

public class Window
implements IWidgetContainer {
    private static final int defaultX = 176;
    private static final int defaultY = 166;
    private final List<IWindowModifier> modifiers;
    private boolean hasInit = false;
    private final boolean normalSize;
    private final boolean tooBig;
    private final List<IWidget> widgets = Lists.newArrayList();
    private final List<IWidget> widgets_ = Collections.unmodifiableList(this.widgets);
    private final Map<IWidget, Integer> map;
    private final Set<EntityPlayer> playerList = Sets.newHashSet();
    private IWindowContainer windowContainer;
    private ResourceLocation background;
    private int offset;
    private int playerInvIndexStart = 0;
    private int playerInvIndexStop = 0;
    public final int xSize;
    public final int ySize;
    @SideOnly(value=Side.CLIENT)
    protected int width;
    @SideOnly(value=Side.CLIENT)
    protected int height;
    @SideOnly(value=Side.CLIENT)
    public int guiLeft;
    @SideOnly(value=Side.CLIENT)
    public int guiTop;
    public static final ResourceLocation DEFAULT_BACKGROUND = new ResourceLocation("eleccore", "default.png");

    public Window() {
        this(-1, -1, new IWindowModifier[0]);
    }

    public Window(int xSize, int ySize, IWindowModifier ... modifiers) {
        this.xSize = xSize == -1 ? 176 : xSize;
        this.ySize = ySize == -1 ? 166 : ySize;
        this.map = Maps.newHashMap();
        this.modifiers = modifiers == null ? Lists.newArrayList() : Lists.newArrayList((Object[])modifiers);
        this.normalSize = this.xSize == 176 && this.ySize == 166;
        this.tooBig = this.xSize < 176 || this.xSize > 340 || this.ySize < 166 || this.ySize > 320;
    }

    final void setContainer(IWindowContainer windowContainer) {
        this.windowContainer = windowContainer;
    }

    final void initWindow_() {
        if (this.modifiers != null) {
            for (IWindowModifier modifier : this.modifiers) {
                modifier.modifyWindow(this, new Object[0]);
            }
        }
        this.initWindow();
        this.hasInit = true;
    }

    protected void initWindow() {
    }

    public Window addModifier(IWindowModifier modifier) {
        if (!this.hasInit) {
            this.modifiers.add(modifier);
        } else {
            modifier.modifyWindow(this, new Object[0]);
        }
        return this;
    }

    @Override
    public final List<IWidget> getWidgets() {
        return this.widgets_;
    }

    @Override
    public <W extends IWidget> W addWidget(W widget) {
        widget.setContainer(this);
        widget.setID(this.widgets.size());
        WidgetListener wl = new WidgetListener();
        wl.setWidget(widget);
        for (IWindowListener obj : this.getListeners()) {
            wl.setListener(obj);
            widget.initWidget(wl);
        }
        this.widgets.add(widget);
        if (widget instanceof WidgetSlot) {
            this.windowContainer.addSlotToWindow((WidgetSlot)widget);
        }
        return widget;
    }

    public Window addPlayerInventoryToContainer() {
        int i;
        this.playerInvIndexStart = this.windowContainer.getSlotListSize();
        PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(this.getPlayer().field_71071_by);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addWidget(new WidgetSlot((IItemHandler)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + this.offset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addWidget(new WidgetSlot((IItemHandler)playerInv, i, 8 + i * 18, 142 + this.offset));
        }
        this.playerInvIndexStop = this.windowContainer.getSlotListSize();
        return this;
    }

    @Nonnull
    protected ItemStack transferStackInSlot(EntityPlayer player, int slotID) {
        ItemStack itemstack = ItemStackHelper.NULL_STACK;
        WidgetSlot slot = this.windowContainer.getSlot(slotID);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.func_77946_l();
            if (slot instanceof WidgetSlotOutput) {
                if (!this.mergeItemStack(itemstack1, this.playerInvIndexStart, this.playerInvIndexStop, true)) {
                    return ItemStackHelper.NULL_STACK;
                }
                slot.onSlotChange(itemstack1, itemstack);
            } else if (slotID >= this.playerInvIndexStart && slotID <= this.playerInvIndexStop) {
                for (int i = 0; i < this.playerInvIndexStart; ++i) {
                    WidgetSlot slot1 = this.windowContainer.getSlot(i);
                    if (!slot1.isItemValid(itemstack1) || this.mergeItemStack(itemstack1, i, i + 1, false)) continue;
                    if (itemstack1.func_190916_E() < 1) {
                        this.putStackInSlot(slotID, ItemStackHelper.NULL_STACK);
                    }
                    return ItemStackHelper.NULL_STACK;
                }
                if (slotID >= this.playerInvIndexStart && slotID < this.playerInvIndexStop - 9) {
                    if (!this.mergeItemStack(itemstack1, this.playerInvIndexStop - 9, this.playerInvIndexStop, false)) {
                        if (itemstack1.func_190916_E() < 1) {
                            this.putStackInSlot(slotID, ItemStackHelper.NULL_STACK);
                        }
                        return ItemStackHelper.NULL_STACK;
                    }
                } else if (slotID >= this.playerInvIndexStop - 9 && slotID < this.playerInvIndexStop && !this.mergeItemStack(itemstack1, this.playerInvIndexStart, this.playerInvIndexStop - 9, false)) {
                    if (itemstack1.func_190916_E() < 1) {
                        this.putStackInSlot(slotID, ItemStackHelper.NULL_STACK);
                    }
                    return ItemStackHelper.NULL_STACK;
                }
            } else if (!this.mergeItemStack(itemstack1, this.playerInvIndexStart, this.playerInvIndexStop, false)) {
                return ItemStackHelper.NULL_STACK;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.putStack(ItemStackHelper.NULL_STACK);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStackHelper.NULL_STACK;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    @Nonnull
    public ItemStack slotClick(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        return this.slotClickDefault(slotId, dragType, clickTypeIn, player);
    }

    public boolean canMergeSlot(ItemStack stack, WidgetSlot slot) {
        return slot.canMergeSlot(stack);
    }

    protected boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.windowContainer.mergeItemStackDefault(stack, startIndex, endIndex, reverseDirection);
    }

    public boolean getCanCraft(@Nonnull EntityPlayer player) {
        return !this.playerList.contains(player);
    }

    public void setCanCraft(@Nonnull EntityPlayer player, boolean canCraft) {
        if (canCraft) {
            this.playerList.remove(player);
        } else {
            this.playerList.add(player);
        }
    }

    public void onListenerAdded(IWindowListener listener) {
        WidgetListener wl = new WidgetListener();
        wl.setListener(listener);
        for (IWidget widget : this.widgets) {
            wl.setWidget(widget);
            widget.initWidget(wl);
        }
    }

    public final Window setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public Window setBackground(ResourceLocation background) {
        this.background = background;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        this.widgets.get(id).updateProgressbar(data);
    }

    public void detectAndSendChanges(Container from) {
        final WidgetListener wl = new WidgetListener();
        for (IWidget widget : this.widgets) {
            wl.setWidget(widget);
            widget.detectAndSendChanges(new Iterable<IWidgetListener>(){

                @Override
                @Nonnull
                public Iterator<IWidgetListener> iterator() {
                    return new Iterator<IWidgetListener>(){
                        private int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < Window.this.getListeners().size();
                        }

                        @Override
                        public IWidgetListener next() {
                            wl.setListener(Window.this.getListeners().get(this.index));
                            ++this.index;
                            return wl;
                        }
                    };
                }
            });
        }
    }

    public void onWindowClosed(EntityPlayer playerIn) {
        for (IWidget widget : this.widgets_) {
            widget.onWindowClosed(playerIn);
        }
    }

    public void onCraftMatrixChanged(IInventory inventoryIn) {
        this.detectAndSendChanges();
    }

    public boolean canInteractWith(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    public void putStackInSlot(int slotID, @Nonnull ItemStack stack) {
        this.windowContainer.getSlot(slotID).putStack(stack);
    }

    public void onPacket(NBTTagCompound tag, Side receiver) {
    }

    public void modifyTooltip(List<String> tooltip, WidgetSlot slot, ItemStack stack, int x, int y) {
        this.modifyTooltip(tooltip, slot, x, y);
    }

    public void modifyTooltip(List<String> tooltip, IWidget widget, int mouseX, int mouseY) {
        widget.modifyTooltip(tooltip, mouseX, mouseY);
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleMouseClick(@Nullable WidgetSlot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        this.windowContainer.handleMouseClickDefault(slotIn, slotId, mouseButton, type);
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean mouseClicked(int mouseX, int mouseY, int button) throws IOException {
        for (IWidget widget : this.getWidgets()) {
            if (widget.isHidden() || !widget.isMouseOver(this.translatedMouseX(mouseX), this.translatedMouseY(mouseY)) || !widget.mouseClicked(this.translatedMouseX(mouseX), this.translatedMouseY(mouseY), button)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean keyTyped(char typedChar, int keyCode) {
        for (IWidget widget : this.getWidgets()) {
            if (widget.isHidden() || !widget.keyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleMouseInput() throws IOException {
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            int mouseX = Mouse.getEventX() * this.width / Minecraft.func_71410_x().field_71443_c;
            int mouseY = this.height - Mouse.getEventY() * this.height / Minecraft.func_71410_x().field_71440_d - 1;
            this.handleMouseWheel(wheel, this.translatedMouseX(mouseX), this.translatedMouseY(mouseY));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean handleMouseWheel(int wheel, int translatedMouseX, int translatedMouseY) {
        for (IWidget widget : this.widgets) {
            if (!widget.handleMouseWheel(wheel, translatedMouseX, translatedMouseY)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawScreenPre(int mouseX, int mouseY, float partialTicks) {
        GuiDraw.drawDefaultBackground();
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        for (IWidget widget : this.getWidgets()) {
            ToolTip toolTip;
            if (widget.isHidden() || !widget.isMouseOver(this.translatedMouseX(mouseX), this.translatedMouseY(mouseY)) || (toolTip = widget.getToolTip(this.translatedMouseX(mouseX), this.translatedMouseY(mouseY))) == null) continue;
            if (widget instanceof WidgetSlot) {
                this.modifyTooltip(toolTip.getTooltip(), (WidgetSlot)widget, ((WidgetSlot)widget).getStack(), mouseX, mouseY);
            } else {
                this.modifyTooltip(toolTip.getTooltip(), widget, mouseX, mouseY);
            }
            toolTip.renderTooltip(mouseX, mouseY, this.guiLeft, this.guiTop);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation background = this.getBackgroundImageLocation();
        if (background != null) {
            RenderHelper.bindTexture(background);
            GuiDraw.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        } else {
            RenderHelper.bindTexture(DEFAULT_BACKGROUND);
            if (this.normalSize) {
                GuiDraw.drawTexturedModalRect(k, l, 0, 0, 176, 166);
            } else if (!this.tooBig) {
                int xS = 170;
                int xY = 160;
                GuiDraw.drawTexturedModalRect(k, l, 0, 0, xS, xY);
                GuiDraw.drawTexturedModalRect(k + this.xSize - xS, l, 6, 0, xS, xY);
                GuiDraw.drawTexturedModalRect(k + this.xSize - xS, l + this.ySize - xY, 6, 6, xS, xY);
                GuiDraw.drawTexturedModalRect(k, l + this.ySize - xY, 0, 6, xS, xY);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        this.drawWidgets(k, l, mouseX, mouseY);
        GlStateManager.func_179121_F();
    }

    protected void drawWidgets(int k, int l, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (IWidget widget : this.getWidgets()) {
            if (widget.isHidden()) continue;
            widget.draw(this, k, l, this.translatedMouseX(mouseX), this.translatedMouseY(mouseY));
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesWindowPauseGame() {
        return false;
    }

    public WidgetSlot getSlot(int id) {
        return this.windowContainer.getSlot(id);
    }

    public int getSlotListSize() {
        return this.windowContainer.getSlotListSize();
    }

    public final void detectAndSendChanges() {
        this.windowContainer.detectAndSendChanges();
    }

    public final EntityPlayer getPlayer() {
        return this.windowContainer == null ? CommonProxy.currentOpeningPlayer.get() : this.windowContainer.getPlayer();
    }

    public final List<IWindowListener> getListeners() {
        return this.windowContainer.getListeners();
    }

    public boolean mergeItemStackDefault(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.windowContainer.mergeItemStackDefault(stack, startIndex, endIndex, reverseDirection);
    }

    @Nonnull
    protected final ItemStack slotClickDefault(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        return this.windowContainer.slotClickDefault(slotId, dragType, clickTypeIn, player);
    }

    protected final void sendPacket(NBTTagCompound tag) {
        this.windowContainer.sendPacket(tag);
    }

    protected int translatedMouseX(int mouseX) {
        return mouseX - this.guiLeft;
    }

    protected int translatedMouseY(int mouseY) {
        return mouseY - this.guiTop;
    }

    public ResourceLocation getBackgroundImageLocation() {
        return this.background;
    }

    public int getWindowID() {
        return this.windowContainer.getWindowID();
    }

    private class WidgetListener
    implements IWidgetListener {
        private IWindowListener listener;
        private IWidget widget;

        private WidgetListener() {
        }

        private void setListener(IWindowListener listener) {
            this.listener = listener;
        }

        private void setWidget(IWidget widget) {
            this.widget = widget;
        }

        @Override
        public void updateCraftingInventory(List<ItemStack> itemsList) {
            this.listener.updateCraftingInventory(itemsList);
        }

        @Override
        public void sendSlotContents(int slotInd, ItemStack stack) {
            this.listener.sendSlotContents(slotInd, stack);
        }

        @Override
        public void sendProgressBarUpdate(int newValue) {
            this.listener.sendProgressBarUpdate((Integer)Window.this.map.get(this.widget), newValue);
        }

        @Override
        public IWindowListener getWindowListener() {
            return this.listener;
        }
    }
}

