/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.setup;

import elec332.core.handler.ElecCoreRegistrar;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.ForgeEventHandlers;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.compat.computers.OpenComputersIntegration;
import mcjty.deepresonance.config.ConfigSetup;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.items.ModItems;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.radiation.RadiationTickEvent;
import mcjty.deepresonance.setup.GuiProxy;
import mcjty.deepresonance.tanks.TankGridHandler;
import mcjty.deepresonance.worldgen.WorldGen;
import mcjty.deepresonance.worldgen.WorldTickHandler;
import mcjty.lib.compat.MainCompatHandler;
import mcjty.lib.setup.DefaultModSetup;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class ModSetup
extends DefaultModSetup {
    public boolean rftools = false;
    public boolean rftoolsControl = false;

    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        MinecraftForge.EVENT_BUS.register((Object)WorldTickHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)new RadiationTickEvent());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)DeepResonance.instance, (IGuiHandler)new GuiProxy());
        DRMessages.registerMessages("deepresonance");
        ElecCoreRegistrar.GRIDHANDLERS.register((Object)new TankGridHandler());
        ModItems.init();
        ModBlocks.init();
        WorldGen.init();
        DRFluidRegistry.initFluids();
    }

    protected void setupModCompat() {
        this.rftools = Loader.isModLoaded((String)"rftools");
        this.rftoolsControl = Loader.isModLoaded((String)"rftoolscontrol");
        MainCompatHandler.registerWaila();
        MainCompatHandler.registerTOP();
        if (this.rftools) {
            Logging.log((String)"Detected RFTools: enabling support");
            FMLInterModComms.sendFunctionMessage((String)"rftools", (String)"getScreenModuleRegistry", (String)"mcjty.deepresonance.items.rftoolsmodule.RFToolsSupport$GetScreenModuleRegistry");
        }
        if (this.rftoolsControl) {
            Logging.log((String)"Detected RFTools Control: enabling support");
            FMLInterModComms.sendFunctionMessage((String)"rftoolscontrol", (String)"getOpcodeRegistry", (String)"mcjty.deepresonance.compat.rftoolscontrol.RFToolsControlSupport$GetOpcodeRegistry");
        }
        if (Loader.isModLoaded((String)"opencomputers")) {
            OpenComputersIntegration.init();
        }
    }

    protected void setupConfig() {
        ConfigSetup.init();
    }

    public void createTabs() {
        this.createTab("DeepResonance", () -> new ItemStack((Block)ModBlocks.resonatingCrystalBlock));
    }

    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        ConfigSetup.postInit();
    }
}

