/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.deepresonance.items.RadiationMonitorItem;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.network.PacketReturnRadiation;
import mcjty.lib.network.IClientServerDelayed;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.GlobalCoordinate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetRadiationLevel
implements IMessage,
IClientServerDelayed {
    private GlobalCoordinate coordinate;

    public void fromBytes(ByteBuf buf) {
        int dim = buf.readInt();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.coordinate = new GlobalCoordinate(new BlockPos(x, y, z), dim);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.coordinate.getDimension());
        buf.writeInt(this.coordinate.getCoordinate().func_177958_n());
        buf.writeInt(this.coordinate.getCoordinate().func_177956_o());
        buf.writeInt(this.coordinate.getCoordinate().func_177952_p());
    }

    public PacketGetRadiationLevel() {
    }

    public PacketGetRadiationLevel(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetRadiationLevel(GlobalCoordinate coordinate) {
        this.coordinate = coordinate;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            World world = player.func_130014_f_();
            float strength = RadiationMonitorItem.calculateRadiationStrength(world, this.coordinate);
            PacketReturnRadiation packet = new PacketReturnRadiation(strength);
            DRMessages.INSTANCE.sendTo((IMessage)packet, ctx.getSender());
        });
        ctx.setPacketHandled(true);
    }
}

