/*
 * Decompiled with CFR 0.152.
 */
package tehnut.harvest;

import java.util.List;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import tehnut.harvest.BlockStack;
import tehnut.harvest.Harvest;
import tehnut.harvest.IReplantHandler;

public class ReplantHandlers {
    public static final IReplantHandler CONFIG = (world, pos, state, player, tileEntity) -> {
        BlockStack worldBlock = BlockStack.getStackFromPos(world, pos);
        BlockStack newBlock = Harvest.config.getCropMap().get(worldBlock).getFinalBlock();
        NonNullList drops = NonNullList.func_191196_a();
        worldBlock.getBlock().getDrops(drops, (IBlockAccess)world, pos, state, 0);
        ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)player);
        boolean foundSeed = false;
        for (ItemStack stack : drops) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPlantable)) continue;
            stack.func_190918_g(1);
            foundSeed = true;
            break;
        }
        boolean seedNotNull = true;
        if (worldBlock.getBlock() instanceof BlockCrops) {
            try {
                Item seed = (Item)Harvest._GET_SEED.invoke((Object)worldBlock.getBlock(), new Object[0]);
                seedNotNull = seed != null && seed != Items.field_190931_a;
            }
            catch (Exception e) {
                Harvest.LOGGER.error("Failed to reflect BlockCrops: {}", (Object)e.getLocalizedMessage());
            }
        }
        if (seedNotNull && foundSeed) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, newBlock.getState());
                for (ItemStack stack : drops) {
                    EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                    entityItem.func_174867_a(10);
                    world.func_72838_d((Entity)entityItem);
                }
            }
        } else if (Harvest.config.shouldLog()) {
            Harvest.LOGGER.info("Did not harvest. seedNotNull - {}, foundSeed - {}", (Object)seedNotNull, (Object)foundSeed);
        }
    };
}

