/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.SortedSet;
import net.creeperhost.minetogether.chat.ChatUtil;
import net.creeperhost.minetogether.common.IHost;
import net.creeperhost.minetogether.common.LimitedSizeQueue;
import net.creeperhost.minetogether.common.Pair;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelJoinEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelNoticeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelPartEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.UnexpectedChannelLeaveViaKickEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientConnectionClosedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientConnectionEndedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientNegotiationCompleteEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.NickRejectedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.UnexpectedChannelLeaveEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateCtcpQueryEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateMessageEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.PrivateNoticeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.user.UserQuitEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Format;
import net.creeperhost.minetogether.serverlist.data.Friend;

public class ChatHandler {
    public static final Object ircLock = new Object();
    public static HashMap<String, Boolean> newMessages = new HashMap();
    private static ChatUtil.IRCServer IRC_SERVER;
    public static String CHANNEL;
    public static ConnectionStatus connectionStatus;
    public static HashMap<String, LimitedSizeQueue<Pair<String, String>>> messages;
    private static Client client;
    private static IHost host;
    public static int tries;
    private static boolean inited;
    public static List<String> badwords;
    public static String badwordsFormat;
    public static String initedString;
    private static String nick;
    public static HashMap<String, String> friends;
    public static HashMap<String, String> anonUsers;
    public static HashMap<String, String> anonUsersReverse;
    public static Random random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String nickIn, IHost _host) {
        if (inited) {
            return;
        }
        initedString = nickIn;
        badwords = ChatUtil.getBadWords();
        badwordsFormat = ChatUtil.getAllowedCharactersRegex();
        IRC_SERVER = ChatUtil.getIRCServerDetails();
        CHANNEL = ChatHandler.IRC_SERVER.channel;
        host = _host;
        tries = 0;
        nick = nickIn;
        Object object = ircLock;
        synchronized (object) {
            messages = new HashMap();
            new Thread(() -> {
                client = Client.builder().nick(nickIn).realName("https://minetogether.io").user("MineTogether").serverHost(ChatHandler.IRC_SERVER.address).serverPort(ChatHandler.IRC_SERVER.port).secure(ChatHandler.IRC_SERVER.ssl).exceptionListener(exception -> {}).buildAndConnect();
                ((Client.WithManagement)client).getActorTracker().setQueryChannelInformation(false);
                client.getEventManager().registerEventListener(new Listener());
                client.addChannel(CHANNEL);
            }).start();
        }
        inited = true;
    }

    public static void reInit() {
        inited = false;
        ChatHandler.init(initedString, host);
    }

    private static void addMessageToChat(String target, String user, String message) {
        LimitedSizeQueue<Pair<String, String>> tempQueue = messages.get(target);
        if (tempQueue == null) {
            tempQueue = new LimitedSizeQueue(150);
            messages.put(target, tempQueue);
        }
        Pair<String, String> messagePair = new Pair<String, String>(user, message);
        tempQueue.add(messagePair);
        host.messageReceived(target, messagePair);
        newMessages.put(target, new Boolean(true));
    }

    public static void addStatusMessage(String message) {
        ChatHandler.addMessageToChat(CHANNEL, "System", message);
    }

    public static String getNameForUser(String nick) {
        return host.getNameForUser(nick);
    }

    private static void updateFriends(List<String> users) {
        List<Friend> friendsCall = host.getFriends();
        HashMap<String, String> oldFriends = friends;
        friends = new HashMap();
        for (Friend friend : friendsCall) {
            if (!friend.isAccepted()) continue;
            String friendCode = "MT" + friend.getCode().substring(0, 15);
            for (String user : users) {
                if (!user.equals(friendCode)) continue;
                friends.put(friendCode, friend.getName());
            }
        }
        for (Map.Entry entry : friends.entrySet()) {
            if (oldFriends.containsKey(entry.getKey())) continue;
            host.friendEvent((String)entry.getKey(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(String currentTarget, String text) {
        if (currentTarget.equals(CHANNEL)) {
            client.getChannel(CHANNEL).get().sendMessage(text);
        } else if (client.getChannel(CHANNEL).get().getUser(currentTarget).isPresent()) {
            client.getChannel(CHANNEL).get().getUser(currentTarget).get().sendMessage(text);
        } else {
            ChatHandler.updateFriends(client.getChannel(CHANNEL).get().getNicknames());
            return;
        }
        Object object = ircLock;
        synchronized (object) {
            ChatHandler.addMessageToChat(currentTarget, client.getNick(), text);
        }
    }

    public static void sendFriendRequest(String target, String desiredName) {
        Optional<User> userOpt = client.getChannel(CHANNEL).get().getUser(target);
        if (userOpt.isPresent()) {
            User user = userOpt.get();
            StringBuilder builder = new StringBuilder("FRIENDREQ ").append(host.getFriendCode()).append(" ").append(desiredName);
            user.sendCtcpMessage(builder.toString());
        } else {
            ChatHandler.addMessageToChat(CHANNEL, "System", "User is not online.");
        }
    }

    public static boolean hasNewMessages(String target) {
        return newMessages.get(target) != null && newMessages.get(target) != false;
    }

    public static void setMessagesRead(String target) {
        newMessages.put(target, false);
    }

    public static void acceptFriendRequest(String chatInternalName, String desiredName) {
        Optional<Channel> channelOpt = client.getChannel(CHANNEL);
        if (!channelOpt.isPresent()) {
            return;
        }
        Channel channel = channelOpt.get();
        Optional<User> userOpt = channel.getUser(chatInternalName);
        if (!userOpt.isPresent()) {
            return;
        }
        User user = userOpt.get();
        user.sendCtcpMessage("FRIENDACC " + host.getFriendCode() + " " + desiredName);
        ChatHandler.addMessageToChat(CHANNEL, "System", "Friend request accepted.");
    }

    static {
        CHANNEL = "#MineTogether";
        connectionStatus = ConnectionStatus.DISCONNECTED;
        messages = null;
        client = null;
        tries = 0;
        inited = false;
        initedString = null;
        friends = new HashMap();
        anonUsers = new HashMap();
        anonUsersReverse = new HashMap();
        random = new Random();
    }

    public static enum ConnectionStatus {
        CONNECTED("Connected", "GREEN"),
        CONNECTING("Connecting", "GOLD"),
        DISCONNECTED("Disconnected", "RED"),
        NOT_IN_CHANNEL("Not in channel", "RED");

        public final String display;
        public final String colour;

        private ConnectionStatus(String display, String colour) {
            this.display = display;
            this.colour = colour;
        }
    }

    public static class Listener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onChannnelLeave(UnexpectedChannelLeaveEvent event) {
            String reason = "Unknown";
            if (event instanceof UnexpectedChannelLeaveViaKickEvent) {
                UnexpectedChannelLeaveViaKickEvent kicked = (UnexpectedChannelLeaveViaKickEvent)event;
                reason = "Kicked - " + kicked.getMessage();
            }
            event.getChannel().join();
            Object object = ircLock;
            synchronized (object) {
                if (tries >= 4) {
                    client.shutdown();
                    ChatHandler.addMessageToChat(CHANNEL, "System", "Unable to rejoin chat. Disconnected from server");
                }
                ChatHandler.addMessageToChat(CHANNEL, "System", Format.stripAll("Removed from chat (Reason: " + reason + "). Rejoining"));
                connectionStatus = ConnectionStatus.NOT_IN_CHANNEL;
            }
        }

        @Handler
        public void onConnected(ClientNegotiationCompleteEvent event) {
            tries = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onQuit(ClientConnectionEndedEvent event) {
            String cause = "Unknown";
            if (event.getCause().isPresent()) {
                cause = event.getCause().get().getMessage();
            } else if (event instanceof ClientConnectionClosedEvent && ((ClientConnectionClosedEvent)event).getLastMessage().isPresent()) {
                cause = ((ClientConnectionClosedEvent)event).getLastMessage().get();
            }
            ++tries;
            Object object = ircLock;
            synchronized (object) {
                connectionStatus = ConnectionStatus.DISCONNECTED;
                if (tries >= 5) {
                    event.setAttemptReconnect(false);
                    ChatHandler.addMessageToChat(CHANNEL, "System", Format.stripAll("Disconnected (Reason: " + cause + "). Too many tries, not reconnecting"));
                    return;
                }
                ChatHandler.addMessageToChat(CHANNEL, "System", Format.stripAll("Disconnected (Reason: " + cause + "). Reconnecting"));
                event.setReconnectionDelay(10000);
                event.setAttemptReconnect(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onChannelJoin(ChannelJoinEvent event) {
            if (event.getChannel().getLowerCaseName().equals(CHANNEL.toLowerCase()) && client.isUser(event.getUser())) {
                Object object = ircLock;
                synchronized (object) {
                    connectionStatus = ConnectionStatus.CONNECTED;
                    ChatHandler.addMessageToChat(CHANNEL, "System", Format.stripAll("Chat joined"));
                }
            }
            ChatHandler.updateFriends(event.getChannel().getNicknames());
        }

        @Handler
        public void onChannelLeave(ChannelPartEvent event) {
            String friendNick = event.getUser().getNick();
            if (friends.containsKey(friendNick)) {
                friends.remove(friendNick);
            }
        }

        public void onUserQuit(UserQuitEvent event) {
            String friendNick = event.getUser().getNick();
            if (friends.containsKey(friendNick)) {
                friends.remove(friendNick);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onChannelMessage(ChannelMessageEvent event) {
            User user = (User)event.getActor();
            String message = event.getMessage();
            Object object = ircLock;
            synchronized (object) {
                ChatHandler.addMessageToChat(CHANNEL, user.getNick(), Format.stripAll(message));
            }
            ChatHandler.updateFriends(client.getChannel(CHANNEL).get().getNicknames());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onChannelNotice(ChannelNoticeEvent event) {
            Optional<SortedSet<ChannelUserMode>> userModes = event.getChannel().getUserModes((User)event.getActor());
            if (userModes.isPresent()) {
                SortedSet<ChannelUserMode> channelUserModes = userModes.get();
                boolean valid = false;
                for (ChannelUserMode mode : channelUserModes) {
                    switch (mode.getNickPrefix()) {
                        case '@': 
                        case '~': {
                            valid = true;
                        }
                    }
                }
                if (valid) {
                    Object object = ircLock;
                    synchronized (object) {
                        ChatHandler.addMessageToChat(CHANNEL, "System", event.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onNotice(PrivateNoticeEvent event) {
            Channel channel;
            Optional<SortedSet<ChannelUserMode>> userModesOpt;
            User user = (User)event.getActor();
            Optional<Channel> optchannel = client.getChannel(CHANNEL);
            if (optchannel.isPresent() && (userModesOpt = (channel = optchannel.get()).getUserModes(user)).isPresent()) {
                SortedSet<ChannelUserMode> channelUserModes = userModesOpt.get();
                boolean valid = false;
                for (ChannelUserMode mode : channelUserModes) {
                    switch (mode.getNickPrefix()) {
                        case '@': 
                        case '~': {
                            valid = true;
                        }
                    }
                }
                if (valid) {
                    Object object = ircLock;
                    synchronized (object) {
                        ChatHandler.addMessageToChat(CHANNEL, "System", event.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Handler
        public void onPrivateMessage(PrivateMessageEvent event) {
            String message = Format.stripAll(event.getMessage());
            String user = ((User)event.getActor()).getNick();
            if (friends.containsKey(user)) {
                Object object = ircLock;
                synchronized (object) {
                    LimitedSizeQueue<Pair<String, String>> messageQueue = messages.get(user);
                    if (messageQueue == null) {
                        messages.put(user, new LimitedSizeQueue(150));
                    }
                    ChatHandler.addMessageToChat(user, user, message);
                    host.friendEvent(user, true);
                }
            }
        }

        @Handler
        public void onCTCP(PrivateCtcpQueryEvent event) {
            if (event.isToClient()) {
                String message = event.getMessage();
                String[] split = message.split(" ");
                if (split.length < 3) {
                    return;
                }
                if (split[0].equals("FRIENDREQ")) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 1; i < split.length; ++i) {
                        builder.append(split[i]).append(" ");
                    }
                    String chatMessage = builder.toString().trim();
                    ChatHandler.addMessageToChat(CHANNEL, "FR:" + ((User)event.getActor()).getNick(), chatMessage);
                } else if (split[0].equals("FRIENDACC")) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 2; i < split.length; ++i) {
                        builder.append(split[i]).append(" ");
                    }
                    host.acceptFriend(split[1], builder.toString().trim());
                    ChatHandler.addMessageToChat(CHANNEL, "FA:" + ((User)event.getActor()).getNick(), builder.toString().trim());
                }
            }
        }

        @Handler
        public void onNickRejected(NickRejectedEvent event) {
            String attemptedNick = event.getAttemptedNick();
            if (event.getAttemptedNick().contains("`")) {
                event.setNewNick(nick);
            } else {
                event.setNewNick(nick + "`");
            }
        }
    }
}

