/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.wrappers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import thut.core.client.render.animation.AnimationHelper;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.ModelJson;
import thut.core.client.render.tabula.model.tabula.TabulaModel;
import thut.core.client.render.tabula.model.tabula.TabulaModelParser;

public class TabulaWrapper
extends ModelBase {
    final IModelRenderer<?> renderer;
    final TabulaModelParser parser;
    final TabulaModel model;
    private ModelJson modelj;
    private boolean init = false;

    public TabulaWrapper(TabulaModel model, TabulaModelParser parser, IModelRenderer<?> renderer) {
        this.model = model;
        this.parser = parser;
        this.renderer = renderer;
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (this.model == null || this.parser == null) {
            return;
        }
        this.checkInit();
        GlStateManager.func_179094_E();
        this.modelj.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        String phase;
        if (this.model == null || this.parser == null) {
            return;
        }
        this.checkInit();
        GlStateManager.func_179129_p();
        float partialTick = ageInTicks - (float)entityIn.field_70173_aa;
        CapabilityAnimation.IAnimationHolder animate = AnimationHelper.getHolder(entityIn);
        String string = phase = animate != null ? animate.getPendingAnimation() : "idle";
        if (phase == null) {
            phase = "idle";
        }
        if (this.modelj.changer != null) {
            phase = this.modelj.changer.modifyAnimation((EntityLiving)entityIn, partialTick, phase);
        }
        boolean inSet = false;
        if (animate != null) {
            if (this.modelj.animationMap.containsKey(phase) || (inSet = this.renderer.getAnimations().containsKey(phase))) {
                if (!inSet) {
                    this.modelj.startAnimation(phase, animate);
                } else {
                    this.modelj.startAnimation(this.renderer.getAnimations().get(phase), animate);
                }
            } else if (this.modelj.isAnimationInProgress(animate)) {
                this.modelj.stopAnimation(animate);
            }
        }
        this.renderer.scaleEntity(entityIn, this.model, ageInTicks - (float)entityIn.field_70173_aa);
    }

    public void func_78086_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.checkInit();
        if (!Minecraft.func_71410_x().func_147113_T()) {
            CapabilityAnimation.IAnimationHolder animate = AnimationHelper.getHolder((Entity)entity);
            this.modelj.setToInitPose();
            if (animate != null && !animate.getPlaying().isEmpty()) {
                for (Animation animation : animate.getPlaying()) {
                    this.modelj.updateAnimation(animate, animation, entity.field_70173_aa, partialTickTime, limbSwing);
                }
            }
        }
    }

    private void checkInit() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.modelj = this.parser.modelMap.get(this.model);
        this.modelj.changer = this.renderer.getAnimationChanger();
        this.modelj.texturer = this.renderer.getTexturer();
    }
}

