/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.block.BlockWaystone;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.item.IResetUseOnDamage;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoundScroll
extends Item
implements IResetUseOnDamage {
    public static final String name = "bound_scroll";
    public static final ResourceLocation registryName = new ResourceLocation("waystones", "bound_scroll");

    public ItemBoundScroll() {
        this.func_77637_a(Waystones.creativeTab);
        this.func_77655_b(registryName.toString());
    }

    public int func_77626_a(ItemStack itemStack) {
        return WaystoneConfig.general.warpScrollUseTime;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        if (Waystones.proxy.isVivecraftInstalled()) {
            return EnumAction.NONE;
        }
        return EnumAction.BOW;
    }

    private void setBoundTo(ItemStack itemStack, @Nullable WaystoneEntry entry) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        if (entry != null) {
            tagCompound.func_74782_a("WaystonesBoundTo", (NBTBase)entry.writeToNBT());
        } else {
            tagCompound.func_82580_o("WaystonesBoundTo");
        }
    }

    @Nullable
    protected WaystoneEntry getBoundTo(EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            return WaystoneEntry.read(tagCompound.func_74775_l("WaystonesBoundTo"));
        }
        return null;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileWaystone) {
            TileWaystone tileWaystone = ((TileWaystone)tileEntity).getParent();
            ((BlockWaystone)Waystones.blockWaystone).activateWaystone(player, world, tileWaystone);
            if (!world.field_72995_K) {
                this.setBoundTo(heldItem, new WaystoneEntry(tileWaystone));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("waystones:scrollBound", new Object[]{tileWaystone.getWaystoneName()}), true);
            }
            Waystones.proxy.playSound(SoundEvents.field_187802_ec, pos, 2.0f);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityLivingBase entity) {
        WaystoneEntry boundTo;
        if (!world.field_72995_K && entity instanceof EntityPlayer && (boundTo = this.getBoundTo((EntityPlayer)entity, itemStack)) != null) {
            double distance = entity.func_70011_f((double)boundTo.getPos().func_177958_n(), (double)boundTo.getPos().func_177956_o(), (double)boundTo.getPos().func_177952_p());
            if (distance <= 2.0) {
                return itemStack;
            }
            if (WaystoneManager.teleportToWaystone((EntityPlayer)entity, boundTo) && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
        }
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        WaystoneEntry boundTo = this.getBoundTo(player, itemStack);
        if (boundTo != null) {
            if (!player.func_184587_cr() && world.field_72995_K) {
                Waystones.proxy.playSound(SoundEvents.field_187814_ei, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), 2.0f);
            }
            if (Waystones.proxy.isVivecraftInstalled()) {
                this.func_77654_b(itemStack, world, (EntityLivingBase)player);
            } else {
                player.func_184598_c(hand);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        player.func_146105_b((ITextComponent)new TextComponentTranslation("waystones:scrollNotBound", new Object[0]), true);
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        WaystoneEntry lastEntry = this.getBoundTo((EntityPlayer)player, itemStack);
        if (lastEntry != null) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:boundTo", (Object[])new Object[]{TextFormatting.DARK_AQUA + lastEntry.getName()}));
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:boundTo", (Object[])new Object[]{I18n.func_135052_a((String)"tooltip.waystones:none", (Object[])new Object[0])}));
        }
    }
}

