/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.quark.world.block.BlockSpeleothem;
import vazkii.quark.world.feature.Basalt;
import vazkii.quark.world.feature.RevampStoneGen;
import vazkii.quark.world.feature.Speleothems;

public class SpeleothemGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!Speleothems.dimensionConfig.canSpawnHere(world)) {
            return;
        }
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int spread = 10;
        int tries = Speleothems.tries;
        int innerSpread = 6;
        int innerTries = Speleothems.clusterCount;
        int upperBound = Speleothems.maxHeight;
        int offset = 6;
        if (world.field_73011_w.func_177495_o()) {
            upperBound = 128;
            offset = 0;
            tries = Speleothems.netherTries;
            innerTries = Speleothems.netherClusterCount;
        }
        if (upperBound > 0) {
            for (int i = 0; i < tries; ++i) {
                BlockPos target = new BlockPos(x + random.nextInt(spread), random.nextInt(upperBound) + offset, z + random.nextInt(spread));
                if (!this.placeSpeleothemCluster(random, world, target, innerSpread, innerTries)) continue;
                ++i;
            }
        }
    }

    private boolean placeSpeleothemCluster(Random random, World world, BlockPos pos, int spread, int tries) {
        if (!this.findAndPlaceSpeleothem(random, world, pos)) {
            return false;
        }
        for (int i = 0; i < tries; ++i) {
            BlockPos target = pos.func_177982_a(random.nextInt(spread * 2 + 1) - spread, random.nextInt(spread + 1) - spread / 1, random.nextInt(spread * 2 + 1) - spread);
            this.findAndPlaceSpeleothem(random, world, target);
        }
        return true;
    }

    private boolean findAndPlaceSpeleothem(Random random, World world, BlockPos pos) {
        EnumFacing diff;
        if (!world.func_175623_d(pos)) {
            return false;
        }
        int off = world.field_73011_w.func_177495_o() ? -1000 : 0;
        boolean up = random.nextBoolean();
        EnumFacing enumFacing = diff = up ? EnumFacing.UP : EnumFacing.DOWN;
        if (!up && world.func_175710_j(pos)) {
            return false;
        }
        IBlockState stateAt = null;
        do {
            pos = pos.func_177972_a(diff);
            stateAt = world.func_180495_p(pos);
        } while (pos.func_177956_o() > 4 && pos.func_177956_o() < 200 && !stateAt.func_185913_b() && ++off < 10);
        Block type = this.getSpeleothemType(stateAt);
        this.placeSpeleothem(random, world, pos, type, !up);
        return true;
    }

    private void placeSpeleothem(Random random, World world, BlockPos pos, Block type, boolean up) {
        int size;
        if (type == null) {
            return;
        }
        EnumFacing diff = up ? EnumFacing.UP : EnumFacing.DOWN;
        int n = size = random.nextInt(3) == 0 ? 2 : 3;
        if (!up && random.nextInt(20) == 0) {
            size = 1;
        }
        for (int i = 0; i < size; ++i) {
            if (!world.func_175623_d(pos = pos.func_177972_a(diff))) {
                return;
            }
            BlockSpeleothem.EnumSize sizeType = BlockSpeleothem.EnumSize.values()[size - i - 1];
            IBlockState targetBlock = type.func_176223_P().func_177226_a(BlockSpeleothem.SIZE, (Comparable)((Object)sizeType));
            world.func_175656_a(pos, targetBlock);
        }
    }

    private Block getSpeleothemType(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150424_aL) {
            return Speleothems.netherrack_speleothem;
        }
        if (block == Blocks.field_150348_b) {
            switch ((BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a)) {
                case STONE: {
                    return Speleothems.stone_speleothem;
                }
                case ANDESITE: {
                    return Speleothems.andesite_speleothem;
                }
                case GRANITE: {
                    return Speleothems.granite_speleothem;
                }
                case DIORITE: {
                    return Speleothems.diorite_speleothem;
                }
            }
        } else {
            if (block == Basalt.basalt) {
                return Speleothems.basalt_speleothem;
            }
            if (block == RevampStoneGen.marble) {
                return Speleothems.marble_speleothem;
            }
            if (block == RevampStoneGen.limestone) {
                return Speleothems.limestone_speleothem;
            }
        }
        return null;
    }
}

