/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.experimental.world.BiomeLocator;

public class PathfinderMaps
extends Feature {
    public static Multimap<Integer, TradeInfo> trades;
    public static boolean unlockAllAtOnce;
    public static boolean multipleAtFirstUnlock;
    public static boolean printAllBiomeNames;
    private String[] customs;

    private static String getBiomeDescriptor(Biome biome) {
        ResourceLocation rl = biome.getRegistryName();
        if (rl == null) {
            return "unknown";
        }
        return rl.func_110623_a();
    }

    @Override
    public void setupConfig() {
        trades = HashMultimap.create();
        unlockAllAtOnce = this.loadPropBool("Unlock All Trades at Once", "By default, when a Cartographer levels up, a random Pathfinder Map from that level is added to their trades.\nSet this to true to add all the maps from that level to the trades instead.", false);
        multipleAtFirstUnlock = this.loadPropBool("Unlock Multiples At Level 2", "By default, when a Cartographer evolves to level 2, two or three Pathfinder Maps are unlocked.\nSet this to false to disable this, and make it only unlock one, like in the other levels.", true);
        this.loadTradeInfo(Biomes.field_76774_n, true, 2, 8, 14, 8381695, "ice_plains");
        this.loadTradeInfo(Biomes.field_76770_e, true, 2, 8, 14, 0x8A8A8A);
        this.loadTradeInfo(Biomes.field_150585_R, true, 2, 8, 14, 22794);
        this.loadTradeInfo(Biomes.field_76769_d, true, 2, 8, 14, 13416782);
        this.loadTradeInfo(Biomes.field_150588_X, true, 2, 8, 14, 10200418);
        this.loadTradeInfo(Biomes.field_76780_h, true, 3, 12, 18, 2242319);
        this.loadTradeInfo(Biomes.field_150578_U, true, 3, 12, 18, 5980703);
        this.loadTradeInfo(Biomes.field_185444_T, true, 3, 12, 18, 14449642, "flower_forest");
        this.loadTradeInfo(Biomes.field_76782_w, true, 4, 16, 22, 2274816);
        this.loadTradeInfo(Biomes.field_150589_Z, true, 4, 16, 22, 13008674);
        this.loadTradeInfo(Biomes.field_76789_p, true, 5, 20, 26, 5063283);
        this.loadTradeInfo(Biomes.field_185445_W, true, 5, 20, 26, 4314825, "ice_spikes");
        String desc = "In this section you can add custom Pathfinder Maps. This works for both vanilla and modded biomes.\nEach custom map must be on its own line.\nThe format for a custom map is as follows:\n<id>,<level>,<min_price>,<max_price>,<color>,<name>\n\nWith the following descriptions:\n - <id> being the biome's ID NAME. You can find vanilla names here - https://minecraft.gamepedia.com/Biome#Biome_IDs\n - <level> being the Cartographer villager level required for the map to be unlockable\n - <min_price> being the cheapest (in Emeralds) the map can be\n - <max_price> being the most expensive (in Emeralds) the map can be\n - <color> being a hex color (without the #) for the map to display. You can generate one here - http://htmlcolorcodes.com/\n - <name> being the display name of the map\n\nHere's an example of a map to locate Ice Mountains:\nminecraft:ice_mountains,2,8,14,7FE4FF,Ice Mountains Pathfinder Map";
        this.customs = this.loadPropStringList("Custom Map Info", desc, new String[0]);
    }

    @SubscribeEvent
    public void onRegisterVillagers(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        this.loadCustomMaps(this.customs);
        VillagerRegistry.VillagerProfession librarian = (VillagerRegistry.VillagerProfession)event.getRegistry().getValue(new ResourceLocation("minecraft:librarian"));
        if (librarian != null) {
            VillagerRegistry.VillagerCareer cartographer = librarian.getCareer(1);
            Iterator iterator = trades.keySet().iterator();
            while (iterator.hasNext()) {
                int level = (Integer)iterator.next();
                cartographer.addTrade(level, new EntityVillager.ITradeList[]{new PathfinderMapTrade(level)});
            }
        }
    }

    private void loadTradeInfo(Biome biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
        this.loadTradeInfo(biome, enabled, level, minPrice, maxPrice, color, "", "");
    }

    private void loadTradeInfo(Biome biome, boolean enabled, int level, int minPrice, int maxPrice, int color, String overrideCategory) {
        this.loadTradeInfo(biome, enabled, level, minPrice, maxPrice, color, overrideCategory, "");
    }

    private void loadTradeInfo(Biome biome, boolean enabled, int level, int minPrice, int maxPrice, int color, String overrideCategory, String overrideName) {
        String category = this.configCategory + ".";
        category = !overrideCategory.isEmpty() ? category + overrideCategory : category + PathfinderMaps.getBiomeDescriptor(biome);
        TradeInfo info = overrideName.isEmpty() ? new TradeInfo(category, biome, enabled, level, minPrice, maxPrice, color) : new TradeInfo(category, biome, enabled, level, minPrice, maxPrice, color, overrideName);
        if (info.enabled) {
            trades.put((Object)info.level, (Object)info);
        }
    }

    private void loadTradeInfo(String line) throws IllegalArgumentException {
        String[] tokens = line.split(",");
        if (tokens.length != 6) {
            throw new IllegalArgumentException("Wrong number of parameters " + tokens.length + " (expected 6)");
        }
        ResourceLocation biomeName = new ResourceLocation(tokens[0]);
        if (!Biome.field_185377_q.func_148741_d((Object)biomeName)) {
            throw new IllegalArgumentException("No biome exists with name " + biomeName);
        }
        Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)biomeName);
        int level = Integer.parseInt(tokens[1]);
        int minPrice = Integer.parseInt(tokens[2]);
        int maxPrice = Integer.parseInt(tokens[3]);
        int color = Integer.parseInt(tokens[4], 16);
        String name = tokens[5];
        this.loadTradeInfo(biome, true, level, minPrice, maxPrice, color, "", name);
    }

    private void loadCustomMaps(String[] lines) {
        for (String s : lines) {
            try {
                this.loadTradeInfo(s);
            }
            catch (IllegalArgumentException e) {
                Quark.LOG.warn("[Custom Pathfinder Maps] Error while reading custom map string \"%s\"", (Object)s);
                Quark.LOG.warn("[Custom Pathfinder Maps] - %s", (Object)e.getMessage());
            }
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public static ItemStack createMap(World world, BlockPos pos, TradeInfo info) {
        BlockPos biomePos = BiomeLocator.spiralOutwardsLookingForBiome(world, info.biome, pos.func_177958_n(), pos.func_177952_p());
        if (biomePos == null) {
            return ItemStack.field_190927_a;
        }
        int id = world.func_72841_b("map");
        ItemStack stack = new ItemStack((Item)Items.field_151098_aY, 1, id);
        stack.func_190924_f(info.name);
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"display", (boolean)false);
        cmp.func_74768_a("MapColor", info.color);
        ItemNBTHelper.setCompound((ItemStack)stack, (String)"display", (NBTTagCompound)cmp);
        String s = "map_" + id;
        MapData mapdata = new MapData(s);
        world.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = (byte)2;
        mapdata.field_76201_a = biomePos.func_177958_n() + (int)((Math.random() - 0.5) * 200.0);
        mapdata.field_76199_b = biomePos.func_177952_p() + (int)((Math.random() - 0.5) * 200.0);
        mapdata.field_76200_c = 0;
        mapdata.field_186210_e = true;
        mapdata.field_191096_f = true;
        ItemMap.func_190905_a((World)world, (ItemStack)stack);
        MapData.func_191094_a((ItemStack)stack, (BlockPos)biomePos, (String)"+", (MapDecoration.Type)MapDecoration.Type.TARGET_X);
        return stack;
    }

    public static class TradeInfo {
        public final boolean enabled;
        public final Biome biome;
        public final int level;
        public final int minPrice;
        public final int maxPrice;
        public final int color;
        public final String name;

        TradeInfo(String category, Biome biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
            this(category, biome, enabled, level, minPrice, maxPrice, color, "quark.biomeMap." + PathfinderMaps.getBiomeDescriptor(biome));
        }

        TradeInfo(String category, Biome biome, boolean enabled, int level, int minPrice, int maxPrice, int color, String name) {
            this.enabled = ModuleLoader.config.getBoolean("Enabled", category, enabled, "");
            this.biome = biome;
            this.level = ModuleLoader.config.getInt("Required Villager Level", category, level, 0, 10, "");
            this.minPrice = ModuleLoader.config.getInt("Minimum Emerald Price", category, minPrice, 1, 64, "");
            this.maxPrice = Math.max(minPrice, ModuleLoader.config.getInt("Maximum Emerald Price", category, maxPrice, 1, 64, ""));
            this.color = color;
            this.name = name;
        }
    }

    private static class PathfinderMapTrade
    implements EntityVillager.ITradeList {
        public final int level;

        public PathfinderMapTrade(int level) {
            this.level = level;
        }

        public void func_190888_a(@Nonnull IMerchant merchant, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            ArrayList infos = new ArrayList(trades.get((Object)this.level));
            if (infos.isEmpty()) {
                return;
            }
            if (unlockAllAtOnce) {
                for (TradeInfo info : infos) {
                    this.unlock(merchant, recipeList, random, info);
                }
            } else {
                int amount = this.level == 2 && multipleAtFirstUnlock ? Math.min(infos.size(), 2 + random.nextInt(2)) : 1;
                for (int i = 0; i < amount; ++i) {
                    TradeInfo info = (TradeInfo)infos.get(random.nextInt(infos.size()));
                    this.unlock(merchant, recipeList, random, info);
                    infos.remove(info);
                }
            }
        }

        private void unlock(IMerchant merchant, MerchantRecipeList recipeList, Random random, TradeInfo info) {
            int i = random.nextInt(info.maxPrice - info.minPrice + 1) + info.minPrice;
            ItemStack itemstack = PathfinderMaps.createMap(merchant.func_190670_t_(), merchant.func_190671_u_(), info);
            if (itemstack.func_190926_b()) {
                return;
            }
            MerchantRecipe recipe = new MerchantRecipe(new ItemStack(Items.field_151166_bC, i), new ItemStack(Items.field_151111_aL), itemstack, 0, 1);
            recipeList.add((Object)recipe);
        }
    }
}

