/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.audio.GuardianSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.client.sound.GuardianSound2UnderwaterBoogaloo;

public class OceanGuardians
extends Feature {
    boolean deepOceanOnly;
    int weight;
    int min;
    int max;
    boolean tweakSound;

    @Override
    public void setupConfig() {
        this.deepOceanOnly = this.loadPropBool("Deep ocean only", "", true);
        this.weight = this.loadPropInt("Spawn Weight", "Squids have 10. The higher, the more will spawn. (Note that guardians only spawn 5% of the time, so the default 4 is actually 0.8)", 4);
        this.min = this.loadPropInt("Smallest spawn group", "", 1);
        this.max = this.loadPropInt("Largest spawn group", "", 3);
        this.tweakSound = this.loadPropBool("Shut Guardians Up", "Disables guardians' attack sound if they aren't attacking a player", true);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ImmutableSet set = this.deepOceanOnly ? ImmutableSet.of((Object)Biomes.field_150575_M) : ImmutableSet.of((Object)Biomes.field_76771_b, (Object)Biomes.field_150575_M);
        for (Biome b : set) {
            b.func_76747_a(EnumCreatureType.MONSTER).add(new Biome.SpawnListEntry(EntityGuardian.class, this.weight, this.min, this.max));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onSound(PlaySoundEvent event) {
        if (!this.tweakSound) {
            return;
        }
        ISound sound = event.getSound();
        if (sound instanceof GuardianSound) {
            GuardianSound gsound = (GuardianSound)sound;
            EntityGuardian guardian = (EntityGuardian)ObfuscationReflectionHelper.getPrivateValue(GuardianSound.class, (Object)gsound, (String)"field_174934_k");
            event.setResultSound((ISound)new GuardianSound2UnderwaterBoogaloo(guardian));
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

