/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.block.BlockMod;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.world.feature.CaveRoots;

public class BlockRoots
extends BlockMod
implements IQuarkBlock,
IShearable,
IGrowable {
    public static final PropertyBool UP = BlockVine.field_176277_a;
    public static final PropertyBool NORTH = BlockVine.field_176273_b;
    public static final PropertyBool EAST = BlockVine.field_176278_M;
    public static final PropertyBool SOUTH = BlockVine.field_176279_N;
    public static final PropertyBool WEST = BlockVine.field_176280_O;
    public static final PropertyBool[] ALL_FACES = BlockVine.field_176274_P;
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
    private Random rng;

    public BlockRoots(String name) {
        super(name, Material.field_151582_l, new String[0]);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.rng = new Random();
    }

    public BlockRoots() {
        this("roots");
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextInt(2) == 0) {
            this.func_176474_b(worldIn, rand, pos, state);
        }
    }

    public static void growMany(World world, BlockPos pos, IBlockState state, float stopChance, boolean avoidCascade) {
        BlockPos next = pos;
        while ((next = BlockRoots.growAndReturnLastPos(world, next, state, avoidCascade)) != null && world.field_73012_v.nextFloat() >= stopChance) {
        }
    }

    public static BlockPos growAndReturnLastPos(World world, BlockPos pos, IBlockState state, boolean avoidCascade) {
        BlockPos down = pos.func_177977_b();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            PropertyBool prop = BlockRoots.getPropertyFor(facing);
            if (!((Boolean)state.func_177229_b((IProperty)prop)).booleanValue()) continue;
            BlockPos ret = BlockRoots.growInFacing(world, down, facing);
            if (ret == null || avoidCascade && !world.func_175667_e(ret)) break;
            IBlockState setState = BlockRoots.nextState(world.field_73012_v).func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true));
            world.func_175656_a(ret, setState);
            return ret;
        }
        return null;
    }

    public static BlockPos growInFacing(World world, BlockPos pos, EnumFacing facing) {
        if (!world.func_175623_d(pos)) {
            return null;
        }
        BlockPos check = pos.func_177972_a(facing);
        if (BlockRoots.isAcceptableNeighbor(world, check, facing.func_176734_d())) {
            return pos;
        }
        pos = check;
        if (!world.func_175623_d(check)) {
            return null;
        }
        check = pos.func_177972_a(facing);
        if (BlockRoots.isAcceptableNeighbor(world, check, facing.func_176734_d())) {
            return pos;
        }
        return null;
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return worldIn.func_175699_k(pos) < 7;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        BlockRoots.growAndReturnLastPos(worldIn, pos, state, false);
    }

    private static IBlockState nextState(Random rand) {
        if (!CaveRoots.enableFlowers || rand.nextFloat() > CaveRoots.flowerChance) {
            return CaveRoots.roots.func_176223_P();
        }
        switch (rand.nextInt(3)) {
            case 0: {
                return CaveRoots.roots_blue_flower.func_176223_P();
            }
            case 1: {
                return CaveRoots.roots_black_flower.func_176223_P();
            }
        }
        return CaveRoots.roots_white_flower.func_176223_P();
    }

    protected ItemStack getRootDrop() {
        return new ItemStack(CaveRoots.root);
    }

    protected float getDropChance() {
        return CaveRoots.rootDropChance;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        int i = 0;
        AxisAlignedBB axisalignedbb = field_185505_j;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            axisalignedbb = NORTH_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            axisalignedbb = EAST_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            axisalignedbb = SOUTH_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            axisalignedbb = WEST_AABB;
            ++i;
        }
        return i == 1 ? axisalignedbb : field_185505_j;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos).func_193401_d(worldIn, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return true;
    }

    public boolean func_176198_a(@Nonnull World worldIn, @Nonnull BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP && this.canAttachTo(worldIn, pos, side);
    }

    public boolean canAttachTo(World p_193395_1_, BlockPos p_193395_2_, EnumFacing p_193395_3_) {
        Block block = p_193395_1_.func_180495_p(p_193395_2_.func_177984_a()).func_177230_c();
        return BlockRoots.isAcceptableNeighbor(p_193395_1_, p_193395_2_.func_177972_a(p_193395_3_.func_176734_d()), p_193395_3_) && (block == Blocks.field_150350_a || block instanceof BlockRoots || BlockRoots.isAcceptableNeighbor(p_193395_1_, p_193395_2_.func_177984_a(), EnumFacing.UP));
    }

    private static boolean isAcceptableNeighbor(World p_193396_1_, BlockPos p_193396_2_, EnumFacing p_193396_3_) {
        IBlockState iblockstate = p_193396_1_.func_180495_p(p_193396_2_);
        return iblockstate.func_193401_d((IBlockAccess)p_193396_1_, p_193396_2_, p_193396_3_) == BlockFaceShape.SOLID && iblockstate.func_185904_a() == Material.field_151576_e;
    }

    private boolean recheckGrownSides(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState iblockstate = state;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate1;
            PropertyBool propertybool = BlockRoots.getPropertyFor(enumfacing);
            if (!((Boolean)state.func_177229_b((IProperty)propertybool)).booleanValue() || this.canAttachTo(worldIn, pos, enumfacing.func_176734_d()) || (iblockstate1 = worldIn.func_180495_p(pos.func_177984_a())).func_177230_c() == this && ((Boolean)iblockstate1.func_177229_b((IProperty)propertybool)).booleanValue()) continue;
            state = state.func_177226_a((IProperty)propertybool, (Comparable)Boolean.FALSE);
        }
        if (BlockRoots.getNumGrownFaces(state) == 0) {
            return false;
        }
        if (iblockstate != state) {
            worldIn.func_180501_a(pos, state, 2);
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && !this.recheckGrownSides(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false));
        return facing.func_176740_k().func_176722_c() ? iblockstate.func_177226_a((IProperty)BlockRoots.getPropertyFor(facing.func_176734_d()), (Comparable)Boolean.valueOf(true)) : iblockstate;
    }

    @Nonnull
    public List<ItemStack> getDrops(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if (this.rng.nextFloat() < this.getDropChance()) {
            return NonNullList.func_191197_a((int)1, (Object)this.getRootDrop());
        }
        return NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    }

    public void func_180657_a(@Nonnull World worldIn, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            BlockRoots.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1, 0));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf((meta & 2) != 0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, EAST, SOUTH, WEST});
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return state;
    }

    public static PropertyBool getPropertyFor(EnumFacing side) {
        switch (side) {
            case UP: {
                return UP;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: {
                return EAST;
            }
        }
        throw new IllegalArgumentException(side + " is an invalid choice");
    }

    public static int getNumGrownFaces(IBlockState state) {
        int i = 0;
        for (PropertyBool propertybool : ALL_FACES) {
            if (!((Boolean)state.func_177229_b((IProperty)propertybool)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this, 1)});
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

