/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.item;

import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.item.ItemMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.oddities.feature.TotemOfHolding;

public class ItemSoulCompass
extends ItemMod
implements IQuarkItem,
IItemPropertyGetter {
    private static final String TAG_POS_X = "posX";
    private static final String TAG_POS_Y = "posY";
    private static final String TAG_POS_Z = "posZ";
    @SideOnly(value=Side.CLIENT)
    double rotation;
    @SideOnly(value=Side.CLIENT)
    double rota;
    @SideOnly(value=Side.CLIENT)
    long lastUpdateTick;

    public ItemSoulCompass() {
        super("soul_compass", new String[0]);
        this.func_185043_a(new ResourceLocation("angle"), this);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            BlockPos pos = TotemOfHolding.getPlayerDeathPosition(entityIn);
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_X, (int)pos.func_177958_n());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Y, (int)pos.func_177956_o());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Z, (int)pos.func_177952_p());
        }
    }

    private BlockPos getPos(ItemStack stack) {
        if (stack.func_77942_o()) {
            int x = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_X, (int)0);
            int y = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Y, (int)-1);
            int z = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Z, (int)0);
            return new BlockPos(x, y, z);
        }
        return new BlockPos(0, -1, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185085_a(@Nonnull ItemStack stack, World world, EntityLivingBase entityIn) {
        double angle;
        BlockPos pos;
        EntityLivingBase entity;
        if (entityIn == null && !stack.func_82839_y()) {
            return 0.0f;
        }
        boolean hasEntity = entityIn != null;
        Object object = entity = hasEntity ? entityIn : stack.func_82836_z();
        if (world == null) {
            world = entity.field_70170_p;
        }
        if ((pos = this.getPos(stack)).func_177956_o() == world.field_73011_w.getDimension()) {
            double yaw = hasEntity ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
            yaw = MathHelper.func_191273_b((double)(yaw / 360.0), (double)1.0);
            double relAngle = this.getDeathToAngle((Entity)entity, pos) / (Math.PI * 2);
            angle = 0.5 - (yaw - 0.25 - relAngle);
        } else {
            angle = Math.random();
        }
        if (hasEntity) {
            angle = this.wobble(world, angle);
        }
        return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private double wobble(World worldIn, double angle) {
        if (worldIn.func_82737_E() != this.lastUpdateTick) {
            this.lastUpdateTick = worldIn.func_82737_E();
            double relAngle = angle - this.rotation;
            relAngle = MathHelper.func_191273_b((double)(relAngle + 0.5), (double)1.0) - 0.5;
            this.rota += relAngle * 0.1;
            this.rota *= 0.8;
            this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
        }
        return this.rotation;
    }

    @SideOnly(value=Side.CLIENT)
    private double getFrameRotation(EntityItemFrame frame) {
        return MathHelper.func_188209_b((int)(180 + frame.field_174860_b.func_176736_b() * 90));
    }

    @SideOnly(value=Side.CLIENT)
    private double getDeathToAngle(Entity entity, BlockPos blockpos) {
        return Math.atan2((double)blockpos.func_177952_p() - entity.field_70161_v, (double)blockpos.func_177958_n() - entity.field_70165_t);
    }
}

