/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.features;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;

public class PrintSuppressor
extends Feature {
    boolean suppressOut;
    boolean suppressErr;

    @Override
    public void setupConfig() {
        this.suppressOut = this.loadPropBool("Suppress STDOUT", "", true);
        this.suppressErr = this.loadPropBool("Suppress STDERR", "", false);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        Quark.LOG.warn("Quark print suppression is enabled. Important info might be missing. Suppressing STDOUT=%b, STDERR=%b", (Object)this.suppressOut, (Object)this.suppressErr);
        if (this.suppressOut) {
            this.oppressFreedomOfSpeech(System::setOut);
        }
        if (this.suppressErr) {
            this.oppressFreedomOfSpeech(System::setErr);
        }
    }

    private void oppressFreedomOfSpeech(Consumer<PrintStream> consumer) {
        PrintStream oppressedStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
        consumer.accept(oppressedStream);
    }

    @Override
    public String getFeatureDescription() {
        return "Suppresses all STDOUT (and STDERR, if enabled) messages so they don't show up in the console.\nUse this if some mod left behind debug messages and you don't want to see them.\nIf important messages end up being disabled by this, tell the modders in case to switch to a proper logger.";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

